/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;

public class XMLLogger
extends AutomaticBean
implements AuditListener {
    private static final int BASE_10 = 10;
    private static final int BASE_16 = 16;
    private static final String[] ENTITIES = new String[]{"gt", "amp", "lt", "apos", "quot"};
    private final boolean closeStream;
    private PrintWriter writer;

    public XMLLogger(OutputStream os, boolean closeStream) throws UnsupportedEncodingException {
        this.setOutputStream(os);
        this.closeStream = closeStream;
    }

    private void setOutputStream(OutputStream oS) throws UnsupportedEncodingException {
        OutputStreamWriter osw = new OutputStreamWriter(oS, "UTF-8");
        this.writer = new PrintWriter(osw);
    }

    @Override
    public void auditStarted(AuditEvent evt) {
        this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ResourceBundle compilationProperties = ResourceBundle.getBundle("checkstylecompilation");
        String version = compilationProperties.getString("checkstyle.compile.version");
        this.writer.println("<checkstyle version=\"" + version + "\">");
    }

    @Override
    public void auditFinished(AuditEvent evt) {
        this.writer.println("</checkstyle>");
        if (this.closeStream) {
            this.writer.close();
        } else {
            this.writer.flush();
        }
    }

    @Override
    public void fileStarted(AuditEvent evt) {
        this.writer.println("<file name=\"" + XMLLogger.encode(evt.getFileName()) + "\">");
    }

    @Override
    public void fileFinished(AuditEvent evt) {
        this.writer.println("</file>");
    }

    @Override
    public void addError(AuditEvent evt) {
        if (evt.getSeverityLevel() != SeverityLevel.IGNORE) {
            this.writer.print("<error line=\"" + evt.getLine() + "\"");
            if (evt.getColumn() > 0) {
                this.writer.print(" column=\"" + evt.getColumn() + "\"");
            }
            this.writer.print(" severity=\"" + evt.getSeverityLevel().getName() + "\"");
            this.writer.print(" message=\"" + XMLLogger.encode(evt.getMessage()) + "\"");
            this.writer.println(" source=\"" + XMLLogger.encode(evt.getSourceName()) + "\"/>");
        }
    }

    @Override
    public void addException(AuditEvent evt, Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<exception>");
        pw.println("<![CDATA[");
        throwable.printStackTrace(pw);
        pw.println("]]>");
        pw.println("</exception>");
        pw.flush();
        this.writer.println(XMLLogger.encode(sw.toString()));
    }

    public static String encode(String value) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    int nextSemi = value.indexOf(59, i);
                    if (nextSemi < 0 || !XMLLogger.isReference(value.substring(i, nextSemi + 1))) {
                        sb.append("&amp;");
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isReference(String ent) {
        boolean reference = false;
        if (ent.charAt(0) != '&' || !CommonUtils.endsWithChar(ent, ';')) {
            reference = false;
        } else if (ent.charAt(1) == '#') {
            int prefixLength = 2;
            int radix = 10;
            if (ent.charAt(2) == 'x') {
                ++prefixLength;
                radix = 16;
            }
            try {
                Integer.parseInt(ent.substring(prefixLength, ent.length() - 1), radix);
                reference = true;
            }
            catch (NumberFormatException ignored) {
                reference = false;
            }
        } else {
            String name = ent.substring(1, ent.length() - 1);
            for (String element : ENTITIES) {
                if (!name.equals(element)) continue;
                reference = true;
                break;
            }
        }
        return reference;
    }
}

