/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.io.Closeables;
import com.google.common.io.Flushables;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;

final class PropertyCacheFile {
    private static final String CONFIG_HASH_KEY = "configuration*?";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int MASK_0X0F = 15;
    private static final int SHIFT_4 = 4;
    private final Properties details = new Properties();
    private final Configuration config;
    private final String fileName;

    PropertyCacheFile(Configuration config, String fileName) {
        if (config == null) {
            throw new IllegalArgumentException("config can not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can not be null");
        }
        this.config = config;
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() throws IOException {
        block4: {
            String currentConfigHash;
            block3: {
                FileInputStream inStream;
                block2: {
                    currentConfigHash = PropertyCacheFile.getConfigHashCode(this.config);
                    if (!new File(this.fileName).exists()) break block3;
                    inStream = null;
                    try {
                        inStream = new FileInputStream(this.fileName);
                        this.details.load(inStream);
                        String cachedConfigHash = this.details.getProperty(CONFIG_HASH_KEY);
                        if (currentConfigHash.equals(cachedConfigHash)) break block2;
                        this.details.clear();
                        this.details.setProperty(CONFIG_HASH_KEY, currentConfigHash);
                    }
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(inStream);
                        throw throwable;
                    }
                }
                Closeables.closeQuietly(inStream);
                break block4;
            }
            this.details.setProperty(CONFIG_HASH_KEY, currentConfigHash);
        }
    }

    void persist() throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.fileName);
            this.details.store(out, null);
        }
        catch (Throwable throwable) {
            PropertyCacheFile.flushAndCloseOutStream(out);
            throw throwable;
        }
        PropertyCacheFile.flushAndCloseOutStream(out);
    }

    private static void flushAndCloseOutStream(OutputStream stream) throws IOException {
        if (stream != null) {
            Flushables.flush(stream, false);
        }
        Closeables.close(stream, false);
    }

    boolean isInCache(String uncheckedFileName, long timestamp) {
        String lastChecked = this.details.getProperty(uncheckedFileName);
        return lastChecked != null && lastChecked.equals(Long.toString(timestamp));
    }

    void put(String checkedFileName, long timestamp) {
        this.details.setProperty(checkedFileName, Long.toString(timestamp));
    }

    private static String getConfigHashCode(Serializable object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
            }
            catch (Throwable throwable) {
                PropertyCacheFile.flushAndCloseOutStream(oos);
                throw throwable;
            }
            PropertyCacheFile.flushAndCloseOutStream(oos);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(baos.toByteArray());
            return PropertyCacheFile.hexEncode(md.digest());
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Unable to calculate hashcode.", ex);
        }
    }

    private static String hexEncode(byte ... byteArray) {
        StringBuilder buf = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            int low = b & 0xF;
            int high = b >> 4 & 0xF;
            buf.append(HEX_CHARS[high]);
            buf.append(HEX_CHARS[low]);
        }
        return buf.toString();
    }
}

