/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.openstreetmap.josm.gui.layer.ImageProcessor;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.rasterfilters.model.FiltersManager;
import org.openstreetmap.josm.plugins.rasterfilters.preferences.FiltersDownloader;

public class FiltersDialog {
    public JFrame frame;
    private JComboBox<String> filterChooser;
    private JPanel pane;
    private JButton addButton;
    private DefaultComboBoxModel<String> listModel = new DefaultComboBoxModel();
    private Set<String> showedFiltersTitles = new HashSet<String>();
    private JPanel filterContainer;
    private Layer layer;
    private FiltersManager filtersManager;
    private JScrollPane filterContainerScroll;

    public FiltersDialog(ImageryLayer layer) {
        this.layer = layer;
        this.filtersManager = new FiltersManager(this);
        layer.addImageProcessor((ImageProcessor)this.filtersManager);
    }

    public JPanel createFilterContainer() {
        if (this.filterContainer == null) {
            this.filterContainer = new JPanel();
            this.filterContainer.setLayout(new BoxLayout(this.getFilterContainer(), 1));
            this.filterContainer.setBackground(Color.white);
            this.filterContainerScroll = new JScrollPane(this.getFilterContainer(), 20, 30);
            this.pane.add(this.filterContainerScroll);
        }
        return this.filterContainer;
    }

    public void deleteFilterContainer() {
        Container parent = this.filterContainerScroll.getParent();
        this.filterContainerScroll.removeAll();
        ((JPanel)parent).remove(this.filterContainerScroll);
        this.filterContainer = null;
        parent.revalidate();
        parent.repaint();
    }

    public JFrame createAndShowGUI() throws MalformedURLException {
        this.listModel.removeAllElements();
        Set<String> filterTitles = FiltersDownloader.filterTitles;
        for (String temp : filterTitles) {
            if (this.showedFiltersTitles.contains(temp)) continue;
            this.listModel.addElement(temp);
        }
        if (this.frame != null) {
            this.filterChooser.setModel(this.listModel);
            this.filterChooser.revalidate();
            this.frame.setVisible(true);
        } else {
            this.frame = new JFrame();
            String title = "Filters | " + this.layer.getName();
            this.frame.setTitle(title);
            this.frame.setMinimumSize(new Dimension(350, 420));
            this.frame.setPreferredSize(new Dimension(350, 420));
            this.pane = new JPanel();
            this.pane.setLayout(new BoxLayout(this.pane, 1));
            this.pane.setBorder(new EmptyBorder(10, 5, 10, 5));
            this.pane.setPreferredSize(new Dimension(300, 400));
            this.pane.setBackground(Color.white);
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BoxLayout(topPanel, 1));
            topPanel.setMaximumSize(new Dimension(300, 50));
            topPanel.setMinimumSize(new Dimension(300, 50));
            topPanel.setBackground(Color.white);
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 0));
            labelPanel.setMaximumSize(new Dimension(300, 20));
            labelPanel.setBackground(Color.white);
            JLabel label = new JLabel("Add filter");
            labelPanel.add(label);
            JPanel chooseFilterPanel = new JPanel();
            chooseFilterPanel.setMinimumSize(new Dimension(300, 30));
            chooseFilterPanel.setLayout(new BoxLayout(chooseFilterPanel, 0));
            chooseFilterPanel.setBackground(Color.white);
            this.filterChooser = new JComboBox<String>(this.getListModel());
            this.filterChooser.setMaximumSize(new Dimension(200, 30));
            chooseFilterPanel.add(this.filterChooser);
            chooseFilterPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            this.addButton = new JButton();
            this.addButton.setText("add");
            this.addButton.setAlignmentX(0.5f);
            this.addButton.setMaximumSize(new Dimension(90, 30));
            this.addButton.addActionListener(new AddFilterToPanelListener());
            chooseFilterPanel.add(this.getAddButton());
            topPanel.add(labelPanel);
            topPanel.add(chooseFilterPanel);
            this.pane.add(topPanel);
            this.frame.setContentPane(this.pane);
            this.frame.pack();
            this.frame.setVisible(true);
        }
        if (FiltersDownloader.filterTitles.isEmpty() || this.listModel.getSize() == 0) {
            this.addButton.setEnabled(false);
            this.filterChooser.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
            this.filterChooser.setEnabled(true);
        }
        return this.frame;
    }

    public FiltersManager createFilterManager() {
        return new FiltersManager(this);
    }

    public void closeFrame() {
        if (this.frame != null && this.frame.isShowing()) {
            this.frame.dispose();
        }
    }

    public FiltersManager getFiltersManager() {
        return this.filtersManager;
    }

    public Set<String> getShowedFiltersTitles() {
        return this.showedFiltersTitles;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public JPanel getFilterContainer() {
        return this.filterContainer;
    }

    public DefaultComboBoxModel<String> getListModel() {
        return this.listModel;
    }

    public JComboBox<String> getFilterChooser() {
        return this.filterChooser;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    class AddFilterToPanelListener
    implements ActionListener {
        AddFilterToPanelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String title = (String)FiltersDialog.this.listModel.getSelectedItem();
            JPanel panel = null;
            panel = FiltersDialog.this.filtersManager.createPanelByTitle(title);
            if (panel != null) {
                FiltersDialog.this.filterContainer = FiltersDialog.this.createFilterContainer();
                FiltersDialog.this.filterContainer.add(panel);
            }
            FiltersDialog.this.listModel.removeElement(title);
            FiltersDialog.this.showedFiltersTitles.add(title);
            if (FiltersDialog.this.listModel.getSize() == 0) {
                FiltersDialog.this.filterChooser.setEnabled(false);
                FiltersDialog.this.addButton.setEnabled(false);
            }
        }
    }
}

