/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.checks.javadoc.HtmlTag;
import java.util.List;

class TagParser {
    private final List<HtmlTag> tags = Lists.newLinkedList();

    public TagParser(String[] text, int lineNo) {
        this.parseTags(text, lineNo);
    }

    public HtmlTag nextTag() {
        return this.tags.remove(0);
    }

    public boolean hasNextTag() {
        return !this.tags.isEmpty();
    }

    private void add(HtmlTag tag) {
        this.tags.add(tag);
    }

    private void parseTags(String[] text, int lineNo) {
        int nLines = text.length;
        Point position = new Point(0, 0);
        position = TagParser.findChar(text, '<', position);
        while (position.getLineNo() < nLines) {
            if (TagParser.isCommentTag(text, position)) {
                position = TagParser.skipHtmlComment(text, position);
            } else if (!TagParser.isTag(text, position)) {
                position = TagParser.getNextCharPos(text, position);
            } else {
                Point endTag = TagParser.findChar(text, '>', position);
                boolean incompleteTag = endTag.getLineNo() >= nLines;
                String tagId = incompleteTag ? "" : TagParser.getTagId(text, position);
                boolean closedTag = endTag.getLineNo() < nLines && text[endTag.getLineNo()].charAt(endTag.getColumnNo() - 1) == '/';
                this.add(new HtmlTag(tagId, position.getLineNo() + lineNo, position.getColumnNo(), closedTag, incompleteTag, text[position.getLineNo()]));
                position = endTag;
            }
            position = TagParser.findChar(text, '<', position);
        }
    }

    private static boolean isTag(String[] javadocText, Point pos) {
        String text;
        int column = pos.getColumnNo() + 1;
        return column < (text = javadocText[pos.getLineNo()]).length() && (Character.isJavaIdentifierStart(text.charAt(column)) || text.charAt(column) == '/') || column >= text.length();
    }

    private static String getTagId(String[] javadocText, Point tagStart) {
        String text;
        int column = tagStart.getColumnNo() + 1;
        if (column >= (text = javadocText[tagStart.getLineNo()]).length()) {
            return "";
        }
        if (text.charAt(column) == '/') {
            ++column;
        }
        text = text.substring(column).trim();
        for (column = 0; column < text.length() && (Character.isJavaIdentifierStart(text.charAt(column)) || Character.isJavaIdentifierPart(text.charAt(column))); ++column) {
        }
        return text.substring(0, column);
    }

    private static boolean isCommentTag(String[] text, Point pos) {
        return text[pos.getLineNo()].startsWith("<!--", pos.getColumnNo());
    }

    private static Point skipHtmlComment(String[] text, Point from) {
        Point to = from;
        to = TagParser.findChar(text, '>', to);
        while (!text[to.getLineNo()].substring(0, to.getColumnNo() + 1).endsWith("-->")) {
            to = TagParser.findChar(text, '>', TagParser.getNextCharPos(text, to));
        }
        return to;
    }

    private static Point findChar(String[] text, char character, Point from) {
        Point curr = new Point(from.getLineNo(), from.getColumnNo());
        while (curr.getLineNo() < text.length && text[curr.getLineNo()].charAt(curr.getColumnNo()) != character) {
            curr = TagParser.getNextCharPos(text, curr);
        }
        return curr;
    }

    private static Point getNextCharPos(String[] text, Point from) {
        int line = from.getLineNo();
        int column = from.getColumnNo() + 1;
        while (line < text.length && column >= text[line].length()) {
            column = 0;
            if (++line >= text.length) continue;
            String currentLine = text[line];
            while (column < currentLine.length() && (Character.isWhitespace(currentLine.charAt(column)) || currentLine.charAt(column) == '*')) {
                if (++column >= currentLine.length() || currentLine.charAt(column - 1) != '*' || currentLine.charAt(column) != '/') continue;
                column = currentLine.length();
            }
        }
        return new Point(line, column);
    }

    private static final class Point {
        private final int line;
        private final int column;

        public Point(int lineNo, int columnNo) {
            this.line = lineNo;
            this.column = columnNo;
        }

        public int getLineNo() {
            return this.line;
        }

        public int getColumnNo() {
            return this.column;
        }
    }
}

