/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class SimplifyBooleanReturnCheck
extends Check {
    public static final String MSG_KEY = "simplify.boolreturn";

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{83};
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST elseLiteral = ast.findFirstToken(92);
        if (elseLiteral == null) {
            return;
        }
        AST elseStatement = elseLiteral.getFirstChild();
        DetailAST condition = ast.getFirstChild().getNextSibling();
        AST thenStatement = condition.getNextSibling().getNextSibling();
        if (SimplifyBooleanReturnCheck.returnsOnlyBooleanLiteral(thenStatement) && SimplifyBooleanReturnCheck.returnsOnlyBooleanLiteral(elseStatement)) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean returnsOnlyBooleanLiteral(AST ast) {
        if (SimplifyBooleanReturnCheck.isBooleanLiteralReturnStatement(ast)) {
            return true;
        }
        AST firstStmnt = ast.getFirstChild();
        return SimplifyBooleanReturnCheck.isBooleanLiteralReturnStatement(firstStmnt);
    }

    private static boolean isBooleanLiteralReturnStatement(AST ast) {
        if (ast == null || ast.getType() != 88) {
            return false;
        }
        AST expr = ast.getFirstChild();
        if (expr.getType() == 45) {
            return false;
        }
        AST value = expr.getFirstChild();
        return SimplifyBooleanReturnCheck.isBooleanLiteralType(value.getType());
    }

    private static boolean isBooleanLiteralType(int tokenType) {
        boolean iastrue = tokenType == 133;
        boolean isFalse = tokenType == 134;
        return iastrue || isFalse;
    }
}

