/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.ArrayDeque;
import java.util.Deque;

public final class ReturnCountCheck
extends AbstractFormatCheck {
    public static final String MSG_KEY = "return.count";
    private static final int DEFAULT_MAX = 2;
    private final Deque<Context> contextStack = new ArrayDeque<Context>();
    private int max;
    private Context context;

    public ReturnCountCheck() {
        super("^equals$");
        this.setMax(2);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{8, 9, 181, 88};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{88};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{8, 9, 181, 88};
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.context = new Context(false);
        this.contextStack.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: {
                this.visitMethodDef(ast);
                break;
            }
            case 181: {
                this.visitLambda();
                break;
            }
            case 88: {
                this.context.visitLiteralReturn();
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: 
            case 181: {
                this.leave(ast);
                break;
            }
            case 88: {
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    private void visitMethodDef(DetailAST ast) {
        this.contextStack.push(this.context);
        DetailAST methodNameAST = ast.findFirstToken(58);
        boolean check = !this.getRegexp().matcher(methodNameAST.getText()).find();
        this.context = new Context(check);
    }

    private void leave(DetailAST ast) {
        this.context.checkCount(ast);
        this.context = this.contextStack.pop();
    }

    private void visitLambda() {
        this.contextStack.push(this.context);
        this.context = new Context(true);
    }

    private class Context {
        private final boolean checking;
        private int count;

        public Context(boolean checking) {
            this.checking = checking;
            this.count = 0;
        }

        public void visitLiteralReturn() {
            ++this.count;
        }

        public void checkCount(DetailAST ast) {
            if (this.checking && this.count > ReturnCountCheck.this.getMax()) {
                ReturnCountCheck.this.log(ast.getLineNo(), ast.getColumnNo(), ReturnCountCheck.MSG_KEY, this.count, ReturnCountCheck.this.getMax());
            }
        }
    }
}

