/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Deque;

public abstract class AbstractSuperCheck
extends Check {
    public static final String MSG_KEY = "missing.super.call";
    private final Deque<MethodNode> methodStack = Lists.newLinkedList();

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 79};
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    protected abstract String getMethodName();

    @Override
    public void beginTree(DetailAST rootAST) {
        this.methodStack.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.isOverridingMethod(ast)) {
            this.methodStack.add(new MethodNode(ast));
        } else if (this.isSuperCall(ast)) {
            MethodNode methodNode = this.methodStack.getLast();
            methodNode.setCallingSuper();
        }
    }

    private boolean isSuperCall(DetailAST literalSuperAst) {
        if (literalSuperAst.getType() != 79) {
            return false;
        }
        DetailAST dotAst = literalSuperAst.getParent();
        if (dotAst.getType() != 59 || this.isSameNameMethod(literalSuperAst) || this.hasArguments(dotAst)) {
            return false;
        }
        while (dotAst != null) {
            if (dotAst.getType() == 9) {
                return this.isOverridingMethod(dotAst);
            }
            if (dotAst.getType() == 8 || dotAst.getType() == 11) {
                return false;
            }
            dotAst = dotAst.getParent();
        }
        return false;
    }

    private boolean hasArguments(DetailAST methodCallDotAst) {
        DetailAST argumentsList = methodCallDotAst.getNextSibling();
        return argumentsList.getChildCount() > 0;
    }

    private boolean isSameNameMethod(DetailAST ast) {
        AST sibling = ast.getNextSibling();
        if (sibling != null && sibling.getType() == 163) {
            sibling = sibling.getNextSibling();
        }
        if (sibling == null || sibling.getType() != 58) {
            return true;
        }
        String name = sibling.getText();
        return !this.getMethodName().equals(name);
    }

    @Override
    public void leaveToken(DetailAST ast) {
        MethodNode methodNode;
        if (this.isOverridingMethod(ast) && !(methodNode = this.methodStack.removeLast()).isCallingSuper()) {
            DetailAST methodAST = methodNode.getMethod();
            DetailAST nameAST = methodAST.findFirstToken(58);
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), MSG_KEY, nameAST.getText());
        }
    }

    private boolean isOverridingMethod(DetailAST ast) {
        if (ast.getType() != 9 || ScopeUtils.inInterfaceOrAnnotationBlock(ast)) {
            return false;
        }
        DetailAST nameAST = ast.findFirstToken(58);
        String name = nameAST.getText();
        DetailAST modifiersAST = ast.findFirstToken(5);
        if (!this.getMethodName().equals(name) || modifiersAST.branchContains(66)) {
            return false;
        }
        DetailAST params = ast.findFirstToken(20);
        return params.getChildCount() == 0;
    }

    private static class MethodNode {
        private final DetailAST method;
        private boolean callingSuper;

        public MethodNode(DetailAST ast) {
            this.method = ast;
            this.callingSuper = false;
        }

        public void setCallingSuper() {
            this.callingSuper = true;
        }

        public boolean isCallingSuper() {
            return this.callingSuper;
        }

        public DetailAST getMethod() {
            return this.method;
        }
    }
}

