/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.ant;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.SeverityLevelCounter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class CheckstyleAntTask
extends Task {
    private static final String E_XML = "xml";
    private static final String E_PLAIN = "plain";
    private Path classpath;
    private String fileName;
    private String configLocation;
    private boolean failOnViolation = true;
    private String failureProperty;
    private final List<FileSet> fileSets = Lists.newArrayList();
    private final List<Formatter> formatters = Lists.newArrayList();
    private final List<Property> overrideProps = Lists.newArrayList();
    private File propertiesFile;
    private int maxErrors;
    private int maxWarnings = Integer.MAX_VALUE;
    private boolean omitIgnoredModules = true;

    public void setFailureProperty(String propertyName) {
        this.failureProperty = propertyName;
    }

    public void setFailOnViolation(boolean fail) {
        this.failOnViolation = fail;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public void setMaxWarnings(int maxWarnings) {
        this.maxWarnings = maxWarnings;
    }

    public void addFileset(FileSet fS) {
        this.fileSets.add(fS);
    }

    public void addFormatter(Formatter formatter) {
        this.formatters.add(formatter);
    }

    public void addProperty(Property property) {
        this.overrideProps.add(property);
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public void setClasspathRef(Reference classpathRef) {
        this.createClasspath().setRefid(classpathRef);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setFile(File file) {
        this.fileName = file.getAbsolutePath();
    }

    public void setConfig(File file) {
        this.setConfigLocation(file.getAbsolutePath());
    }

    public void setConfigURL(URL url) {
        this.setConfigLocation(url.toExternalForm());
    }

    private void setConfigLocation(String location) {
        if (this.configLocation != null) {
            throw new BuildException("Attributes 'config' and 'configURL' must not be set at the same time");
        }
        this.configLocation = location;
    }

    public void setOmitIgnoredModules(boolean omit) {
        this.omitIgnoredModules = omit;
    }

    public void setProperties(File props) {
        this.propertiesFile = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        long startTime = System.currentTimeMillis();
        try {
            this.realExecute();
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.log("Total execution took " + (endTime - startTime) + " ms.", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realExecute() {
        ResourceBundle compilationProperties = ResourceBundle.getBundle("checkstylecompilation");
        String version = compilationProperties.getString("checkstyle.compile.version");
        String compileTimestamp = compilationProperties.getString("checkstyle.compile.timestamp");
        this.log("checkstyle version " + version, 3);
        this.log("compiled on " + compileTimestamp, 3);
        if (this.fileName == null && this.fileSets.isEmpty()) {
            throw new BuildException("Must specify at least one of 'file' or nested 'fileset'.", this.getLocation());
        }
        if (this.configLocation == null) {
            throw new BuildException("Must specify 'config'.", this.getLocation());
        }
        Checker c = null;
        try {
            boolean ok;
            c = this.createChecker();
            SeverityLevelCounter warningCounter = new SeverityLevelCounter(SeverityLevel.WARNING);
            c.addListener(warningCounter);
            long startTime = System.currentTimeMillis();
            List<File> files = this.scanFileSets();
            long endTime = System.currentTimeMillis();
            this.log("To locate the files took " + (endTime - startTime) + " ms.", 3);
            this.log("Running Checkstyle " + version + " on " + files.size() + " files", 2);
            this.log("Using configuration " + this.configLocation, 3);
            startTime = System.currentTimeMillis();
            int numErrs = c.process(files);
            endTime = System.currentTimeMillis();
            this.log("To process the files took " + (endTime - startTime) + " ms.", 3);
            int numWarnings = warningCounter.getCount();
            boolean bl = ok = numErrs <= this.maxErrors && numWarnings <= this.maxWarnings;
            if (!ok) {
                String failureMsg = "Got " + numErrs + " errors and " + numWarnings + " warnings.";
                if (this.failureProperty != null) {
                    this.getProject().setProperty(this.failureProperty, failureMsg);
                }
                if (this.failOnViolation) {
                    throw new BuildException(failureMsg, this.getLocation());
                }
            }
        }
        finally {
            if (c != null) {
                c.destroy();
            }
        }
    }

    private Checker createChecker() {
        Checker c = null;
        try {
            AuditListener[] listeners;
            Properties props = this.createOverridingProperties();
            Configuration config = ConfigurationLoader.loadConfiguration(this.configLocation, (PropertyResolver)new PropertiesExpander(props), this.omitIgnoredModules);
            DefaultContext context = new DefaultContext();
            AntClassLoader loader = new AntClassLoader(this.getProject(), this.classpath);
            context.add("classloader", loader);
            ClassLoader moduleClassLoader = Checker.class.getClassLoader();
            context.add("moduleClassLoader", moduleClassLoader);
            c = new Checker();
            c.contextualize(context);
            c.configure(config);
            for (AuditListener element : listeners = this.getListeners()) {
                c.addListener(element);
            }
        }
        catch (Exception e) {
            throw new BuildException("Unable to create a Checker: " + e.getMessage(), (Throwable)e);
        }
        return c;
    }

    private Properties createOverridingProperties() {
        Properties retVal = new Properties();
        if (this.propertiesFile != null) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(this.propertiesFile);
                retVal.load(inStream);
            }
            catch (IOException e) {
                try {
                    throw new BuildException("Error loading Properties file '" + this.propertiesFile + "'", (Throwable)e, this.getLocation());
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(inStream);
                    throw throwable;
                }
            }
            Closeables.closeQuietly(inStream);
        }
        Hashtable antProps = this.getProject().getProperties();
        for (Map.Entry entry : antProps.entrySet()) {
            String value = String.valueOf(entry.getValue());
            retVal.put(entry.getKey(), value);
        }
        for (Property p : this.overrideProps) {
            retVal.put(p.getKey(), p.getValue());
        }
        return retVal;
    }

    private AuditListener[] getListeners() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        int formatterCount = Math.max(1, this.formatters.size());
        AuditListener[] listeners = new AuditListener[formatterCount];
        if (this.formatters.isEmpty()) {
            LogOutputStream debug = new LogOutputStream((Task)this, 4);
            LogOutputStream err = new LogOutputStream((Task)this, 0);
            listeners[0] = new DefaultLogger((OutputStream)debug, true, (OutputStream)err, true);
        } else {
            for (int i = 0; i < formatterCount; ++i) {
                Formatter f = this.formatters.get(i);
                listeners[i] = f.createListener(this);
            }
        }
        return listeners;
    }

    protected List<File> scanFileSets() {
        ArrayList<File> list = Lists.newArrayList();
        if (this.fileName != null) {
            this.log("Adding standalone file for audit", 3);
            list.add(new File(this.fileName));
        }
        for (int i = 0; i < this.fileSets.size(); ++i) {
            FileSet fs = this.fileSets.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] names = ds.getIncludedFiles();
            this.log(i + ") Adding " + names.length + " files from directory " + ds.getBasedir(), 3);
            for (String element : names) {
                String pathname = ds.getBasedir() + File.separator + element;
                list.add(new File(pathname));
            }
        }
        return list;
    }

    public static class Listener {
        private String classname;

        public String getClassname() {
            return this.classname;
        }

        public void setClassname(String classname) {
            this.classname = classname;
        }
    }

    public static class Property {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setFile(File value) {
            this.setValue(value.getAbsolutePath());
        }
    }

    public static class Formatter {
        private FormatterType formatterType;
        private File toFile;
        private boolean useFile = true;

        public void setType(FormatterType type) {
            String val = type.getValue();
            if (!CheckstyleAntTask.E_XML.equals(val) && !CheckstyleAntTask.E_PLAIN.equals(val)) {
                throw new BuildException("Invalid formatter type: " + val);
            }
            this.formatterType = type;
        }

        public void setTofile(File to) {
            this.toFile = to;
        }

        public void setUseFile(boolean use) {
            this.useFile = use;
        }

        public AuditListener createListener(Task task) throws IOException {
            if (this.formatterType != null && CheckstyleAntTask.E_XML.equals(this.formatterType.getValue())) {
                return this.createXMLLogger(task);
            }
            return this.createDefaultLogger(task);
        }

        private AuditListener createDefaultLogger(Task task) throws IOException {
            if (this.toFile == null || !this.useFile) {
                return new DefaultLogger((OutputStream)new LogOutputStream(task, 4), true, (OutputStream)new LogOutputStream(task, 0), true);
            }
            return new DefaultLogger(new FileOutputStream(this.toFile), true);
        }

        private AuditListener createXMLLogger(Task task) throws IOException {
            if (this.toFile == null || !this.useFile) {
                return new XMLLogger((OutputStream)new LogOutputStream(task, 2), true);
            }
            return new XMLLogger(new FileOutputStream(this.toFile), true);
        }
    }

    public static class FormatterType
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"xml", "plain"};

        public String[] getValues() {
            return (String[])VALUES.clone();
        }
    }
}

