/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.utils;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.gui.FinishedUploadDialog;
import org.openstreetmap.josm.tools.I18n;

public class PluginState {
    private static int runningDownloads = 0;
    protected static int imagesToUpload = 0;
    public static int imagesUploaded = 0;

    public static void startDownload() {
        ++runningDownloads;
    }

    public static void finishDownload() {
        if (runningDownloads == 0) {
            throw new IllegalStateException("The amount of running downlaods is less or equals to 0");
        }
        --runningDownloads;
    }

    public static boolean isDownloading() {
        return runningDownloads > 0;
    }

    public static boolean isUploading() {
        return imagesToUpload > imagesUploaded;
    }

    public static void imagesToUpload(int amount) {
        if (imagesToUpload <= imagesUploaded) {
            imagesToUpload = 0;
            imagesUploaded = 0;
        }
        imagesToUpload += amount;
    }

    public static void imageUploaded() {
        if (imagesToUpload == ++imagesUploaded && Main.main != null) {
            PluginState.finishedUploadDialog();
        }
    }

    private static void finishedUploadDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginState.finishedUploadDialog();
                }
            });
        } else {
            JOptionPane pane = new JOptionPane();
            pane.setMessage(new FinishedUploadDialog());
            JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Finished upload", (Object[])new Object[0]));
            dlg.setVisible(true);
        }
    }

    public static String getUploadString() {
        return I18n.tr((String)"Uploading: {0}", (Object[])new Object[]{"(" + imagesUploaded + "/" + imagesToUpload + ")"});
    }
}

