/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.mode;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandMove;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandTurn;
import org.openstreetmap.josm.plugins.mapillary.mode.AbstractMode;
import org.openstreetmap.josm.tools.I18n;

public class SelectMode
extends AbstractMode {
    private Point start;
    private int lastButton;
    private MapillaryAbstractImage closest;
    private MapillaryAbstractImage lastClicked;
    private MapillaryRecord record = MapillaryRecord.getInstance();
    private boolean nothingHighlighted;
    private boolean imageHighlighted = false;

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastButton = e.getButton();
        if (e.getButton() != 1) {
            return;
        }
        MapillaryAbstractImage closest = this.getClosest(e.getPoint());
        if (!(Main.map.mapView.getActiveLayer() instanceof MapillaryLayer) && closest != null && Main.map.mapMode == Main.map.mapModeSelect) {
            this.lastClicked = this.closest;
            this.data.setSelectedImage(closest);
            return;
        }
        if (Main.map.mapView.getActiveLayer() != MapillaryLayer.getInstance()) {
            return;
        }
        if (e.getClickCount() == 2 && this.data.getSelectedImage() != null && closest != null) {
            for (MapillaryAbstractImage img : closest.getSequence().getImages()) {
                this.data.addMultiSelectedImage(img);
            }
        }
        this.start = e.getPoint();
        this.lastClicked = this.closest;
        this.closest = closest;
        if (this.data.getMultiSelectedImages().contains(closest)) {
            return;
        }
        if (e.getModifiers() == 18 && closest != null) {
            this.data.addMultiSelectedImage(closest);
        } else if (e.getModifiers() == 17 && this.lastClicked instanceof MapillaryImage) {
            if (this.closest != null && this.lastClicked != null && this.closest.getSequence() == this.lastClicked.getSequence()) {
                int j;
                int i = this.closest.getSequence().getImages().indexOf(this.closest);
                if (i < (j = this.lastClicked.getSequence().getImages().indexOf(this.lastClicked))) {
                    this.data.addMultiSelectedImage(new ArrayList<MapillaryAbstractImage>(this.closest.getSequence().getImages().subList(i, j + 1)));
                } else {
                    this.data.addMultiSelectedImage(new ArrayList<MapillaryAbstractImage>(this.closest.getSequence().getImages().subList(j, i + 1)));
                }
            }
        } else {
            this.data.setSelectedImage(closest);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (Main.map.mapView.getActiveLayer() != MapillaryLayer.getInstance()) {
            return;
        }
        if (!Main.pref.getBoolean("mapillary.developer")) {
            for (MapillaryAbstractImage img : this.data.getMultiSelectedImages()) {
                if (!(img instanceof MapillaryImage)) continue;
                return;
            }
        }
        if (this.data.getSelectedImage() != null) {
            if (this.lastButton == 1 && !e.isShiftDown()) {
                LatLon to = Main.map.mapView.getLatLon(e.getX(), e.getY());
                LatLon from = Main.map.mapView.getLatLon(this.start.getX(), this.start.getY());
                for (MapillaryAbstractImage img : this.data.getMultiSelectedImages()) {
                    img.move(to.getX() - from.getX(), to.getY() - from.getY());
                }
                Main.map.repaint();
            } else if (this.lastButton == 1 && e.isShiftDown()) {
                this.closest.turn(Math.toDegrees(Math.atan2(e.getX() - this.start.x, -(e.getY() - this.start.y))) - this.closest.getTempCa());
                for (MapillaryAbstractImage img : this.data.getMultiSelectedImages()) {
                    img.turn(Math.toDegrees(Math.atan2(e.getX() - this.start.x, -(e.getY() - this.start.y))) - this.closest.getTempCa());
                }
                Main.map.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.data.getSelectedImage() == null) {
            return;
        }
        if (this.data.getSelectedImage().getTempCa() != this.data.getSelectedImage().getCa()) {
            double from = this.data.getSelectedImage().getTempCa();
            double to = this.data.getSelectedImage().getCa();
            this.record.addCommand(new CommandTurn(this.data.getMultiSelectedImages(), to - from));
        } else if (this.data.getSelectedImage().getTempLatLon() != this.data.getSelectedImage().getLatLon()) {
            LatLon from = this.data.getSelectedImage().getTempLatLon();
            LatLon to = this.data.getSelectedImage().getLatLon();
            this.record.addCommand(new CommandMove(this.data.getMultiSelectedImages(), to.getX() - from.getX(), to.getY() - from.getY()));
        }
        for (MapillaryAbstractImage img : this.data.getMultiSelectedImages()) {
            if (img == null) continue;
            img.stopMoving();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        MapillaryAbstractImage closestTemp = this.getClosest(e.getPoint());
        if (Main.map.mapView.getActiveLayer() instanceof OsmDataLayer && Main.map.mapMode != Main.map.mapModeSelect) {
            return;
        }
        if (closestTemp != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer && !this.imageHighlighted) {
            Main.map.mapMode.putValue("active", (Object)Boolean.FALSE);
            this.imageHighlighted = true;
        } else if (closestTemp == null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer && this.imageHighlighted && this.nothingHighlighted) {
            this.nothingHighlighted = false;
            Main.map.mapMode.putValue("active", (Object)Boolean.TRUE);
        } else if (this.imageHighlighted && !this.nothingHighlighted && Main.map.mapView.getEditLayer().data != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer) {
            for (OsmPrimitive primivitive : Main.map.mapView.getEditLayer().data.allPrimitives()) {
                primivitive.setHighlighted(false);
            }
            this.imageHighlighted = false;
            this.nothingHighlighted = true;
        }
        if (this.data.getHighlightedImage() != closestTemp && closestTemp != null) {
            this.data.setHighlightedImage(closestTemp);
            MapillaryMainDialog.getInstance().setImage(closestTemp);
            MapillaryMainDialog.getInstance().updateImage(false);
        } else if (this.data.getHighlightedImage() != closestTemp && closestTemp == null) {
            this.data.setHighlightedImage(null);
            MapillaryMainDialog.getInstance().setImage(this.data.getSelectedImage());
            MapillaryMainDialog.getInstance().updateImage();
        }
        MapillaryData.dataUpdated();
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
    }

    public String toString() {
        return I18n.tr((String)"Select mode", (Object[])new Object[0]);
    }
}

