/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.ImageProcessor;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.rasterfilters.actions.ShowLayerFiltersDialog;
import org.openstreetmap.josm.plugins.rasterfilters.gui.FiltersDialog;
import org.openstreetmap.josm.plugins.rasterfilters.preferences.FiltersDownloader;
import org.openstreetmap.josm.plugins.rasterfilters.preferences.RasterFiltersPreferences;

public class RasterFiltersPlugin
extends Plugin
implements MapView.LayerChangeListener {
    private SideButton filterButton;
    private ShowLayerFiltersDialog action;
    private PreferenceSetting setting;

    public RasterFiltersPlugin(PluginInformation info) {
        super(info);
        Main.debug((String)"Loading RasterFiltersPlugin");
        File file = new File(this.getPluginDir());
        if (file.mkdir() && !(file = new File(file.getAbsoluteFile() + "\\urls.map")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Main.debug((String)("Cannot create file" + file.getAbsolutePath() + "\n" + e.getMessage()));
            }
        }
        FiltersDownloader.setPluginDir(this.getPluginDir());
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (Main.isDisplayingMapView()) {
            MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (!(newLayer instanceof ImageryLayer)) {
            this.filterButton.setEnabled(false);
        } else {
            this.filterButton.setEnabled(true);
        }
    }

    public void layerAdded(Layer newLayer) {
        Object dialog;
        if (this.filterButton == null) {
            FiltersDownloader.downloadFiltersInfoList();
            FiltersDownloader.initFilters();
            dialog = (LayerListDialog)Main.map.getToggleDialog(LayerListDialog.class);
            if (this.action == null) {
                this.action = new ShowLayerFiltersDialog();
            }
            if (newLayer instanceof ImageryLayer) {
                this.filterButton = new SideButton((Action)this.action, false);
                this.filterButton.setEnabled(true);
            } else {
                this.filterButton = new SideButton((Action)this.action, false);
                this.filterButton.setEnabled(false);
            }
            JPanel buttonRowPanel = (JPanel)((JPanel)dialog.getComponent(2)).getComponent(0);
            buttonRowPanel.add((Component)this.filterButton);
        }
        if (newLayer instanceof ImageryLayer) {
            dialog = new FiltersDialog((ImageryLayer)newLayer);
            this.action.addFiltersDialog((FiltersDialog)dialog);
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer instanceof ImageryLayer) {
            FiltersDialog dialog = this.action.getDialogByLayer(oldLayer);
            ((ImageryLayer)oldLayer).removeImageProcessor((ImageProcessor)dialog.getFiltersManager());
            dialog.closeFrame();
            this.action.removeFiltersDialog(dialog);
        }
        if (Main.map.mapView.getAllLayersAsList().size() == 0) {
            Container container = this.filterButton.getParent();
            container.remove((Component)this.filterButton);
            FiltersDownloader.destroyFilters();
            this.filterButton = null;
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        if (this.setting == null) {
            this.setting = new RasterFiltersPreferences();
        }
        return this.setting;
    }
}

