/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.image.BufferedImage;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDataListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.cache.CacheUtils;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;

public class WalkThread
extends Thread
implements MapillaryDataListener {
    private final int interval;
    private final MapillaryData data;
    private final Lock lock;
    private boolean end = false;
    private final boolean waitForFullQuality;
    private final boolean followSelected;
    private final boolean goForward;
    private BufferedImage lastImage;
    private volatile boolean paused = false;

    public WalkThread(int interval, boolean waitForPicture, boolean followSelected, boolean goForward) {
        this.interval = interval;
        this.waitForFullQuality = waitForPicture;
        this.followSelected = followSelected;
        this.goForward = goForward;
        this.data = MapillaryLayer.getInstance().getData();
        this.data.addListener(this);
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                if (this.end || this.data.getSelectedImage().next() == null) ** GOTO lbl-1000
                image = this.data.getSelectedImage();
                if (!(image instanceof MapillaryImage)) ** GOTO lbl16
                ** GOTO lbl9
lbl-1000:
                // 1 sources

                {
                    this.end();
                    return;
lbl9:
                    // 2 sources

                    for (i = 0; i < 10 && image.next() != null; image = image.next(), ++i) {
                        CacheUtils.downloadPicture((MapillaryImage)image, CacheUtils.PICTURE.THUMBNAIL);
                    }
                    if (this.waitForFullQuality) {
                        for (i = 0; i < 3 && image.next() != null; image = image.next(), ++i) {
                            CacheUtils.downloadPicture((MapillaryImage)image, CacheUtils.PICTURE.FULL_IMAGE);
                        }
                    }
lbl16:
                    // 4 sources

                    try {
                        i = this;
                        synchronized (i) {
                            if (this.waitForFullQuality && image instanceof MapillaryImage) {
                                while (MapillaryMainDialog.getInstance().mapillaryImageDisplay.getImage() == this.lastImage || MapillaryMainDialog.getInstance().mapillaryImageDisplay.getImage() == null || MapillaryMainDialog.getInstance().mapillaryImageDisplay.getImage().getWidth() < 2048) {
                                    this.wait(100L);
                                }
                            } else {
                                while (MapillaryMainDialog.getInstance().mapillaryImageDisplay.getImage() == this.lastImage || MapillaryMainDialog.getInstance().mapillaryImageDisplay.getImage() == null || MapillaryMainDialog.getInstance().mapillaryImageDisplay.getImage().getWidth() < 320) {
                                    this.wait(100L);
                                }
                            }
                            while (this.paused) {
                                this.wait(100L);
                            }
                            this.wait(this.interval);
                            while (this.paused) {
                                this.wait(100L);
                            }
                        }
                        this.lastImage = MapillaryMainDialog.getInstance().mapillaryImageDisplay.getImage();
                        this.lock.lock();
                        try {
                            if (this.goForward) {
                                this.data.selectNext(this.followSelected);
                                continue;
                            }
                            this.data.selectPrevious(this.followSelected);
                            continue;
                        }
                        finally {
                            this.lock.unlock();
                            continue;
                        }
                    }
                    catch (InterruptedException e) {}
                    return;
                }
                break;
            }
        }
        catch (NullPointerException e) {
            return;
        }
        {
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        this.lock.lock();
        try {
            super.interrupt();
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public void selectedImageChanged(MapillaryAbstractImage oldImage, MapillaryAbstractImage newImage) {
        if (newImage != oldImage.next()) {
            this.end();
            this.interrupt();
        }
    }

    public void play() {
        this.paused = false;
    }

    public void pause() {
        this.paused = true;
    }

    public void stopWalk() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WalkThread.this.stopWalk();
                }
            });
        } else {
            this.end();
            this.interrupt();
        }
    }

    public void end() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WalkThread.this.end();
                }
            });
        } else {
            this.end = true;
            this.data.removeListener(this);
            MapillaryMainDialog.getInstance().setMode(MapillaryMainDialog.MODE.NORMAL);
        }
    }
}

