/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandImport;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryImportAction
extends JosmAction {
    private static final long serialVersionUID = 4995924098228081806L;
    private JFileChooser chooser;
    private int noTagsPics = 0;

    public MapillaryImportAction() {
        super(I18n.tr((String)"Import pictures", (Object[])new Object[0]), MapillaryPlugin.getProvider("icon24.png"), I18n.tr((String)"Import local pictures", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Import Mapillary", (String)I18n.tr((String)"Import pictures into Mapillary layer", (Object[])new Object[0]), (int)65535, (int)5000), false, "mapillaryImport", false);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        this.chooser = new JFileChooser();
        File startDirectory = new File(Main.pref.get("mapillary.start-directory", System.getProperty("user.home")));
        this.chooser.setCurrentDirectory(startDirectory);
        this.chooser.setDialogTitle(I18n.tr((String)"Select pictures", (Object[])new Object[0]));
        this.chooser.setFileSelectionMode(2);
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.addChoosableFileFilter(new FileNameExtensionFilter("images", "jpg", "jpeg", "png"));
        this.chooser.setMultiSelectionEnabled(true);
        if (this.chooser.showOpenDialog(Main.parent) == 0) {
            ArrayList<MapillaryAbstractImage> images = new ArrayList<MapillaryAbstractImage>();
            for (int i = 0; i < this.chooser.getSelectedFiles().length; ++i) {
                File file = this.chooser.getSelectedFiles()[i];
                Main.pref.put("mapillary.start-directory", file.getParent());
                MapillaryLayer.getInstance();
                if (file.isDirectory()) {
                    if (file.listFiles() == null) continue;
                    for (int j = 0; j < file.listFiles().length; ++j) {
                        int k = file.listFiles()[j].getName().lastIndexOf(46);
                        String extension = null;
                        if (k > 0) {
                            extension = file.listFiles()[j].getName().substring(k + 1);
                        }
                        try {
                            if (extension.equals("jpg") || extension.equals("jpeg")) {
                                images.add(this.readJPG(file.listFiles()[j]));
                                continue;
                            }
                            if (!extension.equals("png")) continue;
                            images.add(this.readPNG(file.listFiles()[j]));
                            continue;
                        }
                        catch (IOException | NullPointerException | ImageReadException e1) {
                            Main.error((Throwable)e1);
                        }
                    }
                    continue;
                }
                if (file.getPath().substring(file.getPath().length() - 4).equals(".jpg") || file.getPath().substring(file.getPath().length() - 5).equals(".jpeg")) {
                    try {
                        images.add(this.readJPG(file));
                    }
                    catch (ImageReadException ex) {
                        Main.error((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Main.error((Throwable)ex);
                    }
                    continue;
                }
                if (!file.getPath().substring(file.getPath().length() - 4).equals(".png")) continue;
                images.add(this.readPNG(file));
            }
            MapillaryRecord.getInstance().addCommand(new CommandImport(images));
            MapillaryUtils.showAllPictures();
        }
    }

    public MapillaryImportedImage readJPG(File file) throws IOException, ImageReadException {
        ImageMetadata metadata = Imaging.getMetadata((File)file);
        if (metadata instanceof JpegImageMetadata) {
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            TiffField lat_ref = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE_REF);
            TiffField lat = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE);
            TiffField lon_ref = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE_REF);
            TiffField lon = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE);
            TiffField ca = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION);
            TiffField datetimeOriginal = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
            if (lat_ref == null || lat == null || lon == null || lon_ref == null) {
                return this.readNoTags(file);
            }
            double latValue = 0.0;
            double lonValue = 0.0;
            double caValue = 0.0;
            if (lat.getValue() instanceof RationalNumber[]) {
                latValue = MapillaryUtils.degMinSecToDouble((RationalNumber[])lat.getValue(), lat_ref.getValue().toString());
            }
            if (lon.getValue() instanceof RationalNumber[]) {
                lonValue = MapillaryUtils.degMinSecToDouble((RationalNumber[])lon.getValue(), lon_ref.getValue().toString());
            }
            if (ca != null && ca.getValue() instanceof RationalNumber) {
                caValue = ((RationalNumber)ca.getValue()).doubleValue();
            }
            if (datetimeOriginal != null) {
                return new MapillaryImportedImage(latValue, lonValue, caValue, file, datetimeOriginal.getStringValue());
            }
            return new MapillaryImportedImage(latValue, lonValue, caValue, file);
        }
        throw new IllegalStateException("Invalid format.");
    }

    public MapillaryImportedImage readNoTags(File file) {
        return this.readNoTags(file, Main.map.mapView.getProjection().eastNorth2latlon(Main.map.mapView.getCenter()));
    }

    public MapillaryImportedImage readNoTags(File file, LatLon pos) {
        double HORIZONTAL_DISTANCE = 1.0E-4;
        double horDev = this.noTagsPics % 2 == 0 ? HORIZONTAL_DISTANCE * (double)this.noTagsPics / 2.0 : -HORIZONTAL_DISTANCE * (double)((this.noTagsPics + 1) / 2);
        ++this.noTagsPics;
        return new MapillaryImportedImage(pos.lat(), pos.lon() + horDev, 0.0, file);
    }

    public MapillaryImportedImage readPNG(File file) {
        return this.readNoTags(file);
    }
}

