/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.cache.CacheUtils;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillaryDownloader;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryFilterDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandDelete;
import org.openstreetmap.josm.plugins.mapillary.mode.AbstractMode;
import org.openstreetmap.josm.plugins.mapillary.mode.JoinMode;
import org.openstreetmap.josm.plugins.mapillary.mode.SelectMode;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryLayer
extends AbstractModifiableLayer
implements DataSetListener,
MapView.EditLayerChangeListener,
MapView.LayerChangeListener {
    public static final int SEQUENCE_MAX_JUMP_DISTANCE = Main.pref.getInteger("mapillary.sequence-max-jump-distance", 100);
    public boolean TEMP_SEMIAUTOMATIC = false;
    public static MapillaryLayer INSTANCE;
    public static MapillaryImage BLUE;
    public static MapillaryImage RED;
    private final MapillaryData data;
    public AbstractMode mode;
    private int highlightPointRadius = Main.pref.getInteger("mappaint.highlight.radius", 7);
    private int highlightStep = Main.pref.getInteger("mappaint.highlight.step", 4);
    private volatile TexturePaint hatched;

    private MapillaryLayer() {
        super(I18n.tr((String)"Mapillary Images", (Object[])new Object[0]));
        this.data = new MapillaryData();
        this.data.bounds = new CopyOnWriteArrayList();
        this.init();
    }

    private void init() {
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        if (Main.main != null && Main.map.mapView != null) {
            this.setMode(new SelectMode());
            Main.map.mapView.addLayer((Layer)this);
            MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)this, (boolean)false);
            MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
            if (Main.map.mapView.getEditLayer() != null) {
                Main.map.mapView.getEditLayer().data.addDataSetListener((DataSetListener)this);
            }
            if (MapillaryDownloader.getMode() == 0) {
                MapillaryDownloader.automaticDownload();
            }
            if (MapillaryDownloader.getMode() == 1) {
                this.mode.zoomChanged();
            }
        }
        if (MapillaryPlugin.EXPORT_MENU != null) {
            MapillaryPlugin.setMenuEnabled(MapillaryPlugin.EXPORT_MENU, true);
            if (!MapillaryMainDialog.getInstance().isShowing()) {
                MapillaryMainDialog.getInstance().getButton().doClick();
            }
        }
        this.createHatchTexture();
        if (Main.main != null) {
            MapillaryMainDialog.getInstance().getInputMap(2).put(KeyStroke.getKeyStroke("DELETE"), "MapillaryDel");
            MapillaryMainDialog.getInstance().getActionMap().put("MapillaryDel", new DeleteImageAction());
        }
        if (Main.main != null) {
            MapillaryData.dataUpdated();
        }
    }

    public void setMode(AbstractMode mode) {
        if (this.mode != null) {
            Main.map.mapView.removeMouseListener((MouseListener)this.mode);
            Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this.mode);
            NavigatableComponent.removeZoomChangeListener((NavigatableComponent.ZoomChangeListener)this.mode);
        }
        this.mode = mode;
        if (mode != null) {
            Main.map.mapView.setNewCursor(mode.cursor, (Object)this);
            Main.map.mapView.addMouseListener((MouseListener)mode);
            Main.map.mapView.addMouseMotionListener((MouseMotionListener)mode);
            NavigatableComponent.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)mode);
            MapillaryUtils.updateHelpText();
        }
    }

    public static synchronized MapillaryLayer getInstance() {
        if (INSTANCE == null) {
            return new MapillaryLayer();
        }
        return INSTANCE;
    }

    public MapillaryData getData() {
        return this.data;
    }

    public void destroy() {
        this.setMode(null);
        MapillaryRecord.getInstance().reset();
        AbstractMode.resetThread();
        MapillaryDownloader.stopAll();
        MapillaryMainDialog.getInstance().setImage(null);
        MapillaryMainDialog.getInstance().updateImage();
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.EXPORT_MENU, false);
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.ZOOM_MENU, false);
        Main.map.mapView.removeMouseListener((MouseListener)this.mode);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this.mode);
        MapView.removeEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        if (Main.map.mapView.getEditLayer() != null) {
            Main.map.mapView.getEditLayer().data.removeDataSetListener((DataSetListener)this);
        }
        MapillaryLayer.clearInstance();
        super.destroy();
    }

    public static void clearInstance() {
        INSTANCE = null;
    }

    public boolean isModified() {
        for (MapillaryAbstractImage image : this.data.getImages()) {
            if (!image.isModified()) continue;
            return true;
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        for (MapillaryAbstractImage img : this.data.getImages()) {
            img.setVisible(visible);
        }
        MapillaryFilterDialog.getInstance().refresh();
    }

    private static Color getBackgroundColor() {
        return Main.pref.getColor(I18n.marktr((String)"background"), Color.BLACK);
    }

    private static Color getOutsideColor() {
        return Main.pref.getColor(I18n.marktr((String)"outside downloaded area"), Color.YELLOW);
    }

    private void createHatchTexture() {
        BufferedImage bi = new BufferedImage(15, 15, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(MapillaryLayer.getBackgroundColor());
        AlphaComposite comp = AlphaComposite.getInstance(3, 0.3f);
        big.setComposite(comp);
        big.fillRect(0, 0, 15, 15);
        big.setColor(MapillaryLayer.getOutsideColor());
        big.drawLine(0, 15, 15, 0);
        Rectangle r = new Rectangle(0, 0, 15, 15);
        this.hatched = new TexturePaint(bi, r);
    }

    public synchronized void paint(Graphics2D g, MapView mv, Bounds box) {
        if (Main.map.mapView.getActiveLayer() == this) {
            Rectangle b = mv.getBounds();
            b.grow(100, 100);
            Area a = new Area(b);
            for (Bounds bounds : this.data.bounds) {
                Point p1 = mv.getPoint(bounds.getMin());
                Point p2 = mv.getPoint(bounds.getMax());
                Rectangle r = new Rectangle(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y));
                a.subtract(new Area(r));
            }
            g.setPaint(this.hatched);
            g.fill(a);
        }
        BLUE = null;
        RED = null;
        MapillaryMainDialog.getInstance().blueButton.setEnabled(false);
        MapillaryMainDialog.getInstance().redButton.setEnabled(false);
        if (this.data.getSelectedImage() != null) {
            MapillaryImage[] closestImages = this.getClosestImagesFromDifferentSequences();
            Point selected = mv.getPoint(this.data.getSelectedImage().getLatLon());
            if (closestImages[0] != null) {
                BLUE = closestImages[0];
                g.setColor(Color.BLUE);
                g.drawLine(mv.getPoint((LatLon)closestImages[0].getLatLon()).x, mv.getPoint((LatLon)closestImages[0].getLatLon()).y, selected.x, selected.y);
                MapillaryMainDialog.getInstance().blueButton.setEnabled(true);
            }
            if (closestImages[1] != null) {
                RED = closestImages[1];
                g.setColor(Color.RED);
                g.drawLine(mv.getPoint((LatLon)closestImages[1].getLatLon()).x, mv.getPoint((LatLon)closestImages[1].getLatLon()).y, selected.x, selected.y);
                MapillaryMainDialog.getInstance().redButton.setEnabled(true);
            }
        }
        g.setColor(Color.WHITE);
        for (MapillaryAbstractImage imageAbs : this.data.getImages()) {
            ImageIcon icon;
            MapillaryAbstractImage image;
            if (!imageAbs.isVisible()) continue;
            Point p = mv.getPoint(imageAbs.getLatLon());
            Point nextp = null;
            if (imageAbs.getSequence() != null) {
                for (MapillaryAbstractImage tempImage = imageAbs.next(); tempImage != null; tempImage = tempImage.next()) {
                    if (!tempImage.isVisible()) continue;
                    nextp = mv.getPoint(tempImage.getLatLon());
                    break;
                }
                if (nextp != null) {
                    g.drawLine(p.x, p.y, nextp.x, nextp.y);
                }
            }
            if (imageAbs instanceof MapillaryImage) {
                image = (MapillaryImage)imageAbs;
                icon = !this.data.getMultiSelectedImages().contains(image) ? MapillaryPlugin.MAP_ICON : MapillaryPlugin.MAP_ICON_SELECTED;
                this.draw(g, image, icon, p);
                if (((MapillaryImage)image).getSigns().isEmpty()) continue;
                g.drawImage(MapillaryPlugin.MAP_SIGN.getImage(), p.x + icon.getIconWidth() / 2, p.y - icon.getIconHeight() / 2, (ImageObserver)Main.map.mapView);
                continue;
            }
            if (!(imageAbs instanceof MapillaryImportedImage)) continue;
            image = (MapillaryImportedImage)imageAbs;
            icon = !this.data.getMultiSelectedImages().contains(image) ? MapillaryPlugin.MAP_ICON_IMPORTED : MapillaryPlugin.MAP_ICON_SELECTED;
            this.draw(g, image, icon, p);
        }
        if (this.mode instanceof JoinMode) {
            this.mode.paint(g, mv, box);
        }
    }

    private void drawPointHighlight(Graphics2D g, Point p, int size) {
        Color oldColor = g.getColor();
        Color highlightColor = PaintColors.HIGHLIGHT.get();
        Color highlightColorTransparent = new Color(highlightColor.getRed(), highlightColor.getGreen(), highlightColor.getBlue(), 100);
        g.setColor(highlightColorTransparent);
        for (int s = size + this.highlightPointRadius; s >= size; s -= this.highlightStep) {
            int r = (int)Math.floor((double)s / 2.0);
            g.fillRoundRect(p.x - r, p.y - r, s, s, r, r);
        }
        g.setColor(oldColor);
    }

    private void draw(Graphics2D g, MapillaryAbstractImage image, ImageIcon icon, Point p) {
        Image imagetemp = icon.getImage();
        BufferedImage bi = (BufferedImage)imagetemp;
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        double rotationRequired = Math.toRadians(image.getCa());
        double locationX = width / 2;
        double locationY = height / 2;
        AffineTransform tx = AffineTransform.getRotateInstance(rotationRequired, locationX, locationY);
        AffineTransformOp op = new AffineTransformOp(tx, 2);
        g.drawImage((Image)op.filter(bi, null), p.x - width / 2, p.y - height / 2, (ImageObserver)Main.map.mapView);
        if (this.data.getHighlightedImage() == image) {
            this.drawPointHighlight(g, p, 16);
        }
    }

    public Icon getIcon() {
        return MapillaryPlugin.ICON16;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
        throw new UnsupportedOperationException("This layer does not support merging yet");
    }

    public Action[] getMenuEntries() {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(LayerListDialog.getInstance().createShowHideLayerAction());
        actions.add(LayerListDialog.getInstance().createDeleteLayerAction());
        actions.add(new LayerListPopup.InfoAction((Layer)this));
        return actions.toArray(new Action[actions.size()]);
    }

    private MapillaryImage[] getClosestImagesFromDifferentSequences() {
        if (!(this.data.getSelectedImage() instanceof MapillaryImage)) {
            return new MapillaryImage[2];
        }
        MapillaryImage selected = (MapillaryImage)this.data.getSelectedImage();
        MapillaryImage[] ret = new MapillaryImage[2];
        double[] distances = new double[]{SEQUENCE_MAX_JUMP_DISTANCE, SEQUENCE_MAX_JUMP_DISTANCE};
        LatLon selectedCoords = this.data.getSelectedImage().getLatLon();
        for (MapillaryAbstractImage imagePrev : this.data.getImages()) {
            MapillaryImage image;
            if (!(imagePrev instanceof MapillaryImage) || !imagePrev.isVisible() || !((image = (MapillaryImage)imagePrev).getLatLon().greatCircleDistance(selectedCoords) < (double)SEQUENCE_MAX_JUMP_DISTANCE) || selected.getSequence() == image.getSequence()) continue;
            if (ret[0] == null && ret[1] == null || image.getLatLon().greatCircleDistance(selectedCoords) < distances[0] && (ret[1] == null || image.getSequence() != ret[1].getSequence())) {
                ret[0] = image;
                distances[0] = image.getLatLon().greatCircleDistance(selectedCoords);
                continue;
            }
            if (ret[1] != null && !(image.getLatLon().greatCircleDistance(selectedCoords) < distances[1]) || image.getSequence() == ret[0].getSequence()) continue;
            ret[1] = image;
            distances[1] = image.getLatLon().greatCircleDistance(selectedCoords);
        }
        if (ret[0] != null) {
            CacheUtils.downloadPicture(ret[0]);
        }
        if (ret[1] != null) {
            CacheUtils.downloadPicture(ret[1]);
        }
        return ret;
    }

    public Object getInfoComponent() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.tr((String)"Mapillary layer", (Object[])new Object[0]));
        sb.append("\n");
        sb.append(I18n.tr((String)"Total images:", (Object[])new Object[0]));
        sb.append(" ");
        sb.append(this.data.size());
        sb.append("\n");
        return sb.toString();
    }

    public String getToolTipText() {
        return this.data.size() + " " + I18n.tr((String)"images", (Object[])new Object[0]);
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        if (oldLayer == null && newLayer != null) {
            newLayer.data.addDataSetListener((DataSetListener)this);
        } else if (oldLayer != null && newLayer == null) {
            oldLayer.data.removeDataSetListener((DataSetListener)this);
        }
    }

    public void dataChanged(DataChangedEvent event) {
        Main.worker.submit(new delayedDownload());
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
    }

    public void tagsChanged(TagsChangedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer == this) {
            MapillaryUtils.updateHelpText();
            MapillaryPlugin.setMenuEnabled(MapillaryPlugin.JOIN_MENU, true);
        } else {
            MapillaryPlugin.setMenuEnabled(MapillaryPlugin.JOIN_MENU, false);
        }
    }

    public void layerAdded(Layer newLayer) {
    }

    public void layerRemoved(Layer oldLayer) {
    }

    private class DeleteImageAction
    extends AbstractAction {
        private static final long serialVersionUID = -982809854631863962L;

        private DeleteImageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (INSTANCE != null) {
                MapillaryRecord.getInstance().addCommand(new CommandDelete(MapillaryLayer.this.getData().getMultiSelectedImages()));
            }
        }
    }

    private class delayedDownload
    extends Thread {
        private delayedDownload() {
        }

        @Override
        public void run() {
            try {
                delayedDownload.sleep(1500L);
            }
            catch (InterruptedException e) {
                Main.error((Throwable)e);
            }
            MapillaryDownloader.automaticDownload();
        }
    }
}

