/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;

public abstract class MapillaryAbstractImage {
    public static Lock LOCK = new ReentrantLock();
    private long capturedAt;
    private MapillarySequence sequence;
    public final LatLon latLon;
    public final double ca;
    public boolean isModified = false;
    public LatLon tempLatLon;
    public LatLon movingLatLon;
    public double tempCa;
    protected double movingCa;
    private boolean visible;

    public MapillaryAbstractImage(double lat, double lon, double ca) {
        this.tempLatLon = this.latLon = new LatLon(lat, lon);
        this.movingLatLon = this.latLon;
        this.ca = ca;
        this.tempCa = ca;
        this.movingCa = ca;
        this.visible = true;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public LatLon getLatLon() {
        return this.movingLatLon;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public LatLon getTempLatLon() {
        return this.tempLatLon;
    }

    public void move(double x, double y) {
        this.movingLatLon = new LatLon(this.tempLatLon.getY() + y, this.tempLatLon.getX() + x);
        this.isModified = true;
    }

    public void turn(double ca) {
        this.movingCa = this.tempCa + ca;
        this.isModified = true;
    }

    public void stopMoving() {
        this.tempLatLon = this.movingLatLon;
        this.tempCa = this.movingCa;
    }

    public double getCa() {
        return this.movingCa;
    }

    public double getTempCa() {
        return this.tempCa;
    }

    public String getDate() {
        String format = "";
        format = Main.pref.getBoolean("iso.dates") ? format + "yyyy-MM-dd" : format + "dd/MM/yyyy";
        if (Main.pref.getBoolean("mapillary.display-hour", true)) {
            format = Main.pref.getBoolean("mapillary.format-24") ? format + " - HH:mm:ss (z)" : format + " - h:mm:ss a (z)";
        }
        return this.getDate(format);
    }

    public void setCapturedAt(long capturedAt) {
        this.capturedAt = capturedAt;
    }

    public long getCapturedAt() {
        return this.capturedAt;
    }

    public String getDate(String format) {
        Date date = new Date(this.getCapturedAt());
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(Calendar.getInstance().getTimeZone());
        return formatter.format(date);
    }

    public static long getEpoch(String date, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date dateTime = formatter.parse(date);
        return dateTime.getTime();
    }

    protected static long currentTime() {
        Calendar cal = Calendar.getInstance();
        return cal.getTimeInMillis();
    }

    public void setSequence(MapillarySequence sequence) {
        this.sequence = sequence;
    }

    public MapillarySequence getSequence() {
        if (this.sequence == null) {
            this.sequence = new MapillarySequence();
            this.sequence.add(this);
        }
        return this.sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapillaryAbstractImage next() {
        LOCK.lock();
        try {
            if (this.getSequence() == null) {
                MapillaryAbstractImage mapillaryAbstractImage = null;
                return mapillaryAbstractImage;
            }
            MapillaryAbstractImage mapillaryAbstractImage = this.getSequence().next(this);
            return mapillaryAbstractImage;
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapillaryAbstractImage previous() {
        LOCK.lock();
        try {
            if (this.getSequence() == null) {
                MapillaryAbstractImage mapillaryAbstractImage = null;
                return mapillaryAbstractImage;
            }
            MapillaryAbstractImage mapillaryAbstractImage = this.getSequence().previous(this);
            return mapillaryAbstractImage;
        }
        finally {
            LOCK.unlock();
        }
    }
}

