/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.utils;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.imaging.common.RationalNumber;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;
import org.openstreetmap.josm.plugins.mapillary.utils.PluginState;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryUtils {
    public static void updateHelpText() {
        String ret = "";
        ret = PluginState.isDownloading() ? ret + I18n.tr((String)"Downloading", (Object[])new Object[0]) : (MapillaryLayer.getInstance().getData().size() > 0 ? ret + I18n.tr((String)"Total images: {0}", (Object[])new Object[]{MapillaryLayer.getInstance().getData().size()}) : ret + I18n.tr((String)"No images found", (Object[])new Object[0]));
        if (MapillaryLayer.getInstance().mode != null) {
            ret = ret + " -- " + I18n.tr((String)MapillaryLayer.getInstance().mode.toString(), (Object[])new Object[0]);
        }
        if (PluginState.isUploading()) {
            ret = ret + " -- " + PluginState.getUploadString();
        }
        Main.map.statusLine.setHelpText(ret);
    }

    public static double degMinSecToDouble(RationalNumber[] degMinSec, String ref) {
        if (degMinSec == null || degMinSec.length != 3) {
            throw new IllegalArgumentException("Array's length must be 3.");
        }
        for (int i = 0; i < 3; ++i) {
            if (degMinSec[i] != null) continue;
            throw new IllegalArgumentException("Null value in array.");
        }
        switch (ref) {
            case "N": 
            case "S": 
            case "E": 
            case "W": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ref.");
            }
        }
        double result = degMinSec[0].doubleValue();
        result += degMinSec[1].doubleValue() / 60.0;
        result += degMinSec[2].doubleValue() / 3600.0;
        if ("S".equals(ref) || "W".equals(ref)) {
            result *= -1.0;
        }
        result = 360.0 * ((result + 180.0) / 360.0 - Math.floor((result + 180.0) / 360.0)) - 180.0;
        return result;
    }

    public static void browse(URL url) {
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(url.toURI());
            }
            catch (IOException | URISyntaxException e1) {
                Main.error((Throwable)e1);
            }
        } else {
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec("xdg-open " + url);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
    }

    public static synchronized void join(MapillaryImportedImage img1, MapillaryImportedImage img2) {
        MapillarySequence seq;
        MapillaryImportedImage firstImage = img1;
        MapillaryImportedImage secondImage = img2;
        if (img1.next() != null) {
            firstImage = img2;
            secondImage = img1;
        }
        if (firstImage.getSequence() == null) {
            seq = new MapillarySequence();
            seq.add(firstImage);
            firstImage.setSequence(seq);
        }
        if (secondImage.getSequence() == null) {
            seq = new MapillarySequence();
            seq.add(secondImage);
            img2.setSequence(seq);
        }
        for (MapillaryAbstractImage img : secondImage.getSequence().getImages()) {
            firstImage.getSequence().add(img);
            img.setSequence(firstImage.getSequence());
        }
        if (Main.main != null) {
            MapillaryData.dataUpdated();
        }
    }

    public static synchronized void unjoin(MapillaryImportedImage img1, MapillaryImportedImage img2) {
        MapillaryImportedImage firstImage = img1;
        MapillaryImportedImage secondImage = img2;
        if (img1.next() != img2) {
            firstImage = img2;
            secondImage = img1;
        }
        ArrayList<MapillaryAbstractImage> firstHalf = new ArrayList<MapillaryAbstractImage>(firstImage.getSequence().getImages().subList(0, firstImage.getSequence().getImages().indexOf(secondImage)));
        ArrayList<MapillaryAbstractImage> secondHalf = new ArrayList<MapillaryAbstractImage>(firstImage.getSequence().getImages().subList(firstImage.getSequence().getImages().indexOf(secondImage), firstImage.getSequence().getImages().size()));
        MapillarySequence seq1 = new MapillarySequence();
        MapillarySequence seq2 = new MapillarySequence();
        for (MapillaryAbstractImage img : firstHalf) {
            img.setSequence(seq1);
            seq1.add(img);
        }
        for (MapillaryAbstractImage img : secondHalf) {
            img.setSequence(seq2);
            seq2.add(img);
        }
        if (Main.main != null) {
            MapillaryData.dataUpdated();
        }
    }
}

