/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.history.commands;

import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.history.commands.MapillaryCommand;
import org.openstreetmap.josm.tools.I18n;

public class CommandMove
extends MapillaryCommand {
    private double x;
    private double y;

    public CommandMove(List<MapillaryAbstractImage> images, double x, double y) {
        super(images);
        this.x = x;
        this.y = y;
    }

    @Override
    public void undo() {
        for (MapillaryAbstractImage image : this.images) {
            image.move(-this.x, -this.y);
            image.stopMoving();
        }
        this.checkModified();
        if (Main.main != null) {
            Main.map.repaint();
        }
    }

    @Override
    public void redo() {
        for (MapillaryAbstractImage image : this.images) {
            image.move(this.x, this.y);
            image.stopMoving();
        }
        this.checkModified();
        if (Main.main != null) {
            Main.map.repaint();
        }
    }

    @Override
    public String toString() {
        return I18n.trn((String)"Moved {0} image", (String)"Moved {0} images", (long)this.images.size(), (Object[])new Object[]{this.images.size()});
    }

    @Override
    public void sum(MapillaryCommand command) {
        if (command instanceof CommandMove) {
            this.x += ((CommandMove)command).x;
            this.y += ((CommandMove)command).y;
        }
    }
}

