/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillaryImageInfoDownloaderThread;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillarySequenceDownloadThread;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillaryTrafficSignDownloaderThread;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryFilterDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.plugins.mapillary.utils.PluginState;

public class MapillarySquareDownloadManagerThread
extends Thread {
    private final String imageQueryString;
    private final String sequenceQueryString;
    private final String signQueryString;
    private ThreadPoolExecutor downloadExecutor = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
    private ThreadPoolExecutor completeExecutor = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
    private ThreadPoolExecutor signsExecutor = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));

    public MapillarySquareDownloadManagerThread(ConcurrentHashMap<String, Double> queryStringParts) {
        this.imageQueryString = MapillarySquareDownloadManagerThread.buildQueryString(queryStringParts);
        this.sequenceQueryString = MapillarySquareDownloadManagerThread.buildQueryString(queryStringParts);
        this.signQueryString = MapillarySquareDownloadManagerThread.buildQueryString(queryStringParts);
        Main.info((String)("GET " + this.sequenceQueryString + " (Mapillary plugin)"));
    }

    private static String buildQueryString(ConcurrentHashMap<String, Double> hash) {
        StringBuilder ret = new StringBuilder("?client_id=T1Fzd20xZjdtR0s1VDk5OFNIOXpYdzoxNDYyOGRkYzUyYTFiMzgz");
        for (String key : hash.keySet()) {
            if (key == null) continue;
            try {
                ret.append("&" + URLEncoder.encode(key, "UTF-8")).append("=" + URLEncoder.encode(String.format(Locale.UK, "%f", hash.get(key)), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {}
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            PluginState.startDownload();
            MapillaryUtils.updateHelpText();
            this.downloadSequences();
            this.completeImages();
            MapillaryMainDialog.getInstance().updateTitle();
            this.downloadSigns();
        }
        catch (InterruptedException e) {
            Main.error((String)"Mapillary download interrupted (probably because of closing the layer).");
        }
        finally {
            PluginState.finishDownload();
        }
        MapillaryUtils.updateHelpText();
        MapillaryData.dataUpdated();
        MapillaryFilterDialog.getInstance().refresh();
        MapillaryMainDialog.getInstance().updateImage();
    }

    private void downloadSequences() throws InterruptedException {
        int page = 0;
        while (!this.downloadExecutor.isShutdown()) {
            this.downloadExecutor.execute(new MapillarySequenceDownloadThread(this.downloadExecutor, this.sequenceQueryString + "&page=" + page + "&limit=10"));
            while (this.downloadExecutor.getQueue().remainingCapacity() == 0) {
                Thread.sleep(500L);
            }
            ++page;
        }
        this.downloadExecutor.awaitTermination(15L, TimeUnit.SECONDS);
        MapillaryData.dataUpdated();
    }

    private void completeImages() throws InterruptedException {
        int page = 0;
        while (!this.completeExecutor.isShutdown()) {
            this.completeExecutor.execute(new MapillaryImageInfoDownloaderThread(this.completeExecutor, this.imageQueryString + "&page=" + page + "&limit=20"));
            while (this.completeExecutor.getQueue().remainingCapacity() == 0) {
                Thread.sleep(100L);
            }
            ++page;
        }
        this.completeExecutor.awaitTermination(15L, TimeUnit.SECONDS);
    }

    private void downloadSigns() throws InterruptedException {
        int page = 0;
        while (!this.signsExecutor.isShutdown()) {
            this.signsExecutor.execute(new MapillaryTrafficSignDownloaderThread(this.signsExecutor, this.signQueryString + "&page=" + page + "&limit=20"));
            while (this.signsExecutor.getQueue().remainingCapacity() == 0) {
                Thread.sleep(100L);
            }
            ++page;
        }
        this.signsExecutor.awaitTermination(15L, TimeUnit.SECONDS);
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.downloadExecutor.shutdownNow();
        this.completeExecutor.shutdownNow();
        this.signsExecutor.shutdownNow();
        try {
            this.downloadExecutor.awaitTermination(15L, TimeUnit.SECONDS);
            this.completeExecutor.awaitTermination(15L, TimeUnit.SECONDS);
            this.signsExecutor.awaitTermination(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Main.error((Throwable)e);
        }
    }
}

