/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.mode;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;
import org.openstreetmap.josm.plugins.mapillary.mode.AbstractMode;

public class JoinMode
extends AbstractMode {
    private MapillaryImportedImage lastClick;
    private MouseEvent lastPos;

    public JoinMode() {
        this.cursor = 1;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.data.getHighlightedImage() == null) {
            return;
        }
        if (this.lastClick == null && this.data.getHighlightedImage() instanceof MapillaryImportedImage) {
            this.lastClick = (MapillaryImportedImage)this.data.getHighlightedImage();
        } else if (this.lastClick != null && this.data.getHighlightedImage() instanceof MapillaryImportedImage) {
            if ((this.data.getHighlightedImage().previous() == null && this.lastClick.next() == null || this.data.getHighlightedImage().next() == null && this.lastClick.previous() == null) && (this.data.getHighlightedImage().getSequence() != this.lastClick.getSequence() || this.lastClick.getSequence() == null)) {
                JoinMode.join(this.lastClick, (MapillaryImportedImage)this.data.getHighlightedImage());
            } else if (this.lastClick.next() == this.data.getHighlightedImage() || this.lastClick.previous() == this.data.getHighlightedImage()) {
                JoinMode.unjoin(this.lastClick, (MapillaryImportedImage)this.data.getHighlightedImage());
            }
            this.lastClick = null;
        }
        MapillaryData.dataUpdated();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastPos = e;
        if (!(Main.map.mapView.getActiveLayer() instanceof MapillaryLayer)) {
            return;
        }
        MapillaryAbstractImage closestTemp = this.getClosest(e.getPoint());
        this.data.setHighlightedImage(closestTemp);
        MapillaryData.dataUpdated();
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        if (this.lastClick != null) {
            g.setColor(Color.WHITE);
            Point p0 = mv.getPoint(this.lastClick.getLatLon());
            Point p1 = this.lastPos.getPoint();
            g.drawLine(p0.x, p0.y, p1.x, p1.y);
        }
    }

    private static void join(MapillaryImportedImage img1, MapillaryImportedImage img2) {
        MapillarySequence seq;
        MapillaryImportedImage firstImage = img1;
        MapillaryImportedImage secondImage = img2;
        if (img1.next() != null) {
            firstImage = img2;
            secondImage = img1;
        }
        if (firstImage.getSequence() == null) {
            seq = new MapillarySequence();
            seq.add(firstImage);
            firstImage.setSequence(seq);
        }
        if (secondImage.getSequence() == null) {
            seq = new MapillarySequence();
            seq.add(secondImage);
            img2.setSequence(seq);
        }
        for (MapillaryAbstractImage img : secondImage.getSequence().getImages()) {
            firstImage.getSequence().add(img);
            img.setSequence(firstImage.getSequence());
        }
    }

    private static void unjoin(MapillaryImportedImage img1, MapillaryImportedImage img2) {
        MapillaryImportedImage firstImage = img1;
        MapillaryImportedImage secondImage = img2;
        if (img1.next() != img2) {
            firstImage = img2;
            secondImage = img1;
        }
        ArrayList<MapillaryAbstractImage> firstHalf = new ArrayList<MapillaryAbstractImage>(firstImage.getSequence().getImages().subList(0, firstImage.getSequence().getImages().indexOf(secondImage)));
        ArrayList<MapillaryAbstractImage> secondHalf = new ArrayList<MapillaryAbstractImage>(firstImage.getSequence().getImages().subList(firstImage.getSequence().getImages().indexOf(secondImage), firstImage.getSequence().getImages().size()));
        MapillarySequence seq1 = new MapillarySequence();
        MapillarySequence seq2 = new MapillarySequence();
        for (MapillaryAbstractImage img : firstHalf) {
            img.setSequence(seq1);
            seq1.add(img);
        }
        for (MapillaryAbstractImage img : secondHalf) {
            img.setSequence(seq2);
            seq2.add(img);
        }
    }

    public String toString() {
        return "Join mode";
    }
}

