/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryDownloadAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryDownloadViewAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryExportAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryImportAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryImportIntoSequenceAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryJoinAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryUploadAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryWalkAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryZoomAction;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillaryDownloader;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryFilterDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryHistoryDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryPreferenceSetting;
import org.openstreetmap.josm.plugins.mapillary.oauth.MapillaryUser;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapillaryPlugin
extends Plugin {
    public static final String SEPARATOR = System.getProperty("file.separator");
    public static ImageIcon ICON24;
    public static ImageIcon ICON16;
    public static ImageIcon MAP_ICON;
    public static ImageIcon MAP_ICON_SELECTED;
    public static ImageIcon MAP_ICON_IMPORTED;
    public static ImageIcon MAP_SIGN;
    public static CacheAccess<String, BufferedImageCacheEntry> CACHE;
    private final MapillaryDownloadAction downloadAction;
    private final MapillaryExportAction exportAction;
    public static MapillaryImportAction importAction;
    public static MapillaryZoomAction zoomAction;
    private final MapillaryDownloadViewAction downloadViewAction;
    private final MapillaryImportIntoSequenceAction importIntoSequenceAction;
    private final MapillaryJoinAction joinAction;
    public static MapillaryWalkAction walkAction;
    public static MapillaryUploadAction uploadAction;
    public static JMenuItem DOWNLOAD_MENU;
    public static JMenuItem EXPORT_MENU;
    public static JMenuItem IMPORT_MENU;
    public static JMenuItem ZOOM_MENU;
    public static JMenuItem DOWNLOAD_VIEW_MENU;
    public static JMenuItem IMPORT_INTO_SEQUENCE_MENU;
    public static JMenuItem JOIN_MENU;
    public static JMenuItem WALK_MENU;
    public static JMenuItem UPLOAD_MENU;

    public MapillaryPlugin(PluginInformation info) {
        super(info);
        ICON24 = new ImageProvider("icon24.png").get();
        ICON16 = new ImageProvider("icon16.png").get();
        MAP_ICON = new ImageProvider("mapicon.png").get();
        MAP_ICON_SELECTED = new ImageProvider("mapiconselected.png").get();
        MAP_ICON_IMPORTED = new ImageProvider("mapiconimported.png").get();
        MAP_SIGN = new ImageProvider("sign.png").get();
        this.downloadAction = new MapillaryDownloadAction();
        walkAction = new MapillaryWalkAction();
        this.exportAction = new MapillaryExportAction();
        importAction = new MapillaryImportAction();
        zoomAction = new MapillaryZoomAction();
        this.downloadViewAction = new MapillaryDownloadViewAction();
        this.importIntoSequenceAction = new MapillaryImportIntoSequenceAction();
        this.joinAction = new MapillaryJoinAction();
        uploadAction = new MapillaryUploadAction();
        if (Main.main != null) {
            DOWNLOAD_MENU = MainMenu.add((JMenu)Main.main.menu.imageryMenu, (JosmAction)this.downloadAction, (boolean)false);
            EXPORT_MENU = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)this.exportAction, (boolean)false, (Integer)14);
            IMPORT_INTO_SEQUENCE_MENU = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)this.importIntoSequenceAction, (boolean)false, (Integer)14);
            IMPORT_MENU = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)importAction, (boolean)false, (Integer)14);
            UPLOAD_MENU = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)uploadAction, (boolean)false, (Integer)14);
            ZOOM_MENU = MainMenu.add((JMenu)Main.main.menu.viewMenu, (JosmAction)zoomAction, (boolean)false, (Integer)15);
            DOWNLOAD_VIEW_MENU = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)this.downloadViewAction, (boolean)false, (Integer)14);
            JOIN_MENU = MainMenu.add((JMenu)Main.main.menu.dataMenu, (JosmAction)this.joinAction, (boolean)false);
            WALK_MENU = MainMenu.add((JMenu)Main.main.menu.moreToolsMenu, (JosmAction)walkAction, (boolean)false);
            EXPORT_MENU.setEnabled(false);
            DOWNLOAD_MENU.setEnabled(false);
            IMPORT_MENU.setEnabled(false);
            IMPORT_INTO_SEQUENCE_MENU.setEnabled(false);
            ZOOM_MENU.setEnabled(false);
            DOWNLOAD_VIEW_MENU.setEnabled(false);
            JOIN_MENU.setEnabled(false);
            WALK_MENU.setEnabled(false);
        }
        try {
            CACHE = JCSCacheManager.getCache((String)"mapillary", (int)10, (int)10000, (String)(this.getPluginDir() + "/cache/"));
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
        if (Main.pref.get("mapillary.access-token") == null) {
            MapillaryUser.isTokenValid = false;
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            Main.map.addToggleDialog((ToggleDialog)MapillaryMainDialog.getInstance(), false);
            Main.map.addToggleDialog((ToggleDialog)MapillaryHistoryDialog.getInstance(), false);
            Main.map.addToggleDialog((ToggleDialog)MapillaryFilterDialog.getInstance(), false);
            MapillaryPlugin.setMenuEnabled(DOWNLOAD_MENU, true);
            if (MapillaryDownloader.getMode() == 2) {
                MapillaryPlugin.setMenuEnabled(DOWNLOAD_VIEW_MENU, true);
            }
            MapillaryPlugin.setMenuEnabled(IMPORT_MENU, true);
            MapillaryPlugin.setMenuEnabled(IMPORT_INTO_SEQUENCE_MENU, true);
        }
        if (oldFrame != null && newFrame == null) {
            MapillaryMainDialog.destroyInstance();
            MapillaryHistoryDialog.destroyInstance();
            MapillaryFilterDialog.destroyInstance();
            MapillaryPlugin.setMenuEnabled(DOWNLOAD_MENU, false);
            MapillaryPlugin.setMenuEnabled(DOWNLOAD_VIEW_MENU, false);
            MapillaryPlugin.setMenuEnabled(IMPORT_MENU, false);
            MapillaryPlugin.setMenuEnabled(IMPORT_INTO_SEQUENCE_MENU, false);
        }
    }

    public static void setMenuEnabled(JMenuItem menu, boolean value) {
        menu.setEnabled(value);
        menu.getAction().setEnabled(value);
    }

    public PreferenceSetting getPreferenceSetting() {
        return new MapillaryPreferenceSetting();
    }

    public static ImageProvider getProvider(String s) {
        if (Main.main == null) {
            return null;
        }
        return new ImageProvider(s);
    }
}

