/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.utils;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.gui.FinishedUploadDialog;
import org.openstreetmap.josm.tools.I18n;

public class PluginState {
    private static int runningDownloads = 0;
    public static int imagesToUpload = 0;
    public static int imagesUploaded = 0;

    public static void startDownload() {
        ++runningDownloads;
    }

    public static void finishDownload() {
        --runningDownloads;
    }

    public static boolean isDownloading() {
        return runningDownloads > 0;
    }

    public static void finishUpload() {
        if (imagesUploaded >= imagesToUpload) {
            imagesUploaded = 0;
            imagesToUpload = 0;
        }
    }

    public static boolean isUploading() {
        return imagesToUpload > imagesUploaded;
    }

    public static void imagesToUpload(int amount) {
        imagesToUpload += amount;
    }

    public static void imageUploaded() {
        if (imagesToUpload == ++imagesUploaded) {
            PluginState.finishedUploadDialog();
        }
    }

    private static void finishedUploadDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginState.finishedUploadDialog();
                }
            });
        } else {
            JOptionPane pane = new JOptionPane();
            pane.setMessage(new FinishedUploadDialog());
            JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Finished upload", (Object[])new Object[0]));
            dlg.setVisible(true);
        }
    }

    public static String getUploadString() {
        return I18n.tr((String)"Uploading: {0}", (Object[])new Object[]{"(" + imagesUploaded + "/" + imagesToUpload + ")"});
    }
}

