/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.utils;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.imaging.common.RationalNumber;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.utils.PluginState;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryUtils {
    public static void updateHelpText() {
        String ret = "";
        ret = PluginState.isDownloading() ? ret + I18n.tr((String)"Downloading", (Object[])new Object[0]) : (MapillaryLayer.getInstance().getData().size() > 0 ? ret + I18n.tr((String)"Total images: {0}", (Object[])new Object[]{MapillaryLayer.getInstance().getData().size()}) : ret + I18n.tr((String)"No images found", (Object[])new Object[0]));
        if (MapillaryLayer.getInstance().mode != null) {
            ret = ret + " -- " + I18n.tr((String)MapillaryLayer.getInstance().mode.toString(), (Object[])new Object[0]);
        }
        if (PluginState.isUploading()) {
            ret = ret + " -- " + PluginState.getUploadString();
        }
        Main.map.statusLine.setHelpText(ret);
    }

    public static double degMinSecToDouble(RationalNumber[] degMinSec, String ref) {
        if (degMinSec == null || degMinSec.length != 3) {
            throw new IllegalArgumentException("Array's length must be 3.");
        }
        for (int i = 0; i < 3; ++i) {
            if (degMinSec[i] != null) continue;
            throw new IllegalArgumentException("Null value in array.");
        }
        switch (ref) {
            case "N": 
            case "S": 
            case "E": 
            case "W": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ref.");
            }
        }
        double result = degMinSec[0].doubleValue();
        result += degMinSec[1].doubleValue() / 60.0;
        result += degMinSec[2].doubleValue() / 3600.0;
        if ("S".equals(ref) || "W".equals(ref)) {
            result *= -1.0;
        }
        result = 360.0 * ((result + 180.0) / 360.0 - Math.floor((result + 180.0) / 360.0)) - 180.0;
        return result;
    }

    public static void browse(URL url) {
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(url.toURI());
            }
            catch (IOException | URISyntaxException e1) {
                Main.error((Throwable)e1);
            }
        } else {
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec("xdg-open " + url);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
    }
}

