/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;

public class MapillaryExportWriterThread
extends Thread {
    private final String path;
    private final ArrayBlockingQueue<BufferedImage> queue;
    private final ArrayBlockingQueue<MapillaryAbstractImage> queueImages;
    private final int amount;
    private final ProgressMonitor monitor;

    public MapillaryExportWriterThread(String path, ArrayBlockingQueue<BufferedImage> queue, ArrayBlockingQueue<MapillaryAbstractImage> queueImages, int amount, ProgressMonitor monitor) {
        this.path = path;
        this.queue = queue;
        this.queueImages = queueImages;
        this.amount = amount;
        this.monitor = monitor;
    }

    @Override
    public void run() {
        this.monitor.setCustomText("Downloaded 0/" + this.amount);
        MapillaryAbstractImage mimg = null;
        String finalPath = "";
        for (int i = 0; i < this.amount; ++i) {
            try {
                TiffImageMetadata exif;
                ImageMetadata metadata;
                JpegImageMetadata jpegMetadata;
                BufferedImage img = this.queue.take();
                mimg = this.queueImages.take();
                if (img == null || mimg == null) {
                    throw new IllegalStateException("Null image");
                }
                if (this.path == null && mimg instanceof MapillaryImportedImage) {
                    String path = ((MapillaryImportedImage)mimg).getFile().getPath();
                    finalPath = path.substring(0, path.lastIndexOf(46));
                } else if (mimg instanceof MapillaryImage) {
                    finalPath = this.path + "/" + ((MapillaryImage)mimg).getKey();
                } else if (mimg instanceof MapillaryImportedImage) {
                    finalPath = this.path + "/" + ((MapillaryImportedImage)mimg).getFile().getName();
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)img, "jpg", outputStream);
                byte[] imageBytes = outputStream.toByteArray();
                TiffOutputSet outputSet = null;
                TiffOutputDirectory exifDirectory = null;
                TiffOutputDirectory gpsDirectory = null;
                if (mimg instanceof MapillaryImportedImage && null != (jpegMetadata = (JpegImageMetadata)(metadata = Imaging.getMetadata((File)((MapillaryImportedImage)mimg).getFile()))) && null != (exif = jpegMetadata.getExif())) {
                    outputSet = exif.getOutputSet();
                }
                if (null == outputSet) {
                    outputSet = new TiffOutputSet();
                }
                exifDirectory = outputSet.getOrCreateExifDirectory();
                gpsDirectory = outputSet.getOrCreateGPSDirectory();
                gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION_REF);
                gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION_REF, new String[]{"T"});
                gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION);
                gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION, new RationalNumber[]{RationalNumber.valueOf((double)mimg.getCa())});
                exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
                if (mimg instanceof MapillaryImportedImage) {
                    exifDirectory.add(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL, new String[]{((MapillaryImportedImage)mimg).getDate("yyyy/MM/dd hh:mm:ss")});
                } else if (mimg instanceof MapillaryImage) {
                    exifDirectory.add(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL, new String[]{((MapillaryImage)mimg).getDate("yyyy/MM/dd hh/mm/ss")});
                }
                outputSet.setGPSInDegrees(mimg.getLatLon().lon(), mimg.getLatLon().lat());
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(finalPath + ".jpg"));
                new ExifRewriter().updateExifMetadataLossless(imageBytes, (OutputStream)os, outputSet);
                ((OutputStream)os).close();
            }
            catch (InterruptedException e) {
                Main.info((String)"Mapillary export cancelled");
                return;
            }
            catch (IOException e) {
                Main.error((Throwable)e);
            }
            catch (ImageWriteException e) {
                Main.error((Throwable)e);
            }
            catch (ImageReadException e) {
                Main.error((Throwable)e);
            }
            this.monitor.worked(10000 / this.amount);
            this.monitor.setCustomText("Downloaded " + (i + 1) + "/" + this.amount);
        }
    }
}

