/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.cache;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;

public class MapillaryCache
extends JCSCachedTileLoaderJob<String, BufferedImageCacheEntry> {
    private volatile URL url;
    private volatile String key;

    public MapillaryCache(String key, Type type) {
        super(MapillaryPlugin.CACHE, 50000, 50000, new HashMap());
        this.key = key;
        try {
            switch (type) {
                case FULL_IMAGE: {
                    this.url = new URL("https://d1cuyjsrcm0gby.cloudfront.net/" + key + "/thumb-2048.jpg");
                    this.key = this.key + ".FULL_IMAGE";
                    break;
                }
                case THUMBNAIL: {
                    this.url = new URL("https://d1cuyjsrcm0gby.cloudfront.net/" + key + "/thumb-320.jpg");
                    this.key = this.key + ".THUMBNAIL";
                }
            }
        }
        catch (MalformedURLException e) {
            Main.error((Throwable)e);
        }
    }

    public String getCacheKey() {
        return this.key;
    }

    public URL getUrl() {
        return this.url;
    }

    protected BufferedImageCacheEntry createCacheEntry(byte[] content) {
        return new BufferedImageCacheEntry(content);
    }

    protected boolean isObjectLoadable() {
        if (this.cacheData == null) {
            return false;
        }
        byte[] content = ((BufferedImageCacheEntry)this.cacheData).getContent();
        return content != null && content.length > 0;
    }

    public static enum Type {
        FULL_IMAGE,
        THUMBNAIL;

    }
}

