/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;

public class MapillarySequenceDownloadThread
extends Thread {
    private static final String URL = "https://a.mapillary.com/v2/search/s/";
    private static final Lock LOCK = new ReentrantLock();
    private final String queryString;
    private final ExecutorService ex;
    private final MapillaryLayer layer;

    public MapillarySequenceDownloadThread(ExecutorService ex, String queryString) {
        this.queryString = queryString;
        this.ex = ex;
        this.layer = MapillaryLayer.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new URL(URL + this.queryString).openStream(), "UTF-8"));
            JsonObject jsonall = Json.createReader((Reader)br).readObject();
            if (!jsonall.getBoolean("more") && !this.ex.isShutdown()) {
                this.ex.shutdown();
            }
            JsonArray jsonseq = jsonall.getJsonArray("ss");
            boolean isSequenceWrong = false;
            for (int i = 0; i < jsonseq.size(); ++i) {
                JsonObject jsonobj = jsonseq.getJsonObject(i);
                JsonArray cas = jsonobj.getJsonArray("cas");
                JsonArray coords = jsonobj.getJsonArray("coords");
                JsonArray keys = jsonobj.getJsonArray("keys");
                ArrayList<MapillaryImage> images = new ArrayList<MapillaryImage>();
                for (int j = 0; j < cas.size(); ++j) {
                    try {
                        images.add(new MapillaryImage(keys.getString(j), coords.getJsonArray(j).getJsonNumber(1).doubleValue(), coords.getJsonArray(j).getJsonNumber(0).doubleValue(), cas.getJsonNumber(j).doubleValue()));
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        Main.warn((String)("Mapillary bug at https://a.mapillary.com/v2/search/s/" + this.queryString));
                        isSequenceWrong = true;
                    }
                }
                if (isSequenceWrong) break;
                MapillarySequence sequence = new MapillarySequence(jsonobj.getString("key"), jsonobj.getJsonNumber("captured_at").longValue());
                ArrayList<MapillaryImage> finalImages = new ArrayList<MapillaryImage>(images);
                for (MapillaryAbstractImage mapillaryAbstractImage : images) {
                    if (this.isInside(mapillaryAbstractImage)) continue;
                    finalImages.remove(mapillaryAbstractImage);
                }
                LOCK.lock();
                MapillaryAbstractImage.LOCK.lock();
                try {
                    for (MapillaryImage mapillaryImage : finalImages) {
                        if (this.layer.getData().getImages().contains(mapillaryImage)) {
                            MapillaryImage mapillaryImage2 = (MapillaryImage)this.layer.getData().getImages().get(this.layer.getData().getImages().indexOf(mapillaryImage));
                            sequence.add(mapillaryImage2);
                            ((MapillaryImage)this.layer.getData().getImages().get(this.layer.getData().getImages().indexOf(mapillaryImage2))).setSequence(sequence);
                            finalImages.set(finalImages.indexOf(mapillaryImage2), mapillaryImage2);
                            continue;
                        }
                        mapillaryImage.setSequence(sequence);
                        sequence.add(mapillaryImage);
                    }
                }
                finally {
                    MapillaryAbstractImage.LOCK.unlock();
                    LOCK.unlock();
                }
                this.layer.getData().add(new ArrayList<MapillaryAbstractImage>(finalImages), false);
            }
        }
        catch (IOException e) {
            Main.error((String)("Error reading the url https://a.mapillary.com/v2/search/s/" + this.queryString + " might be a Mapillary problem."));
        }
        MapillaryData.dataUpdated();
    }

    private boolean isInside(MapillaryAbstractImage image) {
        for (int i = 0; i < this.layer.getData().bounds.size(); ++i) {
            if (!this.layer.getData().bounds.get(i).contains(image.getLatLon())) continue;
            return true;
        }
        return false;
    }
}

