/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.commands;

import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.commands.MapillaryCommand;
import org.openstreetmap.josm.tools.I18n;

public class CommandTurnImage
extends MapillaryCommand {
    private double ca;

    public CommandTurnImage(List<MapillaryAbstractImage> images, double ca) {
        this.images = images;
        this.ca = ca;
    }

    @Override
    public void undo() {
        for (MapillaryAbstractImage image : this.images) {
            image.turn(-this.ca);
            image.stopMoving();
        }
        this.checkModified();
        if (Main.main != null) {
            Main.map.repaint();
        }
    }

    @Override
    public void redo() {
        for (MapillaryAbstractImage image : this.images) {
            image.turn(this.ca);
            image.stopMoving();
        }
        this.checkModified();
        if (Main.main != null) {
            Main.map.repaint();
        }
    }

    public String toString() {
        return I18n.trn((String)"Turned {0} image", (String)"Turned {0} images", (long)this.images.size(), (Object[])new Object[]{this.images.size()});
    }

    @Override
    public void sum(MapillaryCommand command) {
        if (command instanceof CommandTurnImage) {
            this.ca += ((CommandTurnImage)command).ca;
        }
    }
}

