/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.cache;

import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.cache.MapillaryCache;

public class CacheUtils {
    private static IgnoreDownload IGNORE_DOWNLOAD = new IgnoreDownload();

    public static void downloadPicture(MapillaryImage img) {
        CacheUtils.downloadPicture(img, PICTURE.BOTH);
    }

    public static void downloadPicture(MapillaryImage img, PICTURE pic) {
        switch (pic) {
            case BOTH: {
                if (new MapillaryCache(img.getKey(), MapillaryCache.Type.THUMBNAIL).get() == null) {
                    new MapillaryCache(img.getKey(), MapillaryCache.Type.THUMBNAIL).submit(IGNORE_DOWNLOAD, false);
                }
                if (new MapillaryCache(img.getKey(), MapillaryCache.Type.FULL_IMAGE).get() != null) break;
                new MapillaryCache(img.getKey(), MapillaryCache.Type.FULL_IMAGE).submit(IGNORE_DOWNLOAD, false);
                break;
            }
            case THUMBNAIL: {
                new MapillaryCache(img.getKey(), MapillaryCache.Type.THUMBNAIL).submit(IGNORE_DOWNLOAD, false);
                break;
            }
            case FULL_IMAGE: {
                new MapillaryCache(img.getKey(), MapillaryCache.Type.FULL_IMAGE).submit(IGNORE_DOWNLOAD, false);
            }
        }
    }

    private static class IgnoreDownload
    implements ICachedLoaderListener {
        private IgnoreDownload() {
        }

        public void loadingFinished(CacheEntry arg0, CacheEntryAttributes arg1, ICachedLoaderListener.LoadResult arg2) {
        }
    }

    public static enum PICTURE {
        THUMBNAIL,
        FULL_IMAGE,
        BOTH;

    }
}

