/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryImportIntoSequenceAction
extends JosmAction {
    private static final long serialVersionUID = -9190217809965894878L;
    private JFileChooser chooser;
    private LinkedList<MapillaryImportedImage> images;

    public MapillaryImportIntoSequenceAction() {
        super(I18n.tr((String)"Import pictures into sequence", (Object[])new Object[0]), MapillaryPlugin.getProvider("icon24.png"), I18n.tr((String)"Import local pictures", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Import Mapillary Sequence", (String)I18n.tr((String)"Import pictures into Mapillary layer in a sequence", (Object[])new Object[0]), (int)65535, (int)5000), false, "mapillaryImportSequence", false);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent arg0) {
        this.images = new LinkedList();
        this.chooser = new JFileChooser();
        File startDirectory = new File(Main.pref.get("mapillary.start-directory", System.getProperty("user.home")));
        this.chooser.setCurrentDirectory(startDirectory);
        this.chooser.setDialogTitle(I18n.tr((String)"Select pictures", (Object[])new Object[0]));
        this.chooser.setFileSelectionMode(2);
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.addChoosableFileFilter(new FileNameExtensionFilter("images", "jpg", "jpeg"));
        this.chooser.setMultiSelectionEnabled(true);
        if (this.chooser.showOpenDialog(Main.parent) == 0) {
            File file;
            for (int i = 0; i < this.chooser.getSelectedFiles().length && (file = this.chooser.getSelectedFiles()[i]) != null; ++i) {
                Main.pref.put("mapillary.start-directory", file.getParent());
                MapillaryLayer.getInstance();
                if (file.isDirectory()) {
                    for (int j = 0; j < file.listFiles().length; ++j) {
                        int k = file.listFiles()[j].getName().lastIndexOf(46);
                        String extension = null;
                        if (k > 0) {
                            extension = file.listFiles()[j].getName().substring(k + 1);
                        }
                        try {
                            if (!extension.equals("jpg") && !extension.equals("jpeg")) continue;
                            this.readJPG(file.listFiles()[j]);
                            continue;
                        }
                        catch (IOException | NullPointerException | ImageReadException e) {
                            Main.error((Throwable)e);
                        }
                    }
                    continue;
                }
                if (!file.getPath().substring(file.getPath().length() - 4).equals(".jpg") && !file.getPath().substring(file.getPath().length() - 5).equals(".jpeg")) continue;
                try {
                    this.readJPG(file);
                    continue;
                }
                catch (ImageReadException ex) {
                    Main.error((Throwable)ex);
                    continue;
                }
                catch (IOException ex) {
                    Main.error((Throwable)ex);
                }
            }
            this.joinImages();
        }
        MapillaryLayer.getInstance().showAllPictures();
    }

    public void readJPG(File file) throws ImageReadException, IOException {
        ImageMetadata metadata = Imaging.getMetadata((File)file);
        if (metadata instanceof JpegImageMetadata) {
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            TiffField lat_ref = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE_REF);
            TiffField lat = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE);
            TiffField lon_ref = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE_REF);
            TiffField lon = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE);
            TiffField ca = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION);
            TiffField datetimeOriginal = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
            if (lat_ref == null || lat == null || lon == null || lon_ref == null || datetimeOriginal == null) {
                return;
            }
            double latValue = 0.0;
            double lonValue = 0.0;
            double caValue = 0.0;
            if (lat.getValue() instanceof RationalNumber[]) {
                latValue = MapillaryUtils.degMinSecToDouble((RationalNumber[])lat.getValue(), lat_ref.getValue().toString());
            }
            if (lon.getValue() instanceof RationalNumber[]) {
                lonValue = MapillaryUtils.degMinSecToDouble((RationalNumber[])lon.getValue(), lon_ref.getValue().toString());
            }
            if (ca != null && ca.getValue() instanceof RationalNumber) {
                caValue = ((RationalNumber)ca.getValue()).doubleValue();
            }
            MapillaryImportedImage image = new MapillaryImportedImage(latValue, lonValue, caValue, file, datetimeOriginal.getStringValue());
            MapillaryLayer.getInstance().getData().add(image);
            image.getCapturedAt();
            this.images.add(image);
        }
    }

    public void joinImages() {
        Collections.sort(this.images, new MapillaryEpochComparator());
        MapillarySequence seq = new MapillarySequence();
        for (MapillaryImportedImage img : this.images) {
            seq.add(img);
            img.setSequence(seq);
        }
    }

    public class MapillaryEpochComparator
    implements Comparator<MapillaryAbstractImage> {
        @Override
        public int compare(MapillaryAbstractImage arg0, MapillaryAbstractImage arg1) {
            if (arg0.getCapturedAt() < arg1.getCapturedAt()) {
                return -1;
            }
            if (arg0.getCapturedAt() > arg1.getCapturedAt()) {
                return 1;
            }
            return 0;
        }
    }
}

