/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;

public class MapillaryImportedImage
extends MapillaryAbstractImage {
    protected File file;
    public final long datetimeOriginal;

    public MapillaryImportedImage(double lat, double lon, double ca, File file) {
        this(lat, lon, ca, file, MapillaryImportedImage.currentDate());
    }

    public MapillaryImportedImage(double lat, double lon, double ca, File file, String datetimeOriginal) {
        super(lat, lon, ca);
        this.file = file;
        this.datetimeOriginal = MapillaryImportedImage.getEpoch(datetimeOriginal, "yyyy:MM:dd hh:mm:ss");
    }

    public BufferedImage getImage() throws IOException {
        if (this.file != null) {
            return ImageIO.read(this.file);
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public boolean equals(Object object) {
        if (object instanceof MapillaryImportedImage) {
            return this.file.equals(((MapillaryImportedImage)object).file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    private static String currentDate() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy:MM:dd hh:mm:ss");
        return formatter.format(cal.getTime());
    }
}

