/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.Serializer;
import org.mapdb.Utils;

public class SnapshotEngine
extends EngineWrapper {
    protected final ReentrantLock[] locks = Utils.newLocks(32);
    protected static final Object NOT_EXIST = new Object();
    protected static final Object NOT_INIT_YET = new Object();
    protected final Map<Snapshot, String> snapshots = new ConcurrentHashMap<Snapshot, String>();
    protected final ReentrantReadWriteLock snapshotsLock = new ReentrantReadWriteLock();

    protected SnapshotEngine(Engine engine) {
        super(engine);
    }

    public Engine snapshot() {
        return new Snapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long recid = super.put(value, serializer);
        Utils.lock(this.locks, recid);
        try {
            for (Snapshot s : this.snapshots.keySet()) {
                s.oldValues.putIfAbsent(recid, NOT_EXIST);
            }
            long l = recid;
            return l;
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        Utils.lock(this.locks, recid);
        try {
            boolean ret = super.compareAndSwap(recid, expectedOldValue, newValue, serializer);
            if (ret) {
                for (Snapshot s : this.snapshots.keySet()) {
                    s.oldValues.putIfAbsent(recid, expectedOldValue);
                }
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        Utils.lock(this.locks, recid);
        try {
            Object val = NOT_INIT_YET;
            for (Snapshot s : this.snapshots.keySet()) {
                if (s.oldValues.get(recid) != null) continue;
                if (val == NOT_INIT_YET) {
                    val = this.get(recid, serializer);
                }
                s.oldValues.put(recid, val);
            }
            super.update(recid, value, serializer);
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        Utils.lock(this.locks, recid);
        try {
            Object val = NOT_INIT_YET;
            for (Snapshot s : this.snapshots.keySet()) {
                if (s.oldValues.get(recid) != null) continue;
                if (val == NOT_INIT_YET) {
                    val = this.get(recid, serializer);
                }
                s.oldValues.put(recid, val);
            }
            super.delete(recid, serializer);
        }
        finally {
            Utils.unlock(this.locks, recid);
        }
    }

    public static Engine createSnapshotFor(Engine engine) {
        SnapshotEngine se;
        block1: {
            se = null;
            while (true) {
                if (engine instanceof SnapshotEngine) break block1;
                if (!(engine instanceof EngineWrapper)) break;
                engine = ((EngineWrapper)engine).getWrappedEngine();
            }
            throw new IllegalArgumentException("Could not create Snapshot for Engine: " + engine);
        }
        se = (SnapshotEngine)engine;
        return se.snapshot();
    }

    protected class Snapshot
    extends EngineWrapper.ReadOnlyEngine {
        protected LongConcurrentHashMap oldValues;

        public Snapshot() {
            super(SnapshotEngine.this);
            this.oldValues = new LongConcurrentHashMap();
            SnapshotEngine.this.snapshots.put(this, "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            Utils.lock(SnapshotEngine.this.locks, recid);
            try {
                Object ret = this.oldValues.get(recid);
                if (ret != null) {
                    if (ret == NOT_EXIST) {
                        A a = null;
                        return a;
                    }
                    Object v = ret;
                    return (A)v;
                }
                A a = SnapshotEngine.this.getWrappedEngine().get(recid, serializer);
                return a;
            }
            finally {
                Utils.unlock(SnapshotEngine.this.locks, recid);
            }
        }

        @Override
        public boolean isClosed() {
            return this.oldValues != null;
        }

        @Override
        public void close() {
            SnapshotEngine.this.snapshots.remove(this);
            this.oldValues.clear();
        }
    }
}

