/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmrec;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.relation.DownloadMembersAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.actions.relation.SelectInRelationListAction;
import org.openstreetmap.josm.actions.relation.SelectMembersAction;
import org.openstreetmap.josm.actions.relation.SelectRelationAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesCellRenderer;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.PresetHandler;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.plugins.osmrec.OSMRecPluginHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class OSMRecToggleDialog
extends ToggleDialog
implements SelectionChangedListener,
MapView.EditLayerChangeListener,
DataSetListenerAdapter.Listener {
    public static final JPanel pluginHook = new JPanel();
    private final DefaultTableModel tagData = new ReadOnlyTableModel();
    private final DefaultTableModel membershipData = new ReadOnlyTableModel();
    private final JTable tagTable = new JTable(this.tagData);
    private final JTable membershipTable = new JTable(this.membershipData);
    private final JPanel bothTables = new JPanel();
    private final JPopupMenu tagMenu = new JPopupMenu();
    private final JPopupMenu membershipMenu = new JPopupMenu();
    private final JPopupMenu blankSpaceMenu = new JPopupMenu();
    private final PopupMenuHandler tagMenuHandler = new PopupMenuHandler(this.tagMenu);
    private final PopupMenuHandler membershipMenuHandler = new PopupMenuHandler(this.membershipMenu);
    private final PopupMenuHandler blankSpaceMenuHandler = new PopupMenuHandler(this.blankSpaceMenu);
    private final Map<String, Map<String, Integer>> valueCount = new TreeMap<String, Map<String, Integer>>();
    private final OSMRecPluginHelper editHelper = new OSMRecPluginHelper(this.tagData, this.valueCount);
    private final DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter((DataSetListenerAdapter.Listener)this);
    private final HelpAction helpAction = new HelpAction();
    private final PasteValueAction pasteValueAction = new PasteValueAction();
    private final CopyValueAction copyValueAction = new CopyValueAction();
    private final CopyKeyValueAction copyKeyValueAction = new CopyKeyValueAction();
    private final CopyAllKeyValueAction copyAllKeyValueAction = new CopyAllKeyValueAction();
    private final SearchAction searchActionSame = new SearchAction(true);
    private final SearchAction searchActionAny = new SearchAction(false);
    private final AddAction addAction = new AddAction();
    private final EditActionTrain editAction = new EditActionTrain();
    private final DeleteAction deleteAction = new DeleteAction();
    private final JosmAction[] josmActions = new JosmAction[]{this.addAction, this.editAction, this.deleteAction};
    private final SelectInRelationListAction setRelationSelectionAction = new SelectInRelationListAction();
    private final SelectRelationAction selectRelationAction = new SelectRelationAction(false);
    private final SelectRelationAction addRelationToSelectionAction = new SelectRelationAction(true);
    private final DownloadMembersAction downloadMembersAction = new DownloadMembersAction();
    private final DownloadSelectedIncompleteMembersAction downloadSelectedIncompleteMembersAction = new DownloadSelectedIncompleteMembersAction();
    private final SelectMembersAction selectMembersAction = new SelectMembersAction(false);
    private final SelectMembersAction addMembersToSelectionAction = new SelectMembersAction(true);
    private final HighlightHelper highlightHelper = new HighlightHelper();
    private final SideButton btnAdd = new SideButton((Action)((Object)this.addAction));
    private final SideButton btnEdit = new SideButton((Action)((Object)this.editAction));
    private final SideButton btnDel = new SideButton((Action)((Object)this.deleteAction));
    private final PresetListPanel presets = new PresetListPanel();
    private final JLabel selectSth = new JLabel("<html><p>" + I18n.tr((String)"Select objects or create new objects and get recommendation.", (Object[])new Object[0]) + "</p></html>");
    private final PresetHandler presetHandler = new PresetHandler(){

        public void updateTags(List<Tag> tags) {
            Command command = TaggingPreset.createCommand(this.getSelection(), tags);
            if (command != null) {
                Main.main.undoRedo.add(command);
            }
        }

        public Collection<OsmPrimitive> getSelection() {
            if (Main.main == null) {
                return null;
            }
            return Main.main.getInProgressSelection();
        }
    };

    public OSMRecToggleDialog() {
        super(I18n.tr((String)"Tags/Memberships", (Object[])new Object[0]), "propertiesdialog", I18n.tr((String)"Tags for selected objects.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:properties", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Tags/Memberships", (Object[])new Object[0])}), (int)80, (int)5007), 150, true);
        HelpUtil.setHelpContext((JComponent)((Object)this), (String)HelpUtil.ht((String)"/Dialog/TagsMembership"));
        this.setupTagsMenu();
        this.buildTagsTable();
        this.setupMembershipMenu();
        this.buildMembershipTable();
        boolean top = Main.pref.getBoolean("properties.presets.top", true);
        this.bothTables.setLayout(new GridBagLayout());
        if (top) {
            this.bothTables.add((Component)this.presets, GBC.std().fill(2).insets(5, 2, 5, 2).anchor(18));
            double epsilon = Double.MIN_VALUE;
            this.bothTables.add((Component)pluginHook, GBC.eol().insets(0, 1, 1, 1).anchor(12).weight(epsilon, epsilon));
        }
        this.bothTables.add((Component)this.selectSth, GBC.eol().fill().insets(10, 10, 10, 10));
        this.bothTables.add((Component)this.tagTable.getTableHeader(), GBC.eol().fill(2));
        this.bothTables.add((Component)this.tagTable, GBC.eol().fill(1));
        this.bothTables.add((Component)this.membershipTable.getTableHeader(), GBC.eol().fill(2));
        this.bothTables.add((Component)this.membershipTable, GBC.eol().fill(1));
        if (!top) {
            this.bothTables.add((Component)this.presets, GBC.eol().fill(2).insets(5, 2, 5, 2));
        }
        this.bothTables.setVisible(false);
        this.setupBlankSpaceMenu();
        this.setupKeyboardShortcuts();
        this.tagTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.tagTable.getSelectionModel().addListSelectionListener(this.deleteAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.deleteAction);
        JScrollPane scrollPane = (JScrollPane)this.createLayout(this.bothTables, true, Arrays.asList(this.btnAdd, this.btnEdit, this.btnDel));
        MouseClickWatch mouseClickWatch = new MouseClickWatch();
        this.tagTable.addMouseListener(mouseClickWatch);
        this.membershipTable.addMouseListener(mouseClickWatch);
        scrollPane.addMouseListener(mouseClickWatch);
        this.selectSth.setPreferredSize(scrollPane.getSize());
        this.presets.setSize(scrollPane.getSize());
        this.editHelper.loadTagsIfNeeded();
        Main.pref.addPreferenceChangeListener((Preferences.PreferenceChangedListener)this);
        scrollPane.setVisible(false);
    }

    private void buildTagsTable() {
        this.tagData.setColumnIdentifiers(new String[]{I18n.tr((String)"Key", (Object[])new Object[0]), I18n.tr((String)"Value", (Object[])new Object[0])});
        this.tagTable.setSelectionMode(2);
        this.tagTable.getTableHeader().setReorderingAllowed(false);
        PropertiesCellRenderer cellRenderer = new PropertiesCellRenderer();
        this.tagTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)cellRenderer);
        this.tagTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)cellRenderer);
    }

    private void buildMembershipTable() {
        this.membershipData.setColumnIdentifiers(new String[]{I18n.tr((String)"Member Of", (Object[])new Object[0]), I18n.tr((String)"Role", (Object[])new Object[0]), I18n.tr((String)"Position", (Object[])new Object[0])});
        this.membershipTable.setSelectionMode(2);
        TableColumnModel mod = this.membershipTable.getColumnModel();
        this.membershipTable.getTableHeader().setReorderingAllowed(false);
        mod.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                if (value == null) {
                    return this;
                }
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    Relation r = (Relation)value;
                    label.setText(r.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()));
                    if (r.isDisabledAndHidden()) {
                        label.setFont(label.getFont().deriveFont(2));
                    }
                }
                return c;
            }
        });
        mod.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value == null) {
                    return this;
                }
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                boolean isDisabledAndHidden = ((Relation)table.getValueAt(row, 0)).isDisabledAndHidden();
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    label.setText(((MemberInfo)value).getRoleString());
                    if (isDisabledAndHidden) {
                        label.setFont(label.getFont().deriveFont(2));
                    }
                }
                return c;
            }
        });
        mod.getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                boolean isDisabledAndHidden = ((Relation)table.getValueAt(row, 0)).isDisabledAndHidden();
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    label.setText(((MemberInfo)table.getValueAt(row, 1)).getPositionString());
                    if (isDisabledAndHidden) {
                        label.setFont(label.getFont().deriveFont(2));
                    }
                }
                return c;
            }
        });
        mod.getColumn(2).setPreferredWidth(20);
        mod.getColumn(1).setPreferredWidth(40);
        mod.getColumn(0).setPreferredWidth(200);
    }

    private void setupBlankSpaceMenu() {
        if (Main.pref.getBoolean("properties.menu.add_edit_delete", true)) {
            this.blankSpaceMenuHandler.addAction((Action)((Object)this.addAction));
            PopupMenuLauncher launcher = new PopupMenuLauncher(this.blankSpaceMenu){

                protected boolean checkSelection(Component component, Point p) {
                    if (component instanceof JTable) {
                        return ((JTable)component).rowAtPoint(p) == -1;
                    }
                    return true;
                }
            };
            this.bothTables.addMouseListener((MouseListener)launcher);
            this.tagTable.addMouseListener((MouseListener)launcher);
        }
    }

    private void setupMembershipMenu() {
        if (Main.pref.getBoolean("properties.menu.add_edit_delete", true)) {
            this.membershipMenuHandler.addAction((Action)((Object)this.editAction));
            this.membershipMenuHandler.addAction((Action)((Object)this.deleteAction));
            this.membershipMenu.addSeparator();
        }
        this.membershipMenuHandler.addAction((Action)this.setRelationSelectionAction);
        this.membershipMenuHandler.addAction((Action)this.selectRelationAction);
        this.membershipMenuHandler.addAction((Action)this.addRelationToSelectionAction);
        this.membershipMenuHandler.addAction((Action)this.selectMembersAction);
        this.membershipMenuHandler.addAction((Action)this.addMembersToSelectionAction);
        this.membershipMenu.addSeparator();
        this.membershipMenuHandler.addAction((Action)this.downloadMembersAction);
        this.membershipMenuHandler.addAction((Action)this.downloadSelectedIncompleteMembersAction);
        this.membershipMenu.addSeparator();
        this.membershipMenu.add(this.helpAction);
        this.membershipTable.addMouseListener((MouseListener)new PopupMenuLauncher(this.membershipMenu){

            protected int checkTableSelection(JTable table, Point p) {
                int row = super.checkTableSelection(table, p);
                ArrayList<Relation> rels = new ArrayList<Relation>();
                for (int i : table.getSelectedRows()) {
                    rels.add((Relation)table.getValueAt(i, 0));
                }
                OSMRecToggleDialog.this.membershipMenuHandler.setPrimitives(rels);
                return row;
            }

            public void mouseClicked(MouseEvent e) {
                int row;
                if (Main.isDisplayingMapView() && (row = OSMRecToggleDialog.this.membershipTable.rowAtPoint(e.getPoint())) >= 0 && OSMRecToggleDialog.this.highlightHelper.highlightOnly((OsmPrimitive)((Relation)OSMRecToggleDialog.this.membershipTable.getValueAt(row, 0)))) {
                    Main.map.mapView.repaint();
                }
                super.mouseClicked(e);
            }

            public void mouseExited(MouseEvent me) {
                OSMRecToggleDialog.this.highlightHelper.clear();
            }
        });
    }

    private void setupTagsMenu() {
        if (Main.pref.getBoolean("properties.menu.add_edit_delete", true)) {
            this.tagMenu.add((Action)((Object)this.addAction));
            this.tagMenu.add((Action)((Object)this.editAction));
            this.tagMenu.add((Action)((Object)this.deleteAction));
            this.tagMenu.addSeparator();
        }
        this.tagMenu.add(this.pasteValueAction);
        this.tagMenu.add(this.copyValueAction);
        this.tagMenu.add(this.copyKeyValueAction);
        this.tagMenu.add(this.copyAllKeyValueAction);
        this.tagMenu.addSeparator();
        this.tagMenu.add(this.searchActionAny);
        this.tagMenu.add(this.searchActionSame);
        this.tagMenu.addSeparator();
        this.tagMenu.add(this.helpAction);
        this.tagTable.addMouseListener((MouseListener)new PopupMenuLauncher(this.tagMenu));
    }

    private void setupKeyboardShortcuts() {
        this.tagTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "onTableEnter");
        this.tagTable.getActionMap().put("onTableEnter", (Action)((Object)this.editAction));
        this.membershipTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "onTableEnter");
        this.membershipTable.getActionMap().put("onTableEnter", (Action)((Object)this.editAction));
        this.tagTable.getInputMap(1).put(KeyStroke.getKeyStroke(155, 0), "onTableInsert");
        this.tagTable.getActionMap().put("onTableInsert", (Action)((Object)this.addAction));
        InputMapUtils.unassignCtrlShiftUpDown((JComponent)this.tagTable, (int)1);
        InputMapUtils.unassignPageUpDown((JComponent)this.tagTable, (int)1);
        this.tagTable.setTransferHandler(null);
        this.tagTable.getInputMap(1).put(KeyStroke.getKeyStroke(67, 2), "onCopy");
        this.tagTable.getActionMap().put("onCopy", this.copyKeyValueAction);
        InputMapUtils.enableEnter((JButton)this.btnAdd);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", (Action)((Object)this.deleteAction));
        this.getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), "onHelp");
        this.getActionMap().put("onHelp", this.helpAction);
    }

    private void editMembership(int row) {
        Relation relation = (Relation)this.membershipData.getValueAt(row, 0);
        Main.map.relationListDialog.selectRelation(relation);
        RelationEditor.getEditor((OsmDataLayer)Main.main.getEditLayer(), (Relation)relation, (Collection)((MemberInfo)this.membershipData.getValueAt(row, 1)).role).setVisible(true);
    }

    private int findRow(TableModel model, Object value) {
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (!model.getValueAt(i, 0).equals(value)) continue;
            return i;
        }
        return -1;
    }

    private void updateSelection() {
        this.selectionChanged(null);
    }

    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener((DataSetListener)this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        SelectionEventManager.getInstance().addSelectionListener((SelectionChangedListener)this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        for (JosmAction action : this.josmActions) {
            Main.registerActionShortcut((JosmAction)action);
        }
        this.updateSelection();
    }

    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener((DataSetListener)this.dataChangedAdapter);
        SelectionEventManager.getInstance().removeSelectionListener((SelectionChangedListener)this);
        MapView.removeEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        for (JosmAction action : this.josmActions) {
            Main.unregisterActionShortcut((JosmAction)action);
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && Main.main.getCurrentDataSet() != null) {
            this.updateSelection();
        }
    }

    public void destroy() {
        super.destroy();
        Main.pref.removePreferenceChangeListener((Preferences.PreferenceChangedListener)this);
        for (JosmAction action : this.josmActions) {
            action.destroy();
        }
        Container parent = pluginHook.getParent();
        if (parent != null) {
            parent.remove(pluginHook);
        }
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        int selectedIndex;
        List<OsmPrimitive> newSel;
        if (!this.isVisible()) {
            return;
        }
        if (this.tagTable == null) {
            return;
        }
        if (this.tagTable.getCellEditor() != null) {
            this.tagTable.getCellEditor().cancelCellEditing();
        }
        if ((newSel = Main.main.getInProgressSelection()) == null) {
            newSel = Collections.emptyList();
        }
        Relation selectedRelation = null;
        String selectedTag = this.editHelper.getChangedKey();
        if (selectedTag == null && this.tagTable.getSelectedRowCount() == 1) {
            selectedTag = (String)this.tagData.getValueAt(this.tagTable.getSelectedRow(), 0);
        }
        if (this.membershipTable.getSelectedRowCount() == 1) {
            selectedRelation = (Relation)this.membershipData.getValueAt(this.membershipTable.getSelectedRow(), 0);
        }
        this.tagData.setRowCount(0);
        boolean displayDiscardableKeys = Main.pref.getBoolean("display.discardable-keys", false);
        HashMap<String, Integer> keyCount = new HashMap<String, Integer>();
        HashMap tags = new HashMap();
        this.valueCount.clear();
        EnumSet<TaggingPresetType> types = EnumSet.noneOf(TaggingPresetType.class);
        for (OsmPrimitive osmPrimitive : newSel) {
            types.add(TaggingPresetType.forPrimitive((OsmPrimitive)osmPrimitive));
            for (String key : osmPrimitive.keySet()) {
                Map<Object, Object> v;
                if (!displayDiscardableKeys && OsmPrimitive.getDiscardableKeys().contains(key)) continue;
                String value = osmPrimitive.get(key);
                keyCount.put(key, keyCount.containsKey(key) ? (Integer)keyCount.get(key) + 1 : 1);
                if (this.valueCount.containsKey(key)) {
                    v.put(value, (v = this.valueCount.get(key)).containsKey(value) ? (Integer)v.get(value) + 1 : 1);
                    continue;
                }
                v = new TreeMap<String, Integer>();
                ((TreeMap)v).put(value, 1);
                this.valueCount.put(key, v);
            }
        }
        for (Map.Entry entry : this.valueCount.entrySet()) {
            int count = 0;
            for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                count += ((Integer)e1.getValue()).intValue();
            }
            if (count < newSel.size()) {
                ((Map)entry.getValue()).put("", newSel.size() - count);
            }
            this.tagData.addRow(new Object[]{entry.getKey(), entry.getValue()});
            tags.put(entry.getKey(), ((Map)entry.getValue()).size() == 1 ? (String)((Map)entry.getValue()).keySet().iterator().next() : I18n.tr((String)"<different>", (Object[])new Object[0]));
        }
        this.membershipData.setRowCount(0);
        HashMap<Relation, MemberInfo> roles = new HashMap<Relation, MemberInfo>();
        for (OsmPrimitive primitive : newSel) {
            for (OsmPrimitive ref : primitive.getReferrers(true)) {
                if (!(ref instanceof Relation) || ref.isIncomplete() || ref.isDeleted()) continue;
                Relation r = (Relation)ref;
                MemberInfo mi = (MemberInfo)roles.get(r);
                if (mi == null) {
                    mi = new MemberInfo(newSel);
                }
                roles.put(r, mi);
                int i = 1;
                for (RelationMember m : r.getMembers()) {
                    if (m.getMember() == primitive) {
                        mi.add(m, i);
                    }
                    ++i;
                }
            }
        }
        ArrayList arrayList = new ArrayList(roles.keySet());
        Collections.sort(arrayList, new Comparator<Relation>(){

            @Override
            public int compare(Relation o1, Relation o2) {
                int comp = Boolean.valueOf(o1.isDisabledAndHidden()).compareTo(o2.isDisabledAndHidden());
                return comp != 0 ? comp : DefaultNameFormatter.getInstance().getRelationComparator().compare(o1, o2);
            }
        });
        for (Relation r : arrayList) {
            this.membershipData.addRow(new Object[]{r, roles.get(r)});
        }
        this.presets.updatePresets(types, tags, this.presetHandler);
        this.membershipTable.getTableHeader().setVisible(this.membershipData.getRowCount() > 0);
        this.membershipTable.setVisible(this.membershipData.getRowCount() > 0);
        boolean hasSelection = !newSel.isEmpty();
        boolean hasTags = hasSelection && this.tagData.getRowCount() > 0;
        boolean hasMemberships = hasSelection && this.membershipData.getRowCount() > 0;
        this.addAction.setEnabled(hasSelection);
        this.editAction.setEnabled(true);
        this.deleteAction.setEnabled(hasTags || hasMemberships);
        this.tagTable.setVisible(hasTags);
        this.tagTable.getTableHeader().setVisible(hasTags);
        this.selectSth.setVisible(!hasSelection);
        pluginHook.setVisible(hasSelection);
        if (selectedTag != null && (selectedIndex = this.findRow(this.tagData, selectedTag)) != -1) {
            this.tagTable.changeSelection(selectedIndex, 0, false, false);
        } else if (selectedRelation != null && (selectedIndex = this.findRow(this.membershipData, selectedRelation)) != -1) {
            this.membershipTable.changeSelection(selectedIndex, 0, false, false);
        } else if (hasTags) {
            this.tagTable.changeSelection(0, 0, false, false);
        } else if (hasMemberships) {
            this.membershipTable.changeSelection(0, 0, false, false);
        }
        if (this.tagData.getRowCount() != 0 || this.membershipData.getRowCount() != 0) {
            this.setTitle(I18n.tr((String)"Tags: {0} / Memberships: {1}", (Object[])new Object[]{this.tagData.getRowCount(), this.membershipData.getRowCount()}));
        } else {
            this.setTitle(I18n.tr((String)"Tags / Memberships", (Object[])new Object[0]));
        }
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        if (newLayer == null) {
            this.editHelper.saveTagsIfNeeded();
        }
        GuiHelper.runInEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                OSMRecToggleDialog.this.updateSelection();
            }
        });
    }

    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.updateSelection();
    }

    public PopupMenuHandler getPropertyPopupMenuHandler() {
        return this.tagMenuHandler;
    }

    public Tag getSelectedProperty() {
        int row = this.tagTable.getSelectedRow();
        if (row == -1) {
            return null;
        }
        TreeMap map = (TreeMap)this.tagData.getValueAt(row, 1);
        return new Tag(this.tagData.getValueAt(row, 0).toString(), map.size() > 1 ? "" : (String)map.keySet().iterator().next());
    }

    public PopupMenuHandler getMembershipPopupMenuHandler() {
        return this.membershipMenuHandler;
    }

    public IRelation getSelectedMembershipRelation() {
        int row = this.membershipTable.getSelectedRow();
        return row > -1 ? (IRelation)this.membershipData.getValueAt(row, 0) : null;
    }

    public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
        super.preferenceChanged(e);
        if ("display.discardable-keys".equals(e.getKey()) && Main.main.getCurrentDataSet() != null) {
            this.updateSelection();
        }
    }

    class SearchAction
    extends AbstractAction {
        final boolean sameType;

        public SearchAction(boolean sameType) {
            this.sameType = sameType;
            if (sameType) {
                this.putValue("Name", I18n.tr((String)"Search Key/Value/Type", (Object[])new Object[0]));
                this.putValue("ShortDescription", I18n.tr((String)"Search with the key and value of the selected tag, restrict to type (i.e., node/way/relation)", (Object[])new Object[0]));
            } else {
                this.putValue("Name", I18n.tr((String)"Search Key/Value", (Object[])new Object[0]));
                this.putValue("ShortDescription", I18n.tr((String)"Search with the key and value of the selected tag", (Object[])new Object[0]));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OSMRecToggleDialog.this.tagTable.getSelectedRowCount() != 1) {
                return;
            }
            String key = OSMRecToggleDialog.this.tagData.getValueAt(OSMRecToggleDialog.this.tagTable.getSelectedRow(), 0).toString();
            Collection sel = Main.main.getInProgressSelection();
            if (sel.isEmpty()) {
                return;
            }
            String sep = "";
            StringBuilder s = new StringBuilder();
            for (OsmPrimitive p : sel) {
                String val = p.get(key);
                if (val == null) continue;
                String t = "";
                if (!this.sameType) {
                    t = "";
                } else if (p instanceof Node) {
                    t = "type:node ";
                } else if (p instanceof Way) {
                    t = "type:way ";
                } else if (p instanceof Relation) {
                    t = "type:relation ";
                }
                s.append(sep).append("(").append(t).append("\"").append(org.openstreetmap.josm.actions.search.SearchAction.escapeStringForSearch((String)key)).append("\"=\"").append(org.openstreetmap.josm.actions.search.SearchAction.escapeStringForSearch((String)val)).append("\")");
                sep = " OR ";
            }
            SearchAction.SearchSetting ss = new SearchAction.SearchSetting(s.toString(), SearchAction.SearchMode.replace, true, false, false);
            org.openstreetmap.josm.actions.search.SearchAction.searchWithoutHistory((SearchAction.SearchSetting)ss);
        }
    }

    class CopyAllKeyValueAction
    extends AbstractCopyAction {
        public CopyAllKeyValueAction() {
            this.putValue("Name", I18n.tr((String)"Copy all Keys/Values", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Copy the key and value of all the tags to clipboard", (Object[])new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive p, String key) {
            LinkedList<String> r = new LinkedList<String>();
            for (Map.Entry kv : p.getKeys().entrySet()) {
                r.add(new Tag((String)kv.getKey(), (String)kv.getValue()).toString());
            }
            return r;
        }
    }

    class CopyKeyValueAction
    extends AbstractCopyAction {
        public CopyKeyValueAction() {
            this.putValue("Name", I18n.tr((String)"Copy selected Key(s)/Value(s)", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Copy the key and value of the selected tag(s) to clipboard", (Object[])new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive p, String key) {
            String v = p.get(key);
            return v == null ? null : Collections.singleton(new Tag(key, v).toString());
        }
    }

    class CopyValueAction
    extends AbstractCopyAction {
        public CopyValueAction() {
            this.putValue("Name", I18n.tr((String)"Copy Value", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Copy the value of the selected tag to clipboard", (Object[])new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive p, String key) {
            String v = p.get(key);
            return v == null ? null : Collections.singleton(v);
        }
    }

    abstract class AbstractCopyAction
    extends AbstractAction {
        AbstractCopyAction() {
        }

        protected abstract Collection<String> getString(OsmPrimitive var1, String var2);

        @Override
        public void actionPerformed(ActionEvent ae) {
            int[] rows = OSMRecToggleDialog.this.tagTable.getSelectedRows();
            TreeSet<String> values = new TreeSet<String>();
            Collection sel = Main.main.getInProgressSelection();
            if (rows.length == 0 || sel.isEmpty()) {
                return;
            }
            for (int row : rows) {
                String key = OSMRecToggleDialog.this.tagData.getValueAt(row, 0).toString();
                if (sel.isEmpty()) {
                    return;
                }
                for (OsmPrimitive p : sel) {
                    Collection<String> s = this.getString(p, key);
                    if (s == null) continue;
                    values.addAll(s);
                }
            }
            if (!values.isEmpty()) {
                Utils.copyToClipboard((String)Utils.join((String)"\n", values));
            }
        }
    }

    class PasteValueAction
    extends AbstractAction {
        public PasteValueAction() {
            this.putValue("Name", I18n.tr((String)"Paste Value", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Paste the value of the selected tag from clipboard", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (OSMRecToggleDialog.this.tagTable.getSelectedRowCount() != 1) {
                return;
            }
            String key = OSMRecToggleDialog.this.tagData.getValueAt(OSMRecToggleDialog.this.tagTable.getSelectedRow(), 0).toString();
            Collection sel = Main.main.getInProgressSelection();
            String clipboard = Utils.getClipboardContent();
            if (sel.isEmpty() || clipboard == null) {
                return;
            }
            Main.main.undoRedo.add((Command)new ChangePropertyCommand(sel, key, Utils.strip((String)clipboard)));
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("Name", I18n.tr((String)"Go to OSM wiki for tag help (F1)", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Launch browser with wiki help for selected object", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"search"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String base = Main.pref.get("url.openstreetmap-wiki", "http://wiki.openstreetmap.org/wiki/");
                String lang = LanguageInfo.getWikiLanguagePrefix();
                final ArrayList<URI> uris = new ArrayList<URI>();
                if (OSMRecToggleDialog.this.tagTable.getSelectedRowCount() == 1) {
                    int row = OSMRecToggleDialog.this.tagTable.getSelectedRow();
                    String key = URLEncoder.encode(OSMRecToggleDialog.this.tagData.getValueAt(row, 0).toString(), "UTF-8");
                    Map m = (Map)OSMRecToggleDialog.this.tagData.getValueAt(row, 1);
                    String val = URLEncoder.encode((String)m.entrySet().iterator().next().getKey(), "UTF-8");
                    uris.add(new URI(String.format("%s%sTag:%s=%s", base, lang, key, val)));
                    uris.add(new URI(String.format("%sTag:%s=%s", base, key, val)));
                    uris.add(new URI(String.format("%s%sKey:%s", base, lang, key)));
                    uris.add(new URI(String.format("%sKey:%s", base, key)));
                    uris.add(new URI(String.format("%s%sMap_Features", base, lang)));
                    uris.add(new URI(String.format("%sMap_Features", base)));
                } else if (OSMRecToggleDialog.this.membershipTable.getSelectedRowCount() == 1) {
                    int row = OSMRecToggleDialog.this.membershipTable.getSelectedRow();
                    String type = ((Relation)OSMRecToggleDialog.this.membershipData.getValueAt(row, 0)).get("type");
                    if (type != null) {
                        type = URLEncoder.encode(type, "UTF-8");
                    }
                    if (type != null && !type.isEmpty()) {
                        uris.add(new URI(String.format("%s%sRelation:%s", base, lang, type)));
                        uris.add(new URI(String.format("%sRelation:%s", base, type)));
                    }
                    uris.add(new URI(String.format("%s%sRelations", base, lang)));
                    uris.add(new URI(String.format("%sRelations", base)));
                } else {
                    uris.add(new URI(String.format("%s%sMap_Features", base, lang)));
                    uris.add(new URI(String.format("%sMap_Features", base)));
                }
                Main.worker.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (URI u : uris) {
                                HttpURLConnection conn = Utils.openHttpConnection((URL)u.toURL());
                                conn.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                                if (conn.getResponseCode() != 200) {
                                    Main.info((String)"{0} does not exist", (Object[])new Object[]{u});
                                    conn.disconnect();
                                    continue;
                                }
                                int osize = conn.getContentLength();
                                if (osize > -1) {
                                    conn.disconnect();
                                    conn = Utils.openHttpConnection((URL)new URI(u.toString().replace("=", "%3D").replaceFirst("/wiki/", "/w/index.php?redirect=no&title=")).toURL());
                                    conn.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                                }
                                if (conn.getContentLength() != -1 && osize > -1 && Math.abs(conn.getContentLength() - osize) > 200) {
                                    Main.info((String)"{0} is a mediawiki redirect", (Object[])new Object[]{u});
                                    conn.disconnect();
                                    continue;
                                }
                                Main.info((String)"browsing to {0}", (Object[])new Object[]{u});
                                conn.disconnect();
                                OpenBrowser.displayUrl((String)u.toString());
                                break;
                            }
                        }
                        catch (Exception e) {
                            Main.error((Throwable)e);
                        }
                    }
                });
            }
            catch (UnsupportedEncodingException | URISyntaxException e1) {
                Main.error((Throwable)e1);
            }
        }
    }

    class EditActionTrain
    extends JosmAction
    implements ListSelectionListener {
        public EditActionTrain() {
            super(I18n.tr((String)"Train a Model", (Object[])new Object[0]), "dialogs/fix", I18n.tr((String)"Start the training engine!", (Object[])new Object[0]), Shortcut.registerShortcut((String)"properties:edit", (String)I18n.tr((String)"Edit Tags", (Object[])new Object[0]), (int)83, (int)5004), false);
            this.setEnabled(true);
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (OSMRecToggleDialog.this.tagTable.getSelectedRowCount() == 1) {
                int row = OSMRecToggleDialog.this.tagTable.getSelectedRow();
                OSMRecToggleDialog.this.editHelper.editTag(row, false);
            } else if (OSMRecToggleDialog.this.membershipTable.getSelectedRowCount() == 1) {
                int row = OSMRecToggleDialog.this.membershipTable.getSelectedRow();
                OSMRecToggleDialog.this.editHelper.editTag(row, false);
            } else {
                OSMRecToggleDialog.this.editHelper.editTag(1, false);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(true);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends JosmAction {
        public AddAction() {
            super(I18n.tr((String)"Add Recommendation", (Object[])new Object[0]), "dialogs/add", I18n.tr((String)"Add a recommended key/value pair to your object", (Object[])new Object[0]), Shortcut.registerShortcut((String)"properties:add", (String)I18n.tr((String)"Add Tag", (Object[])new Object[0]), (int)65, (int)5004), false);
        }

        public void actionPerformed(ActionEvent e) {
            OSMRecToggleDialog.this.editHelper.addTag();
            OSMRecToggleDialog.this.btnAdd.requestFocusInWindow();
        }
    }

    class DeleteAction
    extends JosmAction
    implements ListSelectionListener {
        static final String DELETE_FROM_RELATION_PREF = "delete_from_relation";

        public DeleteAction() {
            super(I18n.tr((String)"Delete", (Object[])new Object[0]), "dialogs/delete", I18n.tr((String)"Delete the selected key in all objects", (Object[])new Object[0]), Shortcut.registerShortcut((String)"properties:delete", (String)I18n.tr((String)"Delete Tags", (Object[])new Object[0]), (int)68, (int)5010), false);
            this.updateEnabledState();
        }

        protected void deleteTags(int[] rows) {
            HashMap<String, Object> tags = new HashMap<String, Object>(rows.length);
            int nextKeyIndex = rows[0];
            for (int row : rows) {
                String key = OSMRecToggleDialog.this.tagData.getValueAt(row, 0).toString();
                if (row == nextKeyIndex + 1) {
                    nextKeyIndex = row;
                }
                tags.put(key, null);
            }
            String nextKey = null;
            int rowCount = OSMRecToggleDialog.this.tagData.getRowCount();
            if (rowCount > rows.length) {
                nextKeyIndex = nextKeyIndex == rows[rows.length - 1] ? (nextKeyIndex + 1 < rowCount ? nextKeyIndex + 1 : rows[0] - 1) : ++nextKeyIndex;
                nextKey = (String)OSMRecToggleDialog.this.tagData.getValueAt(nextKeyIndex, 0);
            }
            Collection sel = Main.main.getInProgressSelection();
            Main.main.undoRedo.add((Command)new ChangePropertyCommand(sel, tags));
            OSMRecToggleDialog.this.membershipTable.clearSelection();
            if (nextKey != null) {
                OSMRecToggleDialog.this.tagTable.changeSelection(OSMRecToggleDialog.this.findRow(OSMRecToggleDialog.this.tagData, nextKey), 0, false, false);
            }
        }

        protected void deleteFromRelation(int row) {
            Relation cur = (Relation)OSMRecToggleDialog.this.membershipData.getValueAt(row, 0);
            Relation nextRelation = null;
            int rowCount = OSMRecToggleDialog.this.membershipTable.getRowCount();
            if (rowCount > 1) {
                nextRelation = (Relation)OSMRecToggleDialog.this.membershipData.getValueAt(row + 1 < rowCount ? row + 1 : row - 1, 0);
            }
            ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr((String)"Change relation", (Object[])new Object[0]), new String[]{I18n.tr((String)"Delete from relation", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
            ed.setButtonIcons(new String[]{"dialogs/delete.png", "cancel.png"});
            ed.setContent(I18n.tr((String)"Really delete selection from relation {0}?", (Object[])new Object[]{cur.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}));
            ed.toggleEnable(DELETE_FROM_RELATION_PREF);
            ed.showDialog();
            if (ed.getValue() != 1) {
                return;
            }
            Relation rel = new Relation(cur);
            for (OsmPrimitive primitive : Main.main.getInProgressSelection()) {
                rel.removeMembersFor(primitive);
            }
            Main.main.undoRedo.add((Command)new ChangeCommand((OsmPrimitive)cur, (OsmPrimitive)rel));
            OSMRecToggleDialog.this.tagTable.clearSelection();
            if (nextRelation != null) {
                OSMRecToggleDialog.this.membershipTable.changeSelection(OSMRecToggleDialog.this.findRow(OSMRecToggleDialog.this.membershipData, nextRelation), 0, false, false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (OSMRecToggleDialog.this.tagTable.getSelectedRowCount() > 0) {
                int[] rows = OSMRecToggleDialog.this.tagTable.getSelectedRows();
                this.deleteTags(rows);
            } else if (OSMRecToggleDialog.this.membershipTable.getSelectedRowCount() > 0) {
                ConditionalOptionPaneUtil.startBulkOperation((String)DELETE_FROM_RELATION_PREF);
                int[] rows = OSMRecToggleDialog.this.membershipTable.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    this.deleteFromRelation(rows[i]);
                }
                ConditionalOptionPaneUtil.endBulkOperation((String)DELETE_FROM_RELATION_PREF);
            }
        }

        protected final void updateEnabledState() {
            this.setEnabled(OSMRecToggleDialog.this.tagTable != null && OSMRecToggleDialog.this.tagTable.getSelectedRowCount() >= 1 || OSMRecToggleDialog.this.membershipTable != null && OSMRecToggleDialog.this.membershipTable.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    public static class ReadOnlyTableModel
    extends DefaultTableModel {
        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }
    }

    static class MemberInfo {
        private List<RelationMember> role = new ArrayList<RelationMember>();
        private Set<OsmPrimitive> members = new HashSet<OsmPrimitive>();
        private List<Integer> position = new ArrayList<Integer>();
        private Iterable<OsmPrimitive> selection;
        private String positionString = null;
        private String roleString = null;

        MemberInfo(Iterable<OsmPrimitive> selection) {
            this.selection = selection;
        }

        void add(RelationMember r, Integer p) {
            this.role.add(r);
            this.members.add(r.getMember());
            this.position.add(p);
        }

        String getPositionString() {
            if (this.positionString == null) {
                this.positionString = Utils.getPositionListString(this.position);
                if (Utils.exists(this.selection, (Predicate)Predicates.not((Predicate)Predicates.inCollection(this.members)))) {
                    this.positionString = this.positionString + ",\u2717";
                }
                this.members = null;
                this.position = null;
                this.selection = null;
            }
            return Utils.shortenString((String)this.positionString, (int)20);
        }

        String getRoleString() {
            if (this.roleString == null) {
                for (RelationMember r : this.role) {
                    if (this.roleString == null) {
                        this.roleString = r.getRole();
                        continue;
                    }
                    if (this.roleString.equals(r.getRole())) continue;
                    this.roleString = I18n.tr((String)"<different>", (Object[])new Object[0]);
                    break;
                }
            }
            return this.roleString;
        }

        public String toString() {
            return "MemberInfo{roles='" + this.roleString + '\'' + ", positions='" + this.positionString + '\'' + '}';
        }
    }

    public class MouseClickWatch
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                if (e.getSource() == OSMRecToggleDialog.this.tagTable) {
                    OSMRecToggleDialog.this.membershipTable.clearSelection();
                } else if (e.getSource() == OSMRecToggleDialog.this.membershipTable) {
                    OSMRecToggleDialog.this.tagTable.clearSelection();
                }
            } else if (e.getSource() == OSMRecToggleDialog.this.tagTable) {
                int row = OSMRecToggleDialog.this.tagTable.rowAtPoint(e.getPoint());
                if (row > -1) {
                    boolean focusOnKey = OSMRecToggleDialog.this.tagTable.columnAtPoint(e.getPoint()) == 0;
                    OSMRecToggleDialog.this.editHelper.editTag(row, focusOnKey);
                } else {
                    OSMRecToggleDialog.this.editHelper.addTag();
                    OSMRecToggleDialog.this.btnAdd.requestFocusInWindow();
                }
            } else if (e.getSource() == OSMRecToggleDialog.this.membershipTable) {
                int row = OSMRecToggleDialog.this.membershipTable.rowAtPoint(e.getPoint());
                if (row > -1) {
                    OSMRecToggleDialog.this.editMembership(row);
                }
            } else {
                OSMRecToggleDialog.this.editHelper.addTag();
                OSMRecToggleDialog.this.btnAdd.requestFocusInWindow();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == OSMRecToggleDialog.this.tagTable) {
                OSMRecToggleDialog.this.membershipTable.clearSelection();
            } else if (e.getSource() == OSMRecToggleDialog.this.membershipTable) {
                OSMRecToggleDialog.this.tagTable.clearSelection();
            }
        }
    }
}

