/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.core;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.FeatureNode;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Model;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SolverType;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.openstreetmap.josm.plugins.container.OSMRelation;
import org.openstreetmap.josm.plugins.container.OSMWay;
import org.openstreetmap.josm.plugins.extractor.Analyzer;
import org.openstreetmap.josm.plugins.extractor.LanguageDetector;
import org.openstreetmap.josm.plugins.features.ClassFeatures;
import org.openstreetmap.josm.plugins.features.GeometryFeatures;
import org.openstreetmap.josm.plugins.features.OSMClassification;
import org.openstreetmap.josm.plugins.features.TextualFeatures;
import org.openstreetmap.josm.plugins.parsers.Mapper;
import org.openstreetmap.josm.plugins.parsers.OSMParser;
import org.openstreetmap.josm.plugins.parsers.Ontology;
import org.openstreetmap.josm.plugins.parsers.TextualStatistics;

public class TrainWorker
extends SwingWorker<Void, Void>
implements ActionListener {
    private final String inputFilePath;
    private static Map<String, String> mappings;
    private static Map<String, Integer> mapperWithIDs;
    private static List<OSMWay> wayList;
    private static List<OSMRelation> relationList;
    private static Map<String, List<String>> indirectClasses;
    private static Map<String, Integer> indirectClassesWithIDs;
    private static List<String> namesList;
    private int numberOfTrainingInstances;
    private final String modelDirectoryPath;
    private final File modelDirectory;
    private static double score1;
    private static double score5;
    private static double score10;
    private static double foldScore1;
    private static double foldScore5;
    private static double foldScore10;
    private static double bestScore;
    private int trainProgress = 0;
    private final boolean validateFlag;
    private final double cParameterFromUser;
    private double bestConfParam;
    private final int topK;
    private final int frequency;
    private final boolean topKIsSelected;
    private String textualListFilePath;
    private static final boolean USE_CLASS_FEATURES = false;
    private static final boolean USE_RELATION_FEATURES = false;
    private static final boolean USE_TEXTUAL_FEATURES = true;
    private static int numberOfFeatures;
    private static LanguageDetector languageDetector;

    public TrainWorker(String inputFilePath, boolean validateFlag, double cParameterFromUser, int topK, int frequency, boolean topKIsSelected, LanguageDetector languageDetector) {
        TrainWorker.languageDetector = languageDetector;
        this.inputFilePath = inputFilePath;
        this.validateFlag = validateFlag;
        this.cParameterFromUser = cParameterFromUser;
        this.topK = topK;
        this.frequency = frequency;
        this.topKIsSelected = topKIsSelected;
        System.out.println("find parent directory, create osmrec dir for models: " + new File(inputFilePath).getParentFile());
        this.modelDirectoryPath = new File(inputFilePath).getParentFile() + "/OSMRec_models";
        this.modelDirectory = new File(this.modelDirectoryPath);
        if (!this.modelDirectory.exists()) {
            this.modelDirectory.mkdir();
            System.out.println("model directory created!");
        } else {
            System.out.println("directory already exists!");
        }
    }

    @Override
    public Void doInBackground() throws Exception {
        this.extractTextualList();
        this.parseFiles();
        if (this.validateFlag) {
            this.validateLoop();
            System.out.println("Training model with the best c: " + this.bestConfParam);
            TrainWorker.clearDataset();
            this.trainModel(this.bestConfParam);
            TrainWorker.clearDataset();
            this.trainModelWithClasses(this.bestConfParam);
        } else {
            TrainWorker.clearDataset();
            this.trainModel(this.cParameterFromUser);
            TrainWorker.clearDataset();
            this.trainModelWithClasses(this.cParameterFromUser);
            System.out.println("done.");
        }
        return null;
    }

    private void extractTextualList() {
        System.out.println("Running analysis..");
        Analyzer anal = new Analyzer(this.inputFilePath, languageDetector);
        anal.runAnalysis();
        this.textualListFilePath = this.modelDirectory.getAbsolutePath() + "/textualList.txt";
        File textualFile = new File(this.textualListFilePath);
        if (textualFile.exists()) {
            textualFile.delete();
        }
        try {
            textualFile.createNewFile();
        }
        catch (IOException ex) {
            Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
        }
        List<Map.Entry<String, Integer>> textualList = this.topKIsSelected ? anal.getTopKMostFrequent(this.topK) : anal.getWithFrequency(this.frequency);
        TrainWorker.writeTextualListToFile(this.textualListFilePath, textualList);
        System.out.println("textual list saved at location:\n" + this.textualListFilePath);
        numberOfFeatures = 105 + textualList.size();
    }

    private void parseFiles() {
        InputStream tagsToClassesMapping = TrainWorker.class.getResourceAsStream("/resources/files/Map");
        Mapper mapper = new Mapper();
        try {
            mapper.parseFile(tagsToClassesMapping);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Mapper.class.getName()).log(Level.SEVERE, null, ex);
        }
        mappings = mapper.getMappings();
        mapperWithIDs = mapper.getMappingsWithIDs();
        InputStream ontologyStream = TrainWorker.class.getResourceAsStream("/resources/files/owl.xml");
        Ontology ontology = new Ontology(ontologyStream);
        ontology.parseOntology();
        System.out.println("ontology parsed ");
        indirectClasses = ontology.getIndirectClasses();
        indirectClassesWithIDs = ontology.getIndirectClassesIDs();
        FileInputStream textualFileStream = null;
        try {
            textualFileStream = new FileInputStream(new File(this.textualListFilePath));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.readTextualFromDefaultList(textualFileStream);
        OSMParser osmParser = new OSMParser(this.inputFilePath);
        osmParser.parseDocument();
        relationList = osmParser.getRelationList();
        wayList = osmParser.getWayList();
        this.numberOfTrainingInstances = osmParser.getWayList().size();
        System.out.println("number of instances: " + this.numberOfTrainingInstances);
        System.out.println("end of parsing files.");
    }

    public void validateLoop() {
        Double[] confParams = new Double[]{Math.pow(2.0, -3.0), Math.pow(2.0, 1.0), Math.pow(2.0, -10.0), Math.pow(2.0, -10.0), Math.pow(2.0, -5.0), Math.pow(2.0, -3.0)};
        double bestC = Math.pow(2.0, -10.0);
        for (Double param : confParams) {
            foldScore1 = 0.0;
            foldScore5 = 0.0;
            foldScore10 = 0.0;
            System.out.println("\n\n\nrunning for C = " + param);
            TrainWorker.clearDataset();
            System.out.println("fold1");
            this.crossValidateFold(0, 4, 4, 5, false, param);
            this.setProgress(4 * (5 * this.trainProgress++ / confParams.length));
            foldScore1 += score1;
            foldScore5 += score5;
            foldScore10 += score10;
            TrainWorker.clearDataset();
            System.out.println("fold2");
            this.crossValidateFold(1, 5, 0, 1, false, param);
            this.setProgress(4 * (5 * this.trainProgress++ / confParams.length));
            foldScore1 += score1;
            foldScore5 += score5;
            foldScore10 += score10;
            TrainWorker.clearDataset();
            System.out.println("fold3");
            this.crossValidateFold(0, 5, 1, 2, true, param);
            this.setProgress(4 * (5 * this.trainProgress++ / confParams.length));
            foldScore1 += score1;
            foldScore5 += score5;
            foldScore10 += score10;
            TrainWorker.clearDataset();
            System.out.println("fold4");
            this.crossValidateFold(0, 5, 2, 3, true, param);
            this.setProgress(4 * (5 * this.trainProgress++ / confParams.length));
            foldScore1 += score1;
            foldScore5 += score5;
            foldScore10 += score10;
            TrainWorker.clearDataset();
            System.out.println("fold5");
            this.crossValidateFold(0, 5, 3, 4, true, param);
            this.setProgress(4 * (5 * this.trainProgress++ / confParams.length));
            System.out.println("\n\nC=" + param + ", average score 1-5-10: " + (foldScore1 += score1) / 5.0 + " " + (foldScore5 += score5) / 5.0 + " " + (foldScore10 += score10) / 5.0);
            if (!(bestScore < foldScore1)) continue;
            bestScore = foldScore1;
            bestC = param;
        }
        System.out.println(4 * (5 * this.trainProgress++ / confParams.length));
        this.bestConfParam = bestC;
        System.out.println("best c param= " + bestC + ", score: " + bestScore / 5.0);
    }

    public void crossValidateFold(int a, int b, int c, int d, boolean skip, double param) {
        double precision10;
        double precision5;
        double precision1;
        System.out.println("Starting cross validation");
        int testSize = wayList.size() / 5;
        ArrayList<OSMWay> trainList = new ArrayList<OSMWay>();
        for (int g = a * testSize; g < b * testSize; ++g) {
            if (skip && g == c * testSize) {
                g = (c + 1) * testSize;
            }
            trainList.add(wayList.get(g));
        }
        int wayListSizeWithoutUnclassified = trainList.size();
        int u = 0;
        System.out.println("trainList size: " + wayListSizeWithoutUnclassified);
        int sizeToBeAddedToArray = 0;
        int lalala = 0;
        for (OSMWay way : trainList) {
            OSMClassification classifyInstances = new OSMClassification();
            classifyInstances.calculateClasses(way, mappings, mapperWithIDs, indirectClasses, indirectClassesWithIDs);
            if (way.getClassIDs().isEmpty()) {
                --wayListSizeWithoutUnclassified;
                ++u;
                continue;
            }
            sizeToBeAddedToArray = sizeToBeAddedToArray + way.getClassIDs().size() - 1;
        }
        double C2 = param;
        double eps = 0.001;
        double[] GROUPS_ARRAY2 = new double[wayListSizeWithoutUnclassified + sizeToBeAddedToArray];
        FeatureNode[][] trainingSetWithUnknown2 = new FeatureNode[wayListSizeWithoutUnclassified + sizeToBeAddedToArray][numberOfFeatures];
        int k = 0;
        for (OSMWay way : trainList) {
            int id = 1;
            GeometryFeatures geometryFeatures = new GeometryFeatures(id);
            geometryFeatures.createGeometryFeatures(way);
            id = geometryFeatures.getLastID();
            id = geometryFeatures.getLastID();
            TextualFeatures textualFeatures = new TextualFeatures(id, namesList, languageDetector);
            textualFeatures.createTextualFeatures(way);
            List<FeatureNode> featureNodeList = way.getFeatureNodeList();
            FeatureNode[] featureNodeArray = new FeatureNode[featureNodeList.size()];
            if (way.getClassIDs().isEmpty()) continue;
            int i = 0;
            Iterator<Object> i$ = featureNodeList.iterator();
            while (i$.hasNext()) {
                FeatureNode featureNode;
                featureNodeArray[i] = featureNode = i$.next();
                ++i;
            }
            i$ = way.getClassIDs().iterator();
            while (i$.hasNext()) {
                int classID = (Integer)i$.next();
                ++lalala;
                trainingSetWithUnknown2[k] = featureNodeArray;
                GROUPS_ARRAY2[k] = classID;
                ++k;
            }
        }
        Problem problem = new Problem();
        problem.l = wayListSizeWithoutUnclassified + sizeToBeAddedToArray;
        problem.n = numberOfFeatures;
        problem.x = trainingSetWithUnknown2;
        problem.y = GROUPS_ARRAY2;
        SolverType solver2 = SolverType.getById(2);
        Parameter parameter = new Parameter(solver2, C2, eps);
        long start = System.nanoTime();
        System.out.println("training...");
        PrintStream original = System.out;
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int arg0) throws IOException {
            }
        }));
        Model model = Linear.train(problem, parameter);
        long end = System.nanoTime();
        Long elapsedTime = end - start;
        System.setOut(original);
        System.out.println("training process completed in: " + TimeUnit.NANOSECONDS.toSeconds(elapsedTime) + " seconds.");
        File modelFile = new File(this.modelDirectory.getAbsolutePath() + "/model_geometries_textual_c=" + param);
        if (modelFile.exists()) {
            modelFile.delete();
        }
        try {
            model.save(modelFile);
            System.out.println("model saved at: " + modelFile);
        }
        catch (IOException ex) {
            Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
        }
        ArrayList<OSMWay> testList = new ArrayList<OSMWay>();
        for (int g = c * testSize; g < d * testSize; ++g) {
            testList.add(wayList.get(g));
        }
        System.out.println("testList size: " + testList.size());
        int succededInstances = 0;
        int succededInstances5 = 0;
        int succededInstances10 = 0;
        try {
            model = Model.load(modelFile);
        }
        catch (IOException ex) {
            Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
        }
        int modelLabelSize = model.getLabels().length;
        int[] labels = model.getLabels();
        HashMap<Integer, Integer> mapLabelsToIDs = new HashMap<Integer, Integer>();
        for (int h = 0; h < model.getLabels().length; ++h) {
            mapLabelsToIDs.put(labels[h], h);
        }
        int wayListSizeWithoutUnclassified2 = testList.size();
        for (OSMWay way : testList) {
            OSMClassification classifyInstances = new OSMClassification();
            classifyInstances.calculateClasses(way, mappings, mapperWithIDs, indirectClasses, indirectClassesWithIDs);
            if (!way.getClassIDs().isEmpty()) continue;
            --wayListSizeWithoutUnclassified2;
        }
        for (OSMWay way : testList) {
            int id = 1;
            GeometryFeatures geometryFeatures = new GeometryFeatures(id);
            geometryFeatures.createGeometryFeatures(way);
            id = geometryFeatures.getLastID();
            id = geometryFeatures.getLastID();
            TextualFeatures textualFeatures = new TextualFeatures(id, namesList, languageDetector);
            textualFeatures.createTextualFeatures(way);
            List<FeatureNode> featureNodeList = way.getFeatureNodeList();
            Feature[] featureNodeArray = new FeatureNode[featureNodeList.size()];
            int i = 0;
            Iterator<FeatureNode> i$ = featureNodeList.iterator();
            while (i$.hasNext()) {
                FeatureNode featureNode;
                featureNodeArray[i] = featureNode = i$.next();
                ++i;
            }
            Feature[] testInstance2 = featureNodeArray;
            double[] scores = new double[modelLabelSize];
            Linear.predictValues(model, testInstance2, scores);
            HashMap<Double, Integer> scoresValues = new HashMap<Double, Integer>();
            for (int h = 0; h < scores.length; ++h) {
                scoresValues.put(scores[h], h);
            }
            Arrays.sort(scores);
            if (way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 1])])) {
                ++succededInstances;
            }
            if (way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 1])]) || way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 2])]) || way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 3])]) || way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 4])]) || way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 5])])) {
                ++succededInstances5;
            }
            if (!way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 1])]) && !way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 2])]) && !way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 3])]) && !way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 4])]) && !way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 5])]) && !way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 6])]) && !way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 7])]) && !way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 8])]) && !way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 9])]) && !way.getClassIDs().contains(labels[(Integer)scoresValues.get(scores[scores.length - 10])])) continue;
            ++succededInstances10;
        }
        System.out.println("Succeeded " + succededInstances + " of " + testList.size() + " total (1 class prediction)");
        score1 = precision1 = (double)succededInstances / (double)wayListSizeWithoutUnclassified2;
        System.out.println(precision1);
        System.out.println("Succeeded " + succededInstances5 + " of " + testList.size() + " total (5 class prediction)");
        score5 = precision5 = (double)succededInstances5 / (double)wayListSizeWithoutUnclassified2;
        System.out.println(precision5);
        System.out.println("Succeeded " + succededInstances10 + " of " + testList.size() + " total (10 class prediction)");
        score10 = precision10 = (double)succededInstances10 / (double)wayListSizeWithoutUnclassified2;
        System.out.println(precision10);
    }

    private void trainModel(double param) {
        int wayListSizeWithoutUnclassified = wayList.size();
        int u = 0;
        System.out.println("trainList size: " + wayListSizeWithoutUnclassified);
        int sizeToBeAddedToArray = 0;
        int lalala = 0;
        if (this.trainProgress > 11) {
            this.setProgress(this.trainProgress - 10);
        } else {
            this.setProgress(this.trainProgress + 10);
        }
        for (OSMWay way : wayList) {
            OSMClassification classifyInstances = new OSMClassification();
            classifyInstances.calculateClasses(way, mappings, mapperWithIDs, indirectClasses, indirectClassesWithIDs);
            if (way.getClassIDs().isEmpty()) {
                --wayListSizeWithoutUnclassified;
                ++u;
                continue;
            }
            sizeToBeAddedToArray = sizeToBeAddedToArray + way.getClassIDs().size() - 1;
        }
        double C2 = param;
        double eps = 0.001;
        double[] GROUPS_ARRAY2 = new double[wayListSizeWithoutUnclassified + sizeToBeAddedToArray];
        FeatureNode[][] trainingSetWithUnknown2 = new FeatureNode[wayListSizeWithoutUnclassified + sizeToBeAddedToArray][numberOfFeatures];
        int k = 0;
        for (OSMWay way : wayList) {
            int id = 1;
            GeometryFeatures geometryFeatures = new GeometryFeatures(id);
            geometryFeatures.createGeometryFeatures(way);
            id = geometryFeatures.getLastID();
            id = geometryFeatures.getLastID();
            TextualFeatures textualFeatures = new TextualFeatures(id, namesList, languageDetector);
            textualFeatures.createTextualFeatures(way);
            List<FeatureNode> featureNodeList = way.getFeatureNodeList();
            FeatureNode[] featureNodeArray = new FeatureNode[featureNodeList.size()];
            if (way.getClassIDs().isEmpty()) continue;
            int i = 0;
            Iterator<Object> i$ = featureNodeList.iterator();
            while (i$.hasNext()) {
                FeatureNode featureNode;
                featureNodeArray[i] = featureNode = i$.next();
                ++i;
            }
            i$ = way.getClassIDs().iterator();
            while (i$.hasNext()) {
                int classID = (Integer)i$.next();
                ++lalala;
                trainingSetWithUnknown2[k] = featureNodeArray;
                GROUPS_ARRAY2[k] = classID;
                ++k;
            }
        }
        Problem problem = new Problem();
        problem.l = wayListSizeWithoutUnclassified + sizeToBeAddedToArray;
        problem.n = numberOfFeatures;
        problem.x = trainingSetWithUnknown2;
        problem.y = GROUPS_ARRAY2;
        SolverType solver2 = SolverType.getById(2);
        Parameter parameter = new Parameter(solver2, C2, eps);
        long start = System.nanoTime();
        System.out.println("training...");
        PrintStream original = System.out;
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int arg0) throws IOException {
            }
        }));
        Model model = Linear.train(problem, parameter);
        long end = System.nanoTime();
        Long elapsedTime = end - start;
        System.setOut(original);
        System.out.println("training process completed in: " + TimeUnit.NANOSECONDS.toSeconds(elapsedTime) + " seconds.");
        File modelFile = new File(this.modelDirectory.getAbsolutePath() + "/best_model");
        if (modelFile.exists()) {
            modelFile.delete();
        }
        try {
            model.save(modelFile);
            System.out.println("best model saved at: " + modelFile);
        }
        catch (IOException ex) {
            Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void trainModelWithClasses(double param) {
        int wayListSizeWithoutUnclassified = wayList.size();
        int u = 0;
        System.out.println("trainList size: " + wayListSizeWithoutUnclassified);
        int sizeToBeAddedToArray = 0;
        for (OSMWay way : wayList) {
            OSMClassification classifyInstances = new OSMClassification();
            classifyInstances.calculateClasses(way, mappings, mapperWithIDs, indirectClasses, indirectClassesWithIDs);
            if (way.getClassIDs().isEmpty()) {
                --wayListSizeWithoutUnclassified;
                ++u;
                continue;
            }
            sizeToBeAddedToArray = sizeToBeAddedToArray + way.getClassIDs().size() - 1;
        }
        double C2 = param;
        double eps = 0.001;
        double[] GROUPS_ARRAY2 = new double[wayListSizeWithoutUnclassified + sizeToBeAddedToArray];
        FeatureNode[][] trainingSetWithUnknown2 = new FeatureNode[wayListSizeWithoutUnclassified + sizeToBeAddedToArray][numberOfFeatures + 1422];
        int k = 0;
        for (OSMWay way : wayList) {
            ClassFeatures class_vector = new ClassFeatures();
            class_vector.createClassFeatures(way, mappings, mapperWithIDs, indirectClasses, indirectClassesWithIDs);
            int id = 1422;
            GeometryFeatures geometryFeatures = new GeometryFeatures(id);
            geometryFeatures.createGeometryFeatures(way);
            id = geometryFeatures.getLastID();
            id = geometryFeatures.getLastID();
            TextualFeatures textualFeatures = new TextualFeatures(id, namesList, languageDetector);
            textualFeatures.createTextualFeatures(way);
            List<FeatureNode> featureNodeList = way.getFeatureNodeList();
            FeatureNode[] featureNodeArray = new FeatureNode[featureNodeList.size()];
            if (way.getClassIDs().isEmpty()) continue;
            int i = 0;
            Iterator<Object> i$ = featureNodeList.iterator();
            while (i$.hasNext()) {
                FeatureNode featureNode;
                featureNodeArray[i] = featureNode = i$.next();
                ++i;
            }
            i$ = way.getClassIDs().iterator();
            while (i$.hasNext()) {
                int classID = (Integer)i$.next();
                trainingSetWithUnknown2[k] = featureNodeArray;
                GROUPS_ARRAY2[k] = classID;
                ++k;
            }
        }
        Problem problem = new Problem();
        problem.l = wayListSizeWithoutUnclassified + sizeToBeAddedToArray;
        problem.n = numberOfFeatures + 1422;
        problem.x = trainingSetWithUnknown2;
        problem.y = GROUPS_ARRAY2;
        SolverType solver2 = SolverType.getById(2);
        Parameter parameter = new Parameter(solver2, C2, eps);
        long start = System.nanoTime();
        System.out.println("training...");
        PrintStream original = System.out;
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int arg0) throws IOException {
            }
        }));
        Model model = Linear.train(problem, parameter);
        long end = System.nanoTime();
        Long elapsedTime = end - start;
        System.setOut(original);
        System.out.println("training process completed in: " + TimeUnit.NANOSECONDS.toSeconds(elapsedTime) + " seconds.");
        File modelFile = new File(this.modelDirectory.getAbsolutePath() + "/model_with_classes");
        if (modelFile.exists()) {
            modelFile.delete();
        }
        try {
            model.save(modelFile);
            System.out.println("model with classes saved at: " + modelFile);
        }
        catch (IOException ex) {
            Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void clearDataset() {
        for (OSMWay way : wayList) {
            way.getFeatureNodeList().clear();
        }
    }

    private void readTextualFromDefaultList(InputStream textualFileStream) {
        TextualStatistics textualStatistics = new TextualStatistics();
        textualStatistics.parseTextualList(textualFileStream);
        namesList = textualStatistics.getTextualList();
    }

    @Override
    protected void done() {
        try {
            System.out.println("Training process complete! - > " + this.get());
            this.setProgress(100);
        }
        catch (InterruptedException | ExecutionException ignore) {
            System.out.println("Exception: " + ignore);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    }

    private static void writeTextualListToFile(String filePath, List<Map.Entry<String, Integer>> textualList) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, true), "UTF-8"));){
            for (Map.Entry<String, Integer> entry : textualList) {
                writer.write(entry.getKey());
                writer.newLine();
            }
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        score1 = 0.0;
        score5 = 0.0;
        score10 = 0.0;
        foldScore1 = 0.0;
        foldScore5 = 0.0;
        foldScore10 = 0.0;
        bestScore = 0.0;
    }
}

