/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.features;

import com.cybozu.labs.langdetect.LangDetectException;
import de.bwaldvogel.liblinear.FeatureNode;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.util.Version;
import org.openstreetmap.josm.plugins.container.OSMWay;
import org.openstreetmap.josm.plugins.extractor.LanguageDetector;

public class TextualFeatures {
    private int id;
    private int numberOfFeatures;
    private final List<String> textualList;
    private static String language;
    private final QueryParser greekParser;
    private final QueryParser englishParser;
    private final LanguageDetector languageDetector;

    public TextualFeatures(int id, List<String> textualList, LanguageDetector languageDetector) {
        this.id = id;
        this.textualList = textualList;
        this.languageDetector = languageDetector;
        this.numberOfFeatures = textualList.size() + id;
        GreekAnalyzer greekAnalyzer = new GreekAnalyzer(Version.LUCENE_36);
        this.greekParser = new QueryParser(Version.LUCENE_36, "", greekAnalyzer);
        EnglishAnalyzer englishAnalyzer = new EnglishAnalyzer(Version.LUCENE_36);
        this.englishParser = new QueryParser(Version.LUCENE_36, "", englishAnalyzer);
    }

    public void createTextualFeatures(OSMWay wayNode) {
        TreeMap<Integer, String> idWords = new TreeMap<Integer, String>();
        Map<String, String> tags = wayNode.getTagKeyValue();
        if (tags.keySet().contains("name")) {
            String nameTag = tags.get("name");
            String[] nameTagSplitList = nameTag.split("\\s");
            String lang = "";
            try {
                lang = this.detectLanguage(nameTag);
            }
            catch (LangDetectException ex) {
                Logger.getLogger(TextualFeatures.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (String split : nameTagSplitList) {
                try {
                    split = split.replaceAll("[-+.^:,?;'{}\"!()\\[\\]]", "");
                    split = lang.equals("el") ? this.stemGreek(split) : this.stemEnglish(split);
                    if (!this.textualList.contains(split)) continue;
                    int currentID = this.textualList.indexOf(split) + this.id;
                    idWords.put(currentID, split);
                }
                catch (ParseException ex) {
                    Logger.getLogger(TextualFeatures.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            for (Integer wordID : idWords.keySet()) {
                wayNode.getFeatureNodeList().add(new FeatureNode(wordID, 1.0));
            }
        }
    }

    public int getLastID() {
        return this.numberOfFeatures;
    }

    private String detectLanguage(String nameTag) throws LangDetectException {
        if (!nameTag.isEmpty()) {
            language = this.languageDetector.detect(nameTag);
            return language;
        }
        return "no_lang";
    }

    private String stemGreek(String word) throws ParseException {
        if (word.isEmpty()) {
            return word;
        }
        String stemmedWord = this.greekParser.parse(word).toString();
        return stemmedWord;
    }

    private String stemEnglish(String word) throws ParseException {
        if (word.isEmpty()) {
            return word;
        }
        String stemmedWord = this.englishParser.parse(word).toString();
        return stemmedWord;
    }
}

