/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.IntAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class DumbMethods
extends OpcodeStackDetector {
    private final SubDetector[] subDetectors = new SubDetector[]{new VacuousComparisonSubDetector(), new RangeCheckSubDetector(), new BadCastInEqualsSubDetector(), new FutilePoolSizeSubDetector(), new UrlCollectionSubDetector(), new RandomOnceSubDetector(), new NullMethodsSubDetector(), new InvalidMinMaxSubDetector()};
    private static final ObjectType CONDITION_TYPE = ObjectTypeFactory.getInstance("java.util.concurrent.locks.Condition");
    private final BugReporter bugReporter;
    private boolean sawCurrentTimeMillis;
    private BugInstance gcInvocationBugReport;
    private int gcInvocationPC;
    private CodeException[] exceptionTable;
    private String primitiveObjCtorSeen;
    private boolean ctorSeen;
    private boolean prevOpcodeWasReadLine;
    private int prevOpcode;
    private boolean isPublicStaticVoidMain;
    private int sawCheckForNonNegativeSignedByte;
    private int sinceBufferedInputStreamReady;
    private int randomNextIntState;
    private boolean checkForBitIorofSignedByte;
    private static final int OOM_CATCH_LEN = 20;
    private final boolean testingEnabled;
    private final BugAccumulator accumulator;
    private final BugAccumulator absoluteValueAccumulator;
    private static final int MICROS_PER_DAY_OVERFLOWED_AS_INT = 500654080;
    boolean isSynthetic;
    int opcodesSincePendingAbsoluteValueBug;
    BugInstance pendingAbsoluteValueBug;
    SourceLineAnnotation pendingAbsoluteValueBugSourceLine;
    boolean sawLoadOfMinValue = false;
    MethodDescriptor previousMethodCall = null;

    static int saturatingIncrement(int value) {
        if (value == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return value + 1;
    }

    public DumbMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.accumulator = new BugAccumulator(bugReporter);
        this.absoluteValueAccumulator = new BugAccumulator(bugReporter);
        this.testingEnabled = SystemProperties.getBoolean("report_TESTING_pattern_in_standard_detectors");
    }

    @Override
    public void visit(JavaClass obj) {
        String superclassName = obj.getSuperclassName();
        this.isSynthetic = "java.rmi.server.RemoteStub".equals(superclassName);
        Attribute[] attributes = obj.getAttributes();
        if (attributes != null) {
            for (Attribute a : attributes) {
                if (!(a instanceof Synthetic)) continue;
                this.isSynthetic = true;
            }
        }
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.accumulator.reportAccumulatedBugs();
    }

    public static boolean isTestMethod(Method method) {
        return method.getName().startsWith("test");
    }

    @Override
    public void visit(Field field) {
        ConstantValue value = field.getConstantValue();
        if (value == null) {
            return;
        }
        Constant c = this.getConstantPool().getConstant(value.getConstantValueIndex());
        if (this.testingEnabled && c instanceof ConstantLong && ((ConstantLong)c).getBytes() == 500654080L) {
            this.bugReporter.reportBug(new BugInstance(this, "TESTING", 1).addClass(this).addField(this).addString("Did you mean MICROS_PER_DAY").addInt(500654080).describe("INT_VALUE"));
        }
    }

    @Override
    public void visit(Method method) {
        String cName = this.getDottedClassName();
        for (SubDetector subDetector : this.subDetectors) {
            subDetector.initMethod(method);
        }
        this.isPublicStaticVoidMain = method.isPublic() && method.isStatic() && "main".equals(this.getMethodName()) || cName.toLowerCase().indexOf("benchmark") >= 0;
        this.prevOpcodeWasReadLine = false;
        Code code = method.getCode();
        if (code != null) {
            this.exceptionTable = code.getExceptionTable();
        }
        if (this.exceptionTable == null) {
            this.exceptionTable = new CodeException[0];
        }
        this.primitiveObjCtorSeen = null;
        this.ctorSeen = false;
        this.randomNextIntState = 0;
        this.checkForBitIorofSignedByte = false;
        this.sinceBufferedInputStreamReady = 100000;
        this.sawCheckForNonNegativeSignedByte = -1000;
        this.sawLoadOfMinValue = false;
        this.previousMethodCall = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item item0;
        if (this.isMethodCall()) {
            MethodDescriptor called = this.getMethodDescriptorOperand();
            if (this.previousMethodCall != null && !this.stack.isJumpTarget(this.getPC())) {
                BugInstance bug;
                MethodAnnotation preferred;
                if ("toString".equals(called.getName()) && "java/lang/Integer".equals(called.getClassDescriptor().getClassName()) && "valueOf".equals(this.previousMethodCall.getName()) && "(I)Ljava/lang/Integer;".equals(this.previousMethodCall.getSignature())) {
                    preferred = new MethodAnnotation("java.lang.Integer", "toString", "(I)Ljava/lang/String;", true);
                    bug = new BugInstance(this, "DM_BOXED_PRIMITIVE_TOSTRING", 1).addClassAndMethod(this).addCalledMethod(this).addMethod(preferred).describe("SHOULD_CALL");
                    this.accumulator.accumulateBug(bug, this);
                } else if ("intValue".equals(called.getName()) && "java/lang/Integer".equals(called.getClassDescriptor().getClassName()) && "java/lang/Integer".equals(this.previousMethodCall.getSlashedClassName()) && ("<init>".equals(this.previousMethodCall.getName()) && "(Ljava/lang/String;)V".equals(this.previousMethodCall.getSignature()) || "valueOf".equals(this.previousMethodCall.getName()) && "(Ljava/lang/String;)Ljava/lang/Integer;".equals(this.previousMethodCall.getSignature()))) {
                    preferred = new MethodAnnotation("java.lang.Integer", "parseInt", "(Ljava/lang/String;)I", true);
                    bug = new BugInstance(this, "DM_BOXED_PRIMITIVE_FOR_PARSING", 1).addClassAndMethod(this).addCalledMethod(this).addMethod(preferred).describe("SHOULD_CALL");
                    this.accumulator.accumulateBug(bug, this);
                } else if ("longValue".equals(called.getName()) && "java/lang/Long".equals(called.getClassDescriptor().getClassName()) && "java/lang/Long".equals(this.previousMethodCall.getSlashedClassName()) && ("<init>".equals(this.previousMethodCall.getName()) && "(Ljava/lang/String;)V".equals(this.previousMethodCall.getSignature()) || "valueOf".equals(this.previousMethodCall.getName()) && "(Ljava/lang/String;)Ljava/lang/Long;".equals(this.previousMethodCall.getSignature()))) {
                    preferred = new MethodAnnotation("java.lang.Long", "parseLong", "(Ljava/lang/String;)J", true);
                    bug = new BugInstance(this, "DM_BOXED_PRIMITIVE_FOR_PARSING", 1).addClassAndMethod(this).addCalledMethod(this).addMethod(preferred).describe("SHOULD_CALL");
                    this.accumulator.accumulateBug(bug, this);
                } else if ("compareTo".equals(called.getName()) && "valueOf".equals(this.previousMethodCall.getName()) && called.getClassDescriptor().equals(this.previousMethodCall.getClassDescriptor()) && !this.previousMethodCall.getSignature().startsWith("(Ljava/lang/String;")) {
                    String primitiveType = ClassName.getPrimitiveType(called.getClassDescriptor().getClassName());
                    XMethod rvo = this.stack.getStackItem(1).getReturnValueOf();
                    XField field = this.stack.getStackItem(1).getXField();
                    String signature = rvo != null ? new SignatureParser(rvo.getSignature()).getReturnTypeSignature() : (field != null ? field.getSignature() : "");
                    if (primitiveType != null && (this.previousMethodCall.equals(rvo) || signature.equals(primitiveType)) && (this.getThisClass().getMajor() >= 51 || this.getThisClass().getMajor() >= 48 && (primitiveType.equals("D") || primitiveType.equals("F")))) {
                        MethodDescriptor shouldCall = new MethodDescriptor(called.getClassDescriptor().getClassName(), "compare", "(" + primitiveType + primitiveType + ")I", true);
                        BugInstance bug2 = new BugInstance(this, "DM_BOXED_PRIMITIVE_FOR_COMPARE", primitiveType.equals("Z") ? 3 : (primitiveType.equals("B") ? 2 : 1)).addClassAndMethod(this).addCalledMethod(this).addMethod(shouldCall).describe("SHOULD_CALL");
                        this.accumulator.accumulateBug(bug2, this);
                    }
                }
            }
            this.previousMethodCall = called;
        } else {
            this.previousMethodCall = null;
        }
        if (seen == 18 || seen == 19 || seen == 20) {
            Constant c = this.getConstantRefOperand();
            if (this.testingEnabled && (c instanceof ConstantInteger && ((ConstantInteger)c).getBytes() == 500654080 || c instanceof ConstantLong && ((ConstantLong)c).getBytes() == 500654080L)) {
                BugInstance bug = new BugInstance(this, "TESTING", 1).addClassAndMethod(this).addString("Did you mean MICROS_PER_DAY").addInt(500654080).describe("INT_VALUE");
                this.accumulator.accumulateBug(bug, this);
            }
            if (c instanceof ConstantInteger && ((ConstantInteger)c).getBytes() == Integer.MIN_VALUE || c instanceof ConstantLong && ((ConstantLong)c).getBytes() == Long.MIN_VALUE) {
                this.sawLoadOfMinValue = true;
                this.pendingAbsoluteValueBug = null;
                this.pendingAbsoluteValueBugSourceLine = null;
                this.absoluteValueAccumulator.clearBugs();
            }
        }
        if (seen == 148) {
            OpcodeStack.Item left = this.stack.getStackItem(1);
            OpcodeStack.Item right = this.stack.getStackItem(0);
            this.checkForCompatibleLongComparison(left, right);
            this.checkForCompatibleLongComparison(right, left);
        }
        if (this.stack.getStackDepth() >= 2) {
            switch (seen) {
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    item0 = this.stack.getStackItem(0);
                    OpcodeStack.Item item1 = this.stack.getStackItem(1);
                    if (item0.getConstant() instanceof Integer) {
                        OpcodeStack.Item tmp = item0;
                        item0 = item1;
                        item1 = tmp;
                    }
                    Object constant1 = item1.getConstant();
                    XMethod returnValueOf = item0.getReturnValueOf();
                    if (!(constant1 instanceof Integer) || returnValueOf == null || !"getYear".equals(returnValueOf.getName()) || !"java.util.Date".equals(returnValueOf.getClassName()) && !"java.sql.Date".equals(returnValueOf.getClassName())) break;
                    int year = (Integer)constant1;
                    if (!this.testingEnabled || year <= 1900) break;
                    this.accumulator.accumulateBug(new BugInstance(this, "TESTING", 1).addClassAndMethod(this).addString("Comparison of getYear does understand that it returns year-1900").addMethod(returnValueOf).describe("METHOD_CALLED").addInt(year).describe("INT_VALUE"), this);
                    break;
                }
            }
        }
        if (seen == 155 && this.stack.getStackDepth() > 0 && this.stack.getStackItem(0).getSpecialKind() == 1) {
            this.sawCheckForNonNegativeSignedByte = this.getPC();
        }
        if (this.pendingAbsoluteValueBug != null) {
            if (this.opcodesSincePendingAbsoluteValueBug == 0) {
                ++this.opcodesSincePendingAbsoluteValueBug;
            } else {
                OpcodeStack.Item top;
                Object constantValue;
                if (seen == 112 && (constantValue = (top = this.stack.getStackItem(0)).getConstant()) instanceof Number && Util.isPowerOfTwo(((Number)constantValue).intValue())) {
                    this.pendingAbsoluteValueBug.setPriority(3);
                }
                this.absoluteValueAccumulator.accumulateBug(this.pendingAbsoluteValueBug, this.pendingAbsoluteValueBugSourceLine);
                this.pendingAbsoluteValueBug = null;
                this.pendingAbsoluteValueBugSourceLine = null;
            }
        }
        if (seen == 184 && "org/easymock/EasyMock".equals(this.getClassConstantOperand()) && ("replay".equals(this.getNameConstantOperand()) || "verify".equals(this.getNameConstantOperand()) || this.getNameConstantOperand().startsWith("reset")) && "([Ljava/lang/Object;)V".equals(this.getSigConstantOperand()) && this.getPrevOpcode(1) == 189 && this.getPrevOpcode(2) == 3) {
            this.accumulator.accumulateBug(new BugInstance(this, "DMI_VACUOUS_CALL_TO_EASYMOCK_METHOD", 2).addClassAndMethod(this).addCalledMethod(this), this);
        }
        if ((seen == 184 || seen == 182 || seen == 183 || seen == 185) && this.getSigConstantOperand().indexOf("Ljava/lang/Runnable;") >= 0) {
            SignatureParser parser = new SignatureParser(this.getSigConstantOperand());
            int count = 0;
            Iterator<String> i = parser.parameterSignatureIterator();
            while (i.hasNext()) {
                OpcodeStack.Item item;
                String parameter = i.next();
                if ("Ljava/lang/Runnable;".equals(parameter) && "Ljava/lang/Thread;".equals((item = this.stack.getStackItem(parser.getNumParameters() - 1 - count)).getSignature())) {
                    this.accumulator.accumulateBug(new BugInstance(this, "DMI_THREAD_PASSED_WHERE_RUNNABLE_EXPECTED", 2).addClassAndMethod(this).addCalledMethod(this), this);
                }
                ++count;
            }
        }
        if (this.prevOpcode == 133 && seen == 184 && "java/lang/Double".equals(this.getClassConstantOperand()) && "longBitsToDouble".equals(this.getNameConstantOperand())) {
            this.accumulator.accumulateBug(new BugInstance(this, "DMI_LONG_BITS_TO_DOUBLE_INVOKED_ON_INT", 1).addClassAndMethod(this).addCalledMethod(this), this);
        }
        for (SubDetector subDetector : this.subDetectors) {
            subDetector.sawOpcode(seen);
        }
        if (!this.sawLoadOfMinValue && seen == 184 && ClassName.isMathClass(this.getClassConstantOperand()) && "abs".equals(this.getNameConstantOperand())) {
            item0 = this.stack.getStackItem(0);
            int special = item0.getSpecialKind();
            if (special == 2) {
                this.pendingAbsoluteValueBug = new BugInstance(this, "RV_ABSOLUTE_VALUE_OF_RANDOM_INT", 1).addClassAndMethod(this);
                this.pendingAbsoluteValueBugSourceLine = SourceLineAnnotation.fromVisitedInstruction(this);
                this.opcodesSincePendingAbsoluteValueBug = 0;
            } else if (special == 4) {
                this.pendingAbsoluteValueBug = new BugInstance(this, "RV_ABSOLUTE_VALUE_OF_HASHCODE", 1).addClassAndMethod(this);
                this.pendingAbsoluteValueBugSourceLine = SourceLineAnnotation.fromVisitedInstruction(this);
                this.opcodesSincePendingAbsoluteValueBug = 0;
            }
        }
        try {
            OpcodeStack.Item top;
            String sig;
            int majorVersion;
            OpcodeStack.Item item;
            Object value;
            OpcodeStack.Item item02;
            Object constant0;
            int stackLoc = this.stackEntryThatMustBeNonnegative(seen);
            if (stackLoc >= 0) {
                OpcodeStack.Item tos = this.stack.getStackItem(stackLoc);
                switch (tos.getSpecialKind()) {
                    case 9: {
                        this.accumulator.accumulateBug(new BugInstance(this, "RV_REM_OF_HASHCODE", 1).addClassAndMethod(this), this);
                        break;
                    }
                    case 2: 
                    case 8: {
                        this.accumulator.accumulateBug(new BugInstance(this, "RV_REM_OF_RANDOM_INT", 1).addClassAndMethod(this), this);
                        break;
                    }
                }
            }
            if (seen == 112 && (constant0 = (item02 = this.stack.getStackItem(0)).getConstant()) instanceof Integer && (Integer)constant0 == 1) {
                this.accumulator.accumulateBug(new BugInstance(this, "INT_BAD_REM_BY_1", 1).addClassAndMethod(this), this);
            }
            if (this.stack.getStackDepth() >= 1 && (seen == 171 || seen == 170) && (item0 = this.stack.getStackItem(0)).getSpecialKind() == 1) {
                int[] switchLabels = this.getSwitchLabels();
                int[] switchOffsets = this.getSwitchOffsets();
                for (int i = 0; i < switchLabels.length; ++i) {
                    int v = switchLabels[i];
                    if (v > -129 && v < 128) continue;
                    this.accumulator.accumulateBug(new BugInstance(this, "INT_BAD_COMPARISON_WITH_SIGNED_BYTE", 1).addClassAndMethod(this).addInt(v).describe("INT_VALUE"), SourceLineAnnotation.fromVisitedInstruction(this, this.getPC() + switchOffsets[i]));
                }
            }
            if (this.stack.getStackDepth() >= 2) {
                switch (seen) {
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: {
                        int v1;
                        item0 = this.stack.getStackItem(0);
                        OpcodeStack.Item item1 = this.stack.getStackItem(1);
                        int seen2 = seen;
                        if (item0.getConstant() != null) {
                            OpcodeStack.Item tmp = item0;
                            item0 = item1;
                            item1 = tmp;
                            switch (seen) {
                                case 161: {
                                    seen2 = 163;
                                    break;
                                }
                                case 162: {
                                    seen2 = 164;
                                    break;
                                }
                                case 163: {
                                    seen2 = 161;
                                    break;
                                }
                                case 164: {
                                    seen2 = 162;
                                    break;
                                }
                            }
                        }
                        Object constant1 = item1.getConstant();
                        if (item0.getSpecialKind() == 1 && constant1 instanceof Number) {
                            int v12 = ((Number)constant1).intValue();
                            if (v12 > -129 && v12 < 128 && (v12 != 127 || seen2 == 159 || seen2 == 160)) break;
                            int priority = 1;
                            if (v12 == 127) {
                                switch (seen2) {
                                    case 163: {
                                        priority = 3;
                                        break;
                                    }
                                    case 162: {
                                        priority = 2;
                                        break;
                                    }
                                    case 161: {
                                        priority = 2;
                                        break;
                                    }
                                    case 164: {
                                        priority = 3;
                                    }
                                }
                            } else if (v12 == 128) {
                                switch (seen2) {
                                    case 163: {
                                        priority = 2;
                                        break;
                                    }
                                    case 162: {
                                        priority = 1;
                                        break;
                                    }
                                    case 161: {
                                        priority = 1;
                                        break;
                                    }
                                    case 164: {
                                        priority = 2;
                                    }
                                }
                            } else if (v12 <= -129) {
                                priority = 2;
                            }
                            if (this.getPC() - this.sawCheckForNonNegativeSignedByte < 10) {
                                ++priority;
                            }
                            this.accumulator.accumulateBug(new BugInstance(this, "INT_BAD_COMPARISON_WITH_SIGNED_BYTE", priority).addClassAndMethod(this).addInt(v12).describe("INT_VALUE").addValueSource(item0, this), this);
                            break;
                        }
                        if (item0.getSpecialKind() != 14 || !(constant1 instanceof Number) || (v1 = ((Number)constant1).intValue()) >= 0) break;
                        this.accumulator.accumulateBug(new BugInstance(this, "INT_BAD_COMPARISON_WITH_NONNEGATIVE_VALUE", 1).addClassAndMethod(this).addInt(v1).describe("INT_VALUE").addValueSource(item0, this), this);
                    }
                }
            }
            switch (seen) {
                case 155: 
                case 156: {
                    if (this.stack.getStackDepth() <= 0 || this.stack.getStackItem(0).getSpecialKind() != 14) break;
                    OpcodeStack.Item top2 = this.stack.getStackItem(0);
                    if (top2.getRegisterNumber() != -1 && this.getMaxPC() > this.getNextPC() + 6) {
                        int jump2;
                        int jump1;
                        if (seen == 156) {
                            jump1 = 161;
                            jump2 = 164;
                        } else {
                            jump1 = 162;
                            jump2 = 163;
                        }
                        int nextCodeByte0 = this.getNextCodeByte(0);
                        int loadConstant = 1;
                        if (nextCodeByte0 == 21) {
                            loadConstant = 2;
                        }
                        int nextCodeByte1 = this.getNextCodeByte(loadConstant);
                        int nextCodeByte2 = this.getNextCodeByte(loadConstant + 1);
                        int nextJumpOffset = loadConstant + 2;
                        if (nextCodeByte1 == 17) {
                            ++nextJumpOffset;
                        }
                        int nextCodeByteJump = this.getNextCodeByte(nextJumpOffset);
                        if (nextCodeByte0 == this.getPrevOpcode(1) && (nextCodeByte1 == 16 || nextCodeByte1 == 17) && 161 <= nextCodeByteJump && nextCodeByteJump <= 164) break;
                    }
                    this.accumulator.accumulateBug(new BugInstance(this, "INT_BAD_COMPARISON_WITH_NONNEGATIVE_VALUE", 2).addClassAndMethod(this).addInt(0).describe("INT_VALUE").addValueSource(top2, this), this);
                    break;
                }
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    long badValue = seen == 126 || seen == 127 ? -1L : 0L;
                    OpcodeStack.Item rhs = this.stack.getStackItem(0);
                    OpcodeStack.Item lhs = this.stack.getStackItem(1);
                    int prevOpcode = this.getPrevOpcode(1);
                    int prevPrevOpcode = this.getPrevOpcode(2);
                    if (!rhs.hasConstantValue(badValue) || prevOpcode != 18 && prevOpcode != 3 && prevOpcode != 2 && prevOpcode != 9 || prevPrevOpcode == 167) break;
                    this.reportVacuousBitOperation(seen, lhs);
                }
            }
            if (this.checkForBitIorofSignedByte && seen != 145) {
                String pattern = this.prevOpcode == 129 || this.prevOpcode == 128 ? "BIT_IOR_OF_SIGNED_BYTE" : "BIT_ADD_OF_SIGNED_BYTE";
                int priority = this.prevOpcode == 129 || this.prevOpcode == 97 ? 1 : 2;
                this.accumulator.accumulateBug(new BugInstance(this, pattern, priority).addClassAndMethod(this), this);
                this.checkForBitIorofSignedByte = false;
            } else if ((seen == 128 || seen == 129 || seen == 96 || seen == 97) && this.stack.getStackDepth() >= 2) {
                item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                int special0 = item0.getSpecialKind();
                int special1 = item1.getSpecialKind();
                this.checkForBitIorofSignedByte = special0 == 1 && special1 == 3 && !item1.hasConstantValue(256) || special0 == 3 && !item0.hasConstantValue(256) && special1 == 1;
            } else {
                this.checkForBitIorofSignedByte = false;
            }
            if (this.prevOpcodeWasReadLine && this.sinceBufferedInputStreamReady >= 100 && seen == 182 && "java/lang/String".equals(this.getClassConstantOperand()) && this.getSigConstantOperand().startsWith("()")) {
                this.accumulator.accumulateBug(new BugInstance(this, "NP_IMMEDIATE_DEREFERENCE_OF_READLINE", 2).addClassAndMethod(this), this);
            }
            this.sinceBufferedInputStreamReady = seen == 182 && "java/io/BufferedReader".equals(this.getClassConstantOperand()) && "ready".equals(this.getNameConstantOperand()) && "()Z".equals(this.getSigConstantOperand()) ? 0 : ++this.sinceBufferedInputStreamReady;
            this.prevOpcodeWasReadLine = (seen == 182 || seen == 185) && "readLine".equals(this.getNameConstantOperand()) && "()Ljava/lang/String;".equals(this.getSigConstantOperand());
            switch (this.randomNextIntState) {
                case 0: {
                    if ((seen != 182 || !"java/util/Random".equals(this.getClassConstantOperand()) || !"nextDouble".equals(this.getNameConstantOperand())) && (seen != 184 || !ClassName.isMathClass(this.getClassConstantOperand()) || !"random".equals(this.getNameConstantOperand()))) break;
                    this.randomNextIntState = 1;
                    break;
                }
                case 1: {
                    if (seen == 142) {
                        this.accumulator.accumulateBug(new BugInstance(this, "RV_01_TO_INT", 1).addClassAndMethod(this), this);
                        this.randomNextIntState = 0;
                        break;
                    }
                    if (seen == 107) {
                        this.randomNextIntState = 4;
                        break;
                    }
                    if (seen == 20 && this.getConstantRefOperand() instanceof ConstantDouble && ((ConstantDouble)this.getConstantRefOperand()).getBytes() == -2.147483648E9) {
                        this.randomNextIntState = 0;
                        break;
                    }
                    this.randomNextIntState = 2;
                    break;
                }
                case 2: {
                    if (seen == 135) {
                        this.randomNextIntState = 3;
                        break;
                    }
                    if (seen == 107) {
                        this.randomNextIntState = 4;
                        break;
                    }
                    this.randomNextIntState = 0;
                    break;
                }
                case 3: {
                    if (seen == 107) {
                        this.randomNextIntState = 4;
                        break;
                    }
                    this.randomNextIntState = 0;
                    break;
                }
                case 4: {
                    if (seen == 142) {
                        this.accumulator.accumulateBug(new BugInstance(this, "DM_NEXTINT_VIA_NEXTDOUBLE", 2).addClassAndMethod(this), this);
                    }
                    this.randomNextIntState = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.isPublicStaticVoidMain && seen == 182 && this.getClassConstantOperand().startsWith("javax/swing/") && ("show".equals(this.getNameConstantOperand()) && "()V".equals(this.getSigConstantOperand()) || "pack".equals(this.getNameConstantOperand()) && "()V".equals(this.getSigConstantOperand()) || "setVisible".equals(this.getNameConstantOperand()) && "(Z)V".equals(this.getSigConstantOperand()))) {
                this.accumulator.accumulateBug(new BugInstance(this, "SW_SWING_METHODS_INVOKED_IN_SWING_THREAD", 3).addClassAndMethod(this), this);
            }
            if (seen == 182 && "isAnnotationPresent".equals(this.getNameConstantOperand()) && "(Ljava/lang/Class;)Z".equals(this.getSigConstantOperand()) && this.stack.getStackDepth() > 0 && (value = (item = this.stack.getStackItem(0)).getConstant()) instanceof String) {
                String annotationClassName = (String)value;
                boolean lacksClassfileRetention = AnalysisContext.currentAnalysisContext().getAnnotationRetentionDatabase().lacksRuntimeRetention(annotationClassName.replace('/', '.'));
                if (lacksClassfileRetention) {
                    ClassDescriptor annotationClass = DescriptorFactory.createClassDescriptor(annotationClassName);
                    this.accumulator.accumulateBug(new BugInstance(this, "DMI_ANNOTATION_IS_NOT_VISIBLE_TO_REFLECTION", 1).addClassAndMethod(this).addCalledMethod(this).addClass(annotationClass).describe("CLASS_ANNOTATION"), this);
                }
            }
            if (seen == 182 && "next".equals(this.getNameConstantOperand()) && "()Ljava/lang/Object;".equals(this.getSigConstantOperand()) && "hasNext".equals(this.getMethodName()) && "()Z".equals(this.getMethodSig()) && this.stack.getStackDepth() > 0) {
                item = this.stack.getStackItem(0);
                this.accumulator.accumulateBug(new BugInstance(this, "DMI_CALLING_NEXT_FROM_HASNEXT", item.isInitialParameter() && item.getRegisterNumber() == 0 ? 2 : 3).addClassAndMethod(this).addCalledMethod(this), this);
            }
            if (seen == 183 && "java/lang/String".equals(this.getClassConstantOperand()) && "<init>".equals(this.getNameConstantOperand()) && "(Ljava/lang/String;)V".equals(this.getSigConstantOperand()) && !Subtypes2.isJSP(this.getThisClass())) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_STRING_CTOR", 2).addClassAndMethod(this), this);
            }
            if (seen == 184 && "java/lang/System".equals(this.getClassConstantOperand()) && "runFinalizersOnExit".equals(this.getNameConstantOperand()) || seen == 182 && "java/lang/Runtime".equals(this.getClassConstantOperand()) && "runFinalizersOnExit".equals(this.getNameConstantOperand())) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_RUN_FINALIZERS_ON_EXIT", 1).addClassAndMethod(this), this);
            }
            if (seen == 183 && "java/lang/String".equals(this.getClassConstantOperand()) && "<init>".equals(this.getNameConstantOperand()) && "()V".equals(this.getSigConstantOperand())) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_STRING_VOID_CTOR", 2).addClassAndMethod(this), this);
            }
            if (!this.isPublicStaticVoidMain && seen == 184 && "java/lang/System".equals(this.getClassConstantOperand()) && "exit".equals(this.getNameConstantOperand()) && !"processWindowEvent".equals(this.getMethodName()) && !this.getMethodName().startsWith("windowClos") && this.getMethodName().indexOf("exit") == -1 && this.getMethodName().indexOf("Exit") == -1 && this.getMethodName().indexOf("crash") == -1 && this.getMethodName().indexOf("Crash") == -1 && this.getMethodName().indexOf("die") == -1 && this.getMethodName().indexOf("Die") == -1 && this.getMethodName().indexOf("main") == -1) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_EXIT", this.getMethod().isStatic() ? 3 : 2).addClassAndMethod(this), SourceLineAnnotation.fromVisitedInstruction(this));
            }
            if ((seen == 184 && "java/lang/System".equals(this.getClassConstantOperand()) || seen == 182 && "java/lang/Runtime".equals(this.getClassConstantOperand())) && "gc".equals(this.getNameConstantOperand()) && "()V".equals(this.getSigConstantOperand()) && !this.getDottedClassName().startsWith("java.lang") && !this.getMethodName().startsWith("gc") && !this.getMethodName().endsWith("gc") && this.gcInvocationBugReport == null) {
                if (this.isPublicStaticVoidMain) {
                    return;
                }
                if (DumbMethods.isTestMethod(this.getMethod())) {
                    return;
                }
                this.gcInvocationBugReport = new BugInstance(this, "DM_GC", 1).addClassAndMethod(this).addSourceLine(this);
                this.gcInvocationPC = this.getPC();
            }
            if (!this.isSynthetic && seen == 183 && "java/lang/Boolean".equals(this.getClassConstantOperand()) && "<init>".equals(this.getNameConstantOperand()) && !"java/lang/Boolean".equals(this.getClassName()) && (majorVersion = this.getThisClass().getMajor()) >= 48) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_BOOLEAN_CTOR", 2).addClassAndMethod(this), this);
            }
            if (seen == 184 && "java/lang/System".equals(this.getClassConstantOperand()) && ("currentTimeMillis".equals(this.getNameConstantOperand()) || "nanoTime".equals(this.getNameConstantOperand()))) {
                this.sawCurrentTimeMillis = true;
            }
            if (seen == 182 && "java/lang/String".equals(this.getClassConstantOperand()) && "toString".equals(this.getNameConstantOperand()) && "()Ljava/lang/String;".equals(this.getSigConstantOperand())) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_STRING_TOSTRING", 3).addClassAndMethod(this), this);
            }
            if (seen == 182 && "java/lang/String".equals(this.getClassConstantOperand()) && ("toUpperCase".equals(this.getNameConstantOperand()) || "toLowerCase".equals(this.getNameConstantOperand())) && "()Ljava/lang/String;".equals(this.getSigConstantOperand())) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_CONVERT_CASE", 3).addClassAndMethod(this), this);
            }
            if (seen == 183 && "<init>".equals(this.getNameConstantOperand())) {
                String cls = this.getClassConstantOperand();
                String sig2 = this.getSigConstantOperand();
                String primitiveType = ClassName.getPrimitiveType(cls);
                this.primitiveObjCtorSeen = primitiveType != null && sig2.charAt(1) == primitiveType.charAt(0) ? cls : null;
            } else if (this.primitiveObjCtorSeen != null && seen == 182 && "toString".equals(this.getNameConstantOperand()) && this.getClassConstantOperand().equals(this.primitiveObjCtorSeen) && "()Ljava/lang/String;".equals(this.getSigConstantOperand())) {
                BugInstance bug = new BugInstance(this, "DM_BOXED_PRIMITIVE_TOSTRING", 2).addClassAndMethod(this).addCalledMethod(this);
                MethodAnnotation preferred = new MethodAnnotation(ClassName.toDottedClassName(this.primitiveObjCtorSeen), "toString", "(" + ClassName.getPrimitiveType(this.primitiveObjCtorSeen) + ")Ljava/lang/String;", true);
                bug.addMethod(preferred).describe("SHOULD_CALL");
                this.accumulator.accumulateBug(bug, this);
                this.primitiveObjCtorSeen = null;
            } else {
                this.primitiveObjCtorSeen = null;
            }
            if (seen == 183 && "<init>".equals(this.getNameConstantOperand())) {
                this.ctorSeen = true;
            } else if (this.ctorSeen && seen == 182 && "java/lang/Object".equals(this.getClassConstantOperand()) && "getClass".equals(this.getNameConstantOperand()) && "()Ljava/lang/Class;".equals(this.getSigConstantOperand())) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_NEW_FOR_GETCLASS", 2).addClassAndMethod(this), this);
                this.ctorSeen = false;
            } else {
                this.ctorSeen = false;
            }
            if (seen == 182 && this.isMonitorWait(this.getNameConstantOperand(), this.getSigConstantOperand())) {
                this.checkMonitorWait();
            }
            if (seen == 183 && "<init>".equals(this.getNameConstantOperand()) && "java/lang/Thread".equals(this.getClassConstantOperand()) && ("()V".equals(sig = this.getSigConstantOperand()) || "(Ljava/lang/String;)V".equals(sig) || "(Ljava/lang/ThreadGroup;Ljava/lang/String;)V".equals(sig))) {
                OpcodeStack.Item invokedOn = this.stack.getItemMethodInvokedOn(this);
                if (!"<init>".equals(this.getMethodName()) || invokedOn.getRegisterNumber() != 0) {
                    this.accumulator.accumulateBug(new BugInstance(this, "DM_USELESS_THREAD", 3).addClassAndMethod(this), this);
                }
            }
            if (seen == 183 && "java/math/BigDecimal".equals(this.getClassConstantOperand()) && "<init>".equals(this.getNameConstantOperand()) && "(D)V".equals(this.getSigConstantOperand()) && (value = (top = this.stack.getStackItem(0)).getConstant()) instanceof Double && !((Double)value).isInfinite() && !((Double)value).isNaN()) {
                String bigDecimalString;
                boolean ok;
                double arg = (Double)value;
                String dblString = Double.toString(arg);
                boolean bl = ok = dblString.equals(bigDecimalString = new BigDecimal(arg).toString()) || dblString.equals(bigDecimalString + ".0");
                if (!ok) {
                    boolean scary = dblString.length() <= 8 && bigDecimalString.length() > 12 && dblString.toUpperCase().indexOf(69) == -1;
                    this.bugReporter.reportBug(new BugInstance(this, "DMI_BIGDECIMAL_CONSTRUCTED_FROM_DOUBLE", scary ? 2 : 3).addClassAndMethod(this).addCalledMethod(this).addMethod("java.math.BigDecimal", "valueOf", "(D)Ljava/math/BigDecimal;", true).describe("METHOD_ALTERNATIVE_TARGET").addString(dblString).addString(bigDecimalString).addSourceLine(this));
                }
            }
        }
        finally {
            this.prevOpcode = seen;
        }
    }

    private void checkForCompatibleLongComparison(OpcodeStack.Item left, OpcodeStack.Item right) {
        long value;
        if (left.getSpecialKind() == 21 && right.getConstant() != null && ((value = ((Number)right.getConstant()).longValue()) > Integer.MAX_VALUE || value < Integer.MIN_VALUE)) {
            int priority = 1;
            if (value == 0x80000000L || value == -2147483649L) {
                priority = 2;
            }
            String stringValue = IntAnnotation.getShortInteger(value) + "L";
            if (value == 0xFFFFFFFFL) {
                stringValue = "0xffffffffL";
            } else if (value == 0x80000000L) {
                stringValue = "0x80000000L";
            }
            this.accumulator.accumulateBug(new BugInstance(this, "INT_BAD_COMPARISON_WITH_INT_VALUE", priority).addClassAndMethod(this).addString(stringValue).describe("STRING_NONSTRING_CONSTANT").addValueSource(left, this), this);
        }
    }

    private void reportVacuousBitOperation(int seen, OpcodeStack.Item item) {
        if (item.getConstant() == null) {
            this.accumulator.accumulateBug(new BugInstance(this, "INT_VACUOUS_BIT_OPERATION", 2).addClassAndMethod(this).addString(OPCODE_NAMES[seen]).addOptionalAnnotation(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), item, this.getPC())), this);
        }
    }

    private int stackEntryThatMustBeNonnegative(int seen) {
        switch (seen) {
            case 185: {
                if (!"java/util/List".equals(this.getClassConstantOperand())) break;
                return this.getStackEntryOfListCallThatMustBeNonnegative();
            }
            case 182: {
                if (!"java/util/LinkedList".equals(this.getClassConstantOperand()) && !"java/util/ArrayList".equals(this.getClassConstantOperand())) break;
                return this.getStackEntryOfListCallThatMustBeNonnegative();
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return 0;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return 1;
            }
        }
        return -1;
    }

    private int getStackEntryOfListCallThatMustBeNonnegative() {
        String name = this.getNameConstantOperand();
        if (("add".equals(name) || "set".equals(name)) && this.getSigConstantOperand().startsWith("(I")) {
            return 1;
        }
        if (("get".equals(name) || "remove".equals(name)) && this.getSigConstantOperand().startsWith("(I)")) {
            return 0;
        }
        return -1;
    }

    private void checkMonitorWait() {
        try {
            TypeDataflow typeDataflow = this.getClassContext().getTypeDataflow(this.getMethod());
            TypeDataflow.LocationAndFactPair pair = typeDataflow.getLocationAndFactForInstruction(this.getPC());
            if (pair == null) {
                return;
            }
            Type receiver = (Type)pair.frame.getInstance(pair.location.getHandle().getInstruction(), this.getClassContext().getConstantPoolGen());
            if (!(receiver instanceof ReferenceType)) {
                return;
            }
            if (Hierarchy.isSubtype((ReferenceType)receiver, CONDITION_TYPE)) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_MONITOR_WAIT_ON_CONDITION", 1).addClassAndMethod(this), this);
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        catch (DataflowAnalysisException e) {
            this.bugReporter.logError("Exception caught by DumbMethods", e);
        }
        catch (CFGBuilderException e) {
            this.bugReporter.logError("Exception caught by DumbMethods", e);
        }
    }

    private boolean isMonitorWait(String name, String sig) {
        return "wait".equals(name) && ("()V".equals(sig) || "(J)V".equals(sig) || "(JI)V".equals(sig));
    }

    @Override
    public void visit(Code obj) {
        super.visit(obj);
        this.flush();
    }

    private void flush() {
        if (this.pendingAbsoluteValueBug != null) {
            this.absoluteValueAccumulator.accumulateBug(this.pendingAbsoluteValueBug, this.pendingAbsoluteValueBugSourceLine);
            this.pendingAbsoluteValueBug = null;
            this.pendingAbsoluteValueBugSourceLine = null;
        }
        this.accumulator.reportAccumulatedBugs();
        if (this.sawLoadOfMinValue) {
            this.absoluteValueAccumulator.clearBugs();
        } else {
            this.absoluteValueAccumulator.reportAccumulatedBugs();
        }
        if (this.gcInvocationBugReport != null && !this.sawCurrentTimeMillis) {
            boolean outOfMemoryHandler = false;
            for (CodeException handler : this.exceptionTable) {
                String exClassName;
                ConstantPool cp;
                Constant constant;
                int catchTypeIndex;
                if (this.gcInvocationPC < handler.getHandlerPC() || this.gcInvocationPC > handler.getHandlerPC() + 20 || (catchTypeIndex = handler.getCatchType()) <= 0 || !((constant = (cp = this.getThisClass().getConstantPool()).getConstant(catchTypeIndex)) instanceof ConstantClass) || !"java/lang/OutOfMemoryError".equals(exClassName = (String)((ConstantClass)constant).getConstantValue(cp))) continue;
                outOfMemoryHandler = true;
                break;
            }
            if (!outOfMemoryHandler) {
                this.bugReporter.reportBug(this.gcInvocationBugReport);
            }
        }
        this.sawCurrentTimeMillis = false;
        this.gcInvocationBugReport = null;
        this.exceptionTable = null;
    }

    private class RandomOnceSubDetector
    extends SubDetector {
        private boolean freshRandomOnTos;
        private boolean freshRandomOneBelowTos;

        private RandomOnceSubDetector() {
            this.freshRandomOnTos = false;
            this.freshRandomOneBelowTos = false;
        }

        @Override
        public void initMethod(Method method) {
            this.freshRandomOnTos = false;
        }

        @Override
        public void sawOpcode(int seen) {
            if (seen == 182 && "java/util/Random".equals(DumbMethods.this.getClassConstantOperand()) && (this.freshRandomOnTos || this.freshRandomOneBelowTos)) {
                DumbMethods.this.accumulator.accumulateBug(new BugInstance(DumbMethods.this, "DMI_RANDOM_USED_ONLY_ONCE", 1).addClassAndMethod(DumbMethods.this).addCalledMethod(DumbMethods.this), DumbMethods.this);
            }
            this.freshRandomOneBelowTos = this.freshRandomOnTos && DumbMethods.this.isRegisterLoad();
            this.freshRandomOnTos = seen == 183 && "java/util/Random".equals(DumbMethods.this.getClassConstantOperand()) && "<init>".equals(DumbMethods.this.getNameConstantOperand());
        }
    }

    private class BadCastInEqualsSubDetector
    extends SubDetector {
        private boolean isEqualsObject;
        private boolean sawInstanceofCheck;
        private boolean reportedBadCastInEquals;

        private BadCastInEqualsSubDetector() {
        }

        @Override
        public void initMethod(Method method) {
            this.isEqualsObject = "equals".equals(DumbMethods.this.getMethodName()) && "(Ljava/lang/Object;)Z".equals(DumbMethods.this.getMethodSig()) && !method.isStatic();
            this.sawInstanceofCheck = false;
            this.reportedBadCastInEquals = false;
        }

        @Override
        public void sawOpcode(int seen) {
            if (this.isEqualsObject && !this.reportedBadCastInEquals) {
                OpcodeStack.Item item;
                if (seen == 182 && "isInstance".equals(DumbMethods.this.getNameConstantOperand()) && "java/lang/Class".equals(DumbMethods.this.getClassConstantOperand())) {
                    OpcodeStack.Item item2 = DumbMethods.this.stack.getStackItem(0);
                    if (item2.getRegisterNumber() == 1) {
                        this.sawInstanceofCheck = true;
                    }
                } else if (seen == 193 || seen == 182 && "getClass".equals(DumbMethods.this.getNameConstantOperand()) && "()Ljava/lang/Class;".equals(DumbMethods.this.getSigConstantOperand())) {
                    OpcodeStack.Item item3 = DumbMethods.this.stack.getStackItem(0);
                    if (item3.getRegisterNumber() == 1) {
                        this.sawInstanceofCheck = true;
                    }
                } else if (seen == 183 && "equals".equals(DumbMethods.this.getNameConstantOperand()) && "(Ljava/lang/Object;)Z".equals(DumbMethods.this.getSigConstantOperand())) {
                    OpcodeStack.Item item0 = DumbMethods.this.stack.getStackItem(0);
                    OpcodeStack.Item item1 = DumbMethods.this.stack.getStackItem(1);
                    if (item1.getRegisterNumber() + item0.getRegisterNumber() == 1) {
                        this.sawInstanceofCheck = true;
                    }
                } else if (seen == 192 && !this.sawInstanceofCheck && (item = DumbMethods.this.stack.getStackItem(0)).getRegisterNumber() == 1) {
                    if (DumbMethods.this.getSizeOfSurroundingTryBlock(DumbMethods.this.getPC()) == Integer.MAX_VALUE) {
                        DumbMethods.this.accumulator.accumulateBug(new BugInstance(DumbMethods.this, "BC_EQUALS_METHOD_SHOULD_WORK_FOR_ALL_OBJECTS", 2).addClassAndMethod(DumbMethods.this), DumbMethods.this);
                    }
                    this.reportedBadCastInEquals = true;
                }
            }
        }
    }

    private class VacuousComparisonSubDetector
    extends SubDetector {
        private VacuousComparisonSubDetector() {
        }

        @Override
        public void sawOpcode(int seen) {
            OpcodeStack.Item lhs;
            Object lhsConstant;
            Object rhsConstant;
            OpcodeStack.Item rhs;
            boolean foundVacuousComparison = false;
            if (seen == 163 || seen == 164) {
                rhs = DumbMethods.this.stack.getStackItem(0);
                rhsConstant = rhs.getConstant();
                if (rhsConstant instanceof Integer && (Integer)rhsConstant == Integer.MAX_VALUE) {
                    foundVacuousComparison = true;
                }
                if ((lhsConstant = (lhs = DumbMethods.this.stack.getStackItem(1)).getConstant()) instanceof Integer && (Integer)lhsConstant == Integer.MIN_VALUE) {
                    foundVacuousComparison = true;
                }
            }
            if (seen == 161 || seen == 162) {
                rhs = DumbMethods.this.stack.getStackItem(0);
                rhsConstant = rhs.getConstant();
                if (rhsConstant instanceof Integer && (Integer)rhsConstant == Integer.MIN_VALUE) {
                    foundVacuousComparison = true;
                }
                if ((lhsConstant = (lhs = DumbMethods.this.stack.getStackItem(1)).getConstant()) instanceof Integer && (Integer)lhsConstant == Integer.MAX_VALUE) {
                    foundVacuousComparison = true;
                }
            }
            if (foundVacuousComparison) {
                DumbMethods.this.accumulator.accumulateBug(new BugInstance(DumbMethods.this, "INT_VACUOUS_COMPARISON", DumbMethods.this.getBranchOffset() < 0 ? 1 : 2).addClassAndMethod(DumbMethods.this), DumbMethods.this);
            }
        }
    }

    private class UrlCollectionSubDetector
    extends SubDetector {
        private UrlCollectionSubDetector() {
        }

        @Override
        public void sawOpcode(int seen) {
            OpcodeStack.Item top;
            if ((seen == 182 && "java/util/HashMap".equals(DumbMethods.this.getClassConstantOperand()) && "get".equals(DumbMethods.this.getNameConstantOperand()) || seen == 185 && "java/util/Map".equals(DumbMethods.this.getClassConstantOperand()) && "get".equals(DumbMethods.this.getNameConstantOperand()) || seen == 182 && "java/util/HashSet".equals(DumbMethods.this.getClassConstantOperand()) && "contains".equals(DumbMethods.this.getNameConstantOperand()) || seen == 185 && "java/util/Set".equals(DumbMethods.this.getClassConstantOperand()) && "contains".equals(DumbMethods.this.getNameConstantOperand())) && "Ljava/net/URL;".equals((top = DumbMethods.this.stack.getStackItem(0)).getSignature())) {
                DumbMethods.this.accumulator.accumulateBug(new BugInstance(DumbMethods.this, "DMI_COLLECTION_OF_URLS", 1).addClassAndMethod(DumbMethods.this), DumbMethods.this);
            }
        }
    }

    private class RangeCheckSubDetector
    extends SubDetector {
        private RangeCheckSubDetector() {
        }

        private void checkRange(OpcodeStack.Item item, Object minValue, Object maxValue, String pattern) {
            OpcodeStack.Item maxItem;
            if (!(item.getConstant() instanceof Number)) {
                return;
            }
            int value = ((Number)item.getConstant()).intValue();
            int intMin = Integer.MIN_VALUE;
            int intMax = Integer.MAX_VALUE;
            if (minValue instanceof Number) {
                intMin = ((Number)minValue).intValue();
            }
            if (maxValue instanceof Number) {
                intMax = ((Number)maxValue).intValue();
            } else if (maxValue instanceof String) {
                intMax = ((String)maxValue).length() - 1;
            } else if (maxValue instanceof OpcodeStack.Item && (maxItem = (OpcodeStack.Item)maxValue).getSignature().charAt(0) == '[' && maxItem.getConstant() instanceof Integer) {
                intMax = (Integer)maxItem.getConstant() - 1;
            }
            if (value < intMin || value > intMax) {
                BugInstance bug = new BugInstance(pattern, 2).addClassAndMethod(DumbMethods.this).addSourceLine(DumbMethods.this).addInt(value).describe("INT_VALUE");
                if (intMin <= intMax) {
                    if (value < intMin) {
                        bug.addInt(intMin).describe("INT_MIN_VALUE");
                    }
                    if (value > intMax) {
                        bug.addInt(intMax).describe("INT_MAX_VALUE");
                    }
                }
                if (DumbMethods.this.isMethodCall()) {
                    bug.addCalledMethod(DumbMethods.this);
                }
                DumbMethods.this.accumulator.accumulateBug(bug, DumbMethods.this);
            }
        }

        @Override
        public void sawOpcode(int seen) {
            switch (seen) {
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    this.checkRange(DumbMethods.this.stack.getStackItem(0), 0, DumbMethods.this.stack.getStackItem(1), "RANGE_ARRAY_INDEX");
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.checkRange(DumbMethods.this.stack.getStackItem(1), 0, DumbMethods.this.stack.getStackItem(2), "RANGE_ARRAY_INDEX");
                    break;
                }
                case 184: {
                    MethodDescriptor m = DumbMethods.this.getMethodDescriptorOperand();
                    if (!m.getSlashedClassName().equals("java/lang/System") || !m.getName().equals("arraycopy")) break;
                    OpcodeStack.Item length = DumbMethods.this.stack.getStackItem(0);
                    Object constantLength = length.getConstant();
                    OpcodeStack.Item srcPos = DumbMethods.this.stack.getStackItem(3);
                    OpcodeStack.Item src = DumbMethods.this.stack.getStackItem(4);
                    this.checkRange(srcPos, 0, src, "RANGE_ARRAY_OFFSET");
                    OpcodeStack.Item dest = DumbMethods.this.stack.getStackItem(2);
                    OpcodeStack.Item destPos = DumbMethods.this.stack.getStackItem(1);
                    this.checkRange(destPos, 0, dest, "RANGE_ARRAY_OFFSET");
                    if (!(constantLength instanceof Number)) break;
                    int length1 = Integer.MAX_VALUE;
                    if (src.getConstant() instanceof Integer) {
                        length1 = (Integer)src.getConstant();
                    }
                    if (srcPos.getConstant() instanceof Integer) {
                        length1 -= ((Integer)srcPos.getConstant()).intValue();
                    }
                    int length2 = Integer.MAX_VALUE;
                    if (dest.getConstant() instanceof Integer) {
                        length2 = (Integer)DumbMethods.this.stack.getStackItem(2).getConstant();
                    }
                    if (destPos.getConstant() instanceof Integer) {
                        length2 -= ((Integer)DumbMethods.this.stack.getStackItem(1).getConstant()).intValue();
                    }
                    this.checkRange(length, 0, Math.min(length1, length2), "RANGE_ARRAY_LENGTH");
                    break;
                }
                case 182: 
                case 183: {
                    MethodDescriptor m = DumbMethods.this.getMethodDescriptorOperand();
                    if (m.getSlashedClassName().equals("java/lang/String")) {
                        if ((m.getName().equals("charAt") || m.getName().equals("codePointAt")) && m.getSignature().startsWith("(I)")) {
                            this.checkRange(DumbMethods.this.stack.getStackItem(0), 0, DumbMethods.this.stack.getStackItem(1).getConstant(), "RANGE_STRING_INDEX");
                        }
                        if (m.getName().equals("substring") || m.getName().equals("subSequence")) {
                            int nArgs = PreorderVisitor.getNumberArguments(m.getSignature());
                            OpcodeStack.Item thisArg = DumbMethods.this.stack.getStackItem(nArgs);
                            OpcodeStack.Item firstArg = DumbMethods.this.stack.getStackItem(nArgs - 1);
                            Object thisConstantValue = thisArg.getConstant();
                            int maxLength = thisConstantValue instanceof String ? ((String)thisConstantValue).length() : Integer.MAX_VALUE;
                            this.checkRange(firstArg, 0, maxLength, "RANGE_STRING_INDEX");
                            if (nArgs == 2) {
                                OpcodeStack.Item secondArg = DumbMethods.this.stack.getStackItem(0);
                                this.checkRange(secondArg, firstArg.getConstant() == null ? Integer.valueOf(0) : firstArg.getConstant(), maxLength, "RANGE_STRING_INDEX");
                            }
                        }
                    }
                    if (!m.getSignature().startsWith("([BII)") && !m.getSignature().startsWith("([CII)") && !m.getSignature().startsWith("([III)") || (!m.getName().equals("write") && !m.getName().equals("read") || !m.getSlashedClassName().startsWith("java/io/")) && (!m.getName().equals("<init>") || !m.getSlashedClassName().equals("java/lang/String"))) break;
                    OpcodeStack.Item arrayArg = DumbMethods.this.stack.getStackItem(2);
                    OpcodeStack.Item offsetArg = DumbMethods.this.stack.getStackItem(1);
                    OpcodeStack.Item lengthArg = DumbMethods.this.stack.getStackItem(0);
                    int length = Integer.MAX_VALUE;
                    if (arrayArg.getConstant() instanceof Integer) {
                        length = (Integer)arrayArg.getConstant();
                    }
                    if (offsetArg.getConstant() instanceof Integer) {
                        this.checkRange(offsetArg, 0, DumbMethods.saturatingIncrement(length), "RANGE_ARRAY_OFFSET");
                        length -= ((Integer)offsetArg.getConstant()).intValue();
                    }
                    this.checkRange(lengthArg, 0, DumbMethods.saturatingIncrement(length), "RANGE_ARRAY_LENGTH");
                    break;
                }
            }
        }
    }

    private class FutilePoolSizeSubDetector
    extends SubDetector {
        private FutilePoolSizeSubDetector() {
        }

        @Override
        public void sawOpcode(int seen) {
            if (seen == 182 && "java/util/concurrent/ScheduledThreadPoolExecutor".equals(DumbMethods.this.getClassConstantOperand()) && "setMaximumPoolSize".equals(DumbMethods.this.getNameConstantOperand())) {
                DumbMethods.this.accumulator.accumulateBug(new BugInstance(DumbMethods.this, "DMI_FUTILE_ATTEMPT_TO_CHANGE_MAXPOOL_SIZE_OF_SCHEDULED_THREAD_POOL_EXECUTOR", 1).addClassAndMethod(DumbMethods.this), DumbMethods.this);
            }
        }
    }

    private class NullMethodsSubDetector
    extends SubDetector {
        private NullMethodsSubDetector() {
        }

        @Override
        public void sawOpcode(int seen) {
            BugInstance bug;
            Object secondConstant;
            String bugPattern;
            OpcodeStack.Item secondArgument;
            Object o;
            OpcodeStack.Item item;
            int args;
            if (seen == 184 && ("com/google/common/base/Preconditions".equals(DumbMethods.this.getClassConstantOperand()) && "checkNotNull".equals(DumbMethods.this.getNameConstantOperand()) || "com/google/common/base/Strings".equals(DumbMethods.this.getClassConstantOperand()) && ("nullToEmpty".equals(DumbMethods.this.getNameConstantOperand()) || "emptyToNull".equals(DumbMethods.this.getNameConstantOperand()) || "isNullOrEmpty".equals(DumbMethods.this.getNameConstantOperand())))) {
                args = PreorderVisitor.getNumberArguments(DumbMethods.this.getSigConstantOperand());
                item = DumbMethods.this.stack.getStackItem(args - 1);
                o = item.getConstant();
                if (o instanceof String) {
                    secondArgument = null;
                    bugPattern = "DMI_DOH";
                    if (args > 1 && !((secondConstant = (secondArgument = DumbMethods.this.stack.getStackItem(args - 2)).getConstant()) instanceof String)) {
                        bugPattern = "DMI_ARGUMENTS_WRONG_ORDER";
                    }
                    bug = new BugInstance(DumbMethods.this, bugPattern, 2).addClassAndMethod(DumbMethods.this).addCalledMethod(DumbMethods.this).addString("Passing String constant as value that should be null checked").describe("STRING_MESSAGE").addString((String)o).describe("STRING_CONSTANT");
                    if (secondArgument != null) {
                        bug.addValueSource(secondArgument, DumbMethods.this);
                    }
                    DumbMethods.this.accumulator.accumulateBug(bug, DumbMethods.this);
                }
            }
            if (seen == 184 && ("junit/framework/Assert".equals(DumbMethods.this.getClassConstantOperand()) || "org/junit/Assert".equals(DumbMethods.this.getClassConstantOperand())) && "assertNotNull".equals(DumbMethods.this.getNameConstantOperand())) {
                args = PreorderVisitor.getNumberArguments(DumbMethods.this.getSigConstantOperand());
                item = DumbMethods.this.stack.getStackItem(0);
                o = item.getConstant();
                if (o instanceof String) {
                    secondArgument = null;
                    bugPattern = "DMI_DOH";
                    if (args == 2 && !((secondConstant = (secondArgument = DumbMethods.this.stack.getStackItem(1)).getConstant()) instanceof String)) {
                        bugPattern = "DMI_ARGUMENTS_WRONG_ORDER";
                    }
                    bug = new BugInstance(DumbMethods.this, bugPattern, 2).addClassAndMethod(DumbMethods.this).addCalledMethod(DumbMethods.this).addString("Passing String constant as value that should be null checked").describe("STRING_MESSAGE").addString((String)o).describe("STRING_CONSTANT");
                    if (secondArgument != null) {
                        bug.addValueSource(secondArgument, DumbMethods.this);
                    }
                    DumbMethods.this.accumulator.accumulateBug(bug, DumbMethods.this);
                }
            }
        }
    }

    private class InvalidMinMaxSubDetector
    extends SubDetector {
        Number lowerBound;
        Number upperBound;

        private InvalidMinMaxSubDetector() {
        }

        @Override
        public void initMethod(Method method) {
            this.upperBound = null;
            this.lowerBound = null;
        }

        @Override
        public void sawOpcode(int seen) {
            if (seen == 184 && DumbMethods.this.getClassConstantOperand().equals("java/lang/Math") && (DumbMethods.this.getMethodDescriptorOperand().getName().equals("max") || DumbMethods.this.getMethodDescriptorOperand().getName().equals("min"))) {
                Object const1 = DumbMethods.this.stack.getStackItem(0).getConstant();
                Object const2 = DumbMethods.this.stack.getStackItem(1).getConstant();
                Number n = null;
                if (const1 != null ^ const2 != null) {
                    Number number = n = const1 instanceof Number ? (Number)((Number)const1) : (Number)((Number)const2);
                    if (DumbMethods.this.getMethodDescriptorOperand().getName().equals("min")) {
                        this.upperBound = n;
                    } else {
                        this.lowerBound = n;
                    }
                } else {
                    this.lowerBound = null;
                    this.upperBound = null;
                }
                XMethod rvo1 = DumbMethods.this.stack.getStackItem(0).getReturnValueOf();
                XMethod rvo2 = DumbMethods.this.stack.getStackItem(1).getReturnValueOf();
                if (rvo1 != null ^ rvo2 != null) {
                    int result;
                    XMethod rvo;
                    XMethod xMethod = rvo = rvo1 == null ? rvo2 : rvo1;
                    if (this.lowerBound instanceof Comparable && this.upperBound != null && this.upperBound.getClass() == this.lowerBound.getClass() && rvo.getClassDescriptor().getClassName().equals("java/lang/Math") && (rvo.getName().equals("max") || rvo.getName().equals("min")) && (result = ((Comparable)((Object)this.lowerBound)).compareTo(this.upperBound)) > 0) {
                        DumbMethods.this.accumulator.accumulateBug(new BugInstance("DM_INVALID_MIN_MAX", 1).addClassAndMethod(DumbMethods.this).addString(String.valueOf(n)), DumbMethods.this);
                    }
                }
            }
        }
    }

    private abstract class SubDetector {
        private SubDetector() {
        }

        public void initMethod(Method method) {
        }

        public abstract void sawOpcode(int var1);
    }
}

