/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class BadAppletConstructor
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private final JavaClass appletClass;
    private boolean inConstructor;

    public BadAppletConstructor(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        JavaClass appletClass = null;
        try {
            appletClass = Repository.lookupClass("java.applet.Applet");
        }
        catch (ClassNotFoundException cnfe) {
            bugReporter.reportMissingClass(cnfe);
        }
        this.appletClass = appletClass;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (this.appletClass == null) {
            return;
        }
        JavaClass cls = classContext.getJavaClass();
        try {
            if (cls.instanceOf(this.appletClass)) {
                cls.accept(this);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    @Override
    public void visit(Method obj) {
        this.inConstructor = "<init>".equals(obj.getName());
    }

    @Override
    public void visit(Code obj) {
        if (this.inConstructor) {
            super.visit(obj);
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 182) {
            String method = this.getNameConstantOperand();
            String signature = this.getSigConstantOperand();
            if (("getDocumentBase".equals(method) || "getCodeBase".equals(method)) && "()Ljava/net/URL;".equals(signature) || "getAppletContext".equals(method) && "()Ljava/applet/AppletContext;".equals(signature) || "getParameter".equals(method) && "(Ljava/lang/String;)Ljava/lang/String;".equals(signature)) {
                this.bugReporter.reportBug(new BugInstance(this, "BAC_BAD_APPLET_CONSTRUCTOR", 2).addClassAndMethod(this).addSourceLine(this));
            }
        }
    }
}

