/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BytecodeScanner;
import edu.umd.cs.findbugs.util.Util;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.bcel.classfile.Method;

public class MethodHash
implements Comparable<MethodHash> {
    public static final String METHOD_HASH_ELEMENT_NAME = "MethodHash";
    private byte[] hash;
    private String methodName;
    private String methodSig;
    private boolean isStatic;

    public MethodHash() {
    }

    public MethodHash(String methodName, String methodSig, boolean isStatic, byte[] hash) {
        this.methodName = methodName;
        this.methodSig = methodSig;
        this.isStatic = isStatic;
        this.hash = new byte[hash.length];
        System.arraycopy(hash, 0, this.hash, 0, hash.length);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodSig() {
        return this.methodSig;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public byte[] getMethodHash() {
        return this.hash;
    }

    public MethodHash computeHash(Method method) {
        final MessageDigest digest = Util.getMD5Digest();
        byte[] code = method.getCode() == null || method.getCode().getCode() == null ? new byte[]{} : method.getCode().getCode();
        BytecodeScanner.Callback callback = new BytecodeScanner.Callback(){

            @Override
            public void handleInstruction(int opcode, int index) {
                digest.update((byte)opcode);
            }
        };
        BytecodeScanner bytecodeScanner = new BytecodeScanner();
        bytecodeScanner.scan(code, callback);
        this.hash = digest.digest();
        return this;
    }

    public boolean isSameHash(MethodHash other) {
        return Arrays.equals(this.hash, other.hash);
    }

    @Override
    public int compareTo(MethodHash other) {
        return MethodHash.compareHashes(this.hash, other.hash);
    }

    public boolean equals(Object o) {
        if (o instanceof MethodHash) {
            return this.isSameHash((MethodHash)o);
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        for (byte b : this.hash) {
            result = result * 17 + b;
        }
        return result;
    }

    public static int compareHashes(byte[] a, byte[] b) {
        int pfxlen = Math.min(a.length, b.length);
        for (int i = 0; i < pfxlen; ++i) {
            int cmp = MethodHash.toUnsigned(a[i]) - MethodHash.toUnsigned(b[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return a.length - b.length;
    }

    private static int toUnsigned(byte b) {
        int value = b & 0x7F;
        if ((b & 0x80) != 0) {
            value |= 0x80;
        }
        return value;
    }
}

