/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmrec.personalization;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeocentricCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.openstreetmap.josm.plugins.container.OSMNode;
import org.openstreetmap.josm.plugins.container.OSMWay;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HistoryParser {
    private static final String OSM_API = "http://api.openstreetmap.org/api/0.6/";
    private static final CoordinateReferenceSystem sourceCRS = DefaultGeographicCRS.WGS84;
    private static final CoordinateReferenceSystem targetCRS = DefaultGeocentricCRS.CARTESIAN;
    private static final GeometryFactory geometryFactory = new GeometryFactory();
    private MathTransform transform;
    private OSMNode nodeTmp;
    private final List<OSMNode> nodeList;
    private final Map<String, OSMNode> nodesWithIDs;
    private final List<OSMWay> wayList;
    private OSMWay wayTmp;
    private final String username;

    public HistoryParser(String username) {
        this.username = username;
        this.transform = null;
        try {
            this.transform = CRS.findMathTransform(sourceCRS, targetCRS, true);
        }
        catch (FactoryException ex) {
            Logger.getLogger(HistoryParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.nodeList = new ArrayList<OSMNode>();
        this.nodesWithIDs = new HashMap<String, OSMNode>();
        this.wayList = new ArrayList<OSMWay>();
    }

    public void historyParse(String timeInterval) {
        HashSet<String> changesetIDsList = new HashSet<String>();
        try {
            String osmUrl = "http://api.openstreetmap.org/api/0.6/changesets?display_name=" + this.username + "&time=" + timeInterval;
            System.out.println("requesting..\n" + osmUrl);
            URL url = new URL(osmUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            InputStream xml = connection.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xml);
            NodeList nodes = doc.getElementsByTagName("changeset");
            System.out.println("changeset size " + nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                System.out.println("attributes of " + i + "th changeset");
                String id = nodes.item(i).getAttributes().item(3).toString();
                System.out.println("id:" + nodes.item(i).getAttributes().item(3));
                id = this.stripQuotes(id);
                changesetIDsList.add(id);
            }
            for (String id : changesetIDsList) {
                this.getChangesetByID(id);
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HistoryParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HistoryParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException | SAXException ex) {
            Logger.getLogger(HistoryParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void getChangesetByID(String id) {
        try {
            NodeList changeChilds;
            Node osmObject;
            String changeType;
            int i;
            String changesetByIDURL = "http://api.openstreetmap.org/api/0.6/changeset/" + id + "/download";
            System.out.println("requesting..\n" + changesetByIDURL);
            URL url = new URL(changesetByIDURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            InputStream xml = connection.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xml);
            Node osmChange = doc.getFirstChild();
            for (i = 0; i < osmChange.getChildNodes().getLength(); ++i) {
                changeType = osmChange.getChildNodes().item(i).getNodeName();
                if (changeType.equals("#text") || changeType.equals("delete") || !(osmObject = (changeChilds = osmChange.getChildNodes().item(i).getChildNodes()).item(1)).getNodeName().equals("node")) continue;
                this.nodeTmp = new OSMNode();
                this.nodeTmp.setID(osmObject.getAttributes().getNamedItem("id").getNodeValue());
                double longitude = Double.parseDouble(osmObject.getAttributes().getNamedItem("lon").getNodeValue());
                double latitude = Double.parseDouble(osmObject.getAttributes().getNamedItem("lat").getNodeValue());
                Coordinate targetGeometry = null;
                Coordinate sourceCoordinate = new Coordinate(longitude, latitude);
                try {
                    targetGeometry = JTS.transform(sourceCoordinate, null, this.transform);
                }
                catch (MismatchedDimensionException | TransformException ex) {
                    Logger.getLogger(HistoryParser.class.getName()).log(Level.SEVERE, null, ex);
                }
                Point geom = geometryFactory.createPoint(new Coordinate(targetGeometry));
                this.nodeTmp.setGeometry(geom);
                this.nodeList.add(this.nodeTmp);
                this.nodesWithIDs.put(this.nodeTmp.getID(), this.nodeTmp);
            }
            for (i = 0; i < osmChange.getChildNodes().getLength(); ++i) {
                changeType = osmChange.getChildNodes().item(i).getNodeName();
                if (changeType.equals("#text") || changeType.equals("delete") || !(osmObject = (changeChilds = osmChange.getChildNodes().item(i).getChildNodes()).item(1)).getNodeName().equals("way")) continue;
                this.wayTmp = new OSMWay();
                this.wayTmp.setID(osmObject.getAttributes().getNamedItem("id").getNodeValue());
                System.out.println("\n\nWAY: " + this.wayTmp.getID());
                for (int l = 0; l < osmObject.getChildNodes().getLength(); ++l) {
                    String wayChild = osmObject.getChildNodes().item(l).getNodeName();
                    if (wayChild.equals("tag")) {
                        String key = osmObject.getChildNodes().item(l).getAttributes().getNamedItem("k").getNodeValue();
                        String value = osmObject.getChildNodes().item(l).getAttributes().getNamedItem("v").getNodeValue();
                        System.out.println("key: " + key + " value: " + value);
                        this.wayTmp.setTagKeyValue(key, value);
                        continue;
                    }
                    if (!wayChild.equals("nd")) continue;
                    this.wayTmp.addNodeReference(osmObject.getChildNodes().item(l).getAttributes().getNamedItem("ref").getNodeValue());
                }
                List<String> references = this.wayTmp.getNodeReferences();
                for (String entry : references) {
                    if (this.nodesWithIDs.containsKey(entry)) {
                        Geometry geometry = this.nodesWithIDs.get(entry).getGeometry();
                        this.wayTmp.addNodeGeometry(geometry);
                        continue;
                    }
                    System.out.println("nodes with ids, no entry " + entry);
                    this.getNodeFromAPI(entry);
                }
                Geometry geom = geometryFactory.buildGeometry(this.wayTmp.getNodeGeometries());
                if (this.wayTmp.getNodeGeometries().size() > 3 && this.wayTmp.getNodeGeometries().get(0).equals(this.wayTmp.getNodeGeometries().get(this.wayTmp.getNodeGeometries().size() - 1))) {
                    LinearRing linear;
                    if (!this.wayTmp.getTagKeyValue().containsKey("barrier") && !this.wayTmp.getTagKeyValue().containsKey("highway")) {
                        linear = geometryFactory.createLinearRing(geom.getCoordinates());
                        Polygon poly = new Polygon(linear, null, geometryFactory);
                        this.wayTmp.setGeometry(poly);
                    } else {
                        linear = geometryFactory.createLinearRing(geom.getCoordinates());
                        this.wayTmp.setGeometry(linear);
                    }
                } else if (this.wayTmp.getNodeGeometries().size() > 1) {
                    LineString lineString = geometryFactory.createLineString(geom.getCoordinates());
                    this.wayTmp.setGeometry(lineString);
                } else {
                    Point point = geometryFactory.createPoint(geom.getCoordinate());
                    this.wayTmp.setGeometry(point);
                }
                this.wayList.add(this.wayTmp);
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HistoryParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HistoryParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException | SAXException ex) {
            Logger.getLogger(HistoryParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String stripQuotes(String id) {
        id = id.substring(4, id.length() - 1);
        return id;
    }

    private void getNodeFromAPI(String nodeID) {
        try {
            String osmUrl = "http://api.openstreetmap.org/api/0.6/node/" + nodeID;
            System.out.println("requesting..\n" + osmUrl);
            URL url = new URL(osmUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            InputStream xml = connection.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xml);
            NodeList nodes = doc.getElementsByTagName("node");
            String lat = nodes.item(0).getAttributes().getNamedItem("lat").getNodeValue();
            String lon = nodes.item(0).getAttributes().getNamedItem("lon").getNodeValue();
            this.nodeTmp = new OSMNode();
            this.nodeTmp.setID(nodeID);
            double longitude = Double.parseDouble(lon);
            double latitude = Double.parseDouble(lat);
            Coordinate targetGeometry = null;
            Coordinate sourceCoordinate = new Coordinate(longitude, latitude);
            try {
                targetGeometry = JTS.transform(sourceCoordinate, null, this.transform);
            }
            catch (MismatchedDimensionException | TransformException ex) {
                Logger.getLogger(HistoryParser.class.getName()).log(Level.SEVERE, null, ex);
            }
            Point geom = geometryFactory.createPoint(new Coordinate(targetGeometry));
            this.nodeTmp.setGeometry(geom);
            this.nodeList.add(this.nodeTmp);
            this.nodesWithIDs.put(this.nodeTmp.getID(), this.nodeTmp);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HistoryParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HistoryParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException | SAXException ex) {
            Logger.getLogger(HistoryParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public List<OSMWay> getWayList() {
        return this.wayList;
    }
}

