/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.extractor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.util.Version;
import org.openstreetmap.josm.plugins.extractor.FrequenceExtractor;
import org.openstreetmap.josm.plugins.extractor.LanguageDetector;

public class Analyzer {
    private final String osmFilePath;
    private static final HashSet<String> stopWordsList = new HashSet();
    private ArrayList<Map.Entry<String, Integer>> frequencies;
    private final LanguageDetector languageDetector;

    public Analyzer(String osmFilePath, LanguageDetector languageDetector) {
        this.osmFilePath = osmFilePath;
        this.languageDetector = languageDetector;
    }

    public void runAnalysis() {
        FrequenceExtractor frequenceExtractor = new FrequenceExtractor(this.osmFilePath);
        frequenceExtractor.parseDocument();
        Set<Map.Entry<String, Integer>> frequencyEntries = frequenceExtractor.getFrequency().entrySet();
        this.loadStopWords();
        ArrayList<Map.Entry<String, Integer>> normalizedList = new ArrayList<Map.Entry<String, Integer>>();
        ArrayList<String> sampleList = new ArrayList<String>();
        int iters = 0;
        for (Map.Entry<String, Integer> frequencyEntry : frequencyEntries) {
            if (iters < 10) {
                sampleList.add(frequencyEntry.getKey());
                ++iters;
            }
            if (stopWordsList.contains(frequencyEntry.getKey())) continue;
            String normalizedName = frequencyEntry.getKey().toLowerCase();
            normalizedName = normalizedName.replaceAll("[-+.^:,?;'{}\"!()\\[\\]]", "");
            AbstractMap.SimpleEntry<String, Integer> normalizedEntry = new AbstractMap.SimpleEntry<String, Integer>(normalizedName, frequencyEntry.getValue());
            normalizedList.add(normalizedEntry);
        }
        int en = 0;
        int el = 0;
        for (String word : sampleList) {
            String lang;
            if (word.isEmpty()) continue;
            switch (lang = this.languageDetector.detect(word)) {
                case "en": {
                    ++en;
                    break;
                }
                case "el": {
                    ++el;
                    break;
                }
            }
        }
        normalizedList = el > en ? this.stemGreek(normalizedList) : this.stemEnglish(normalizedList);
        Collections.sort(normalizedList, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        this.setFrequencies(normalizedList);
    }

    private ArrayList<Map.Entry<String, Integer>> stemGreek(ArrayList<Map.Entry<String, Integer>> normalizedList) {
        GreekAnalyzer greekAnalyzer = new GreekAnalyzer(Version.LUCENE_36);
        QueryParser greekParser = new QueryParser(Version.LUCENE_36, "", greekAnalyzer);
        ArrayList<Map.Entry<String, Integer>> stemmedList = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : normalizedList) {
            if (entry.getKey().isEmpty()) continue;
            try {
                String stemmedWord = greekParser.parse(entry.getKey()).toString();
                AbstractMap.SimpleEntry<String, Integer> stemmed = new AbstractMap.SimpleEntry<String, Integer>(stemmedWord, entry.getValue());
                stemmedList.add(stemmed);
            }
            catch (ParseException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stemmedList;
    }

    private ArrayList<Map.Entry<String, Integer>> stemEnglish(ArrayList<Map.Entry<String, Integer>> normalizedList) {
        EnglishAnalyzer englishAnalyzer = new EnglishAnalyzer(Version.LUCENE_36);
        QueryParser englishParser = new QueryParser(Version.LUCENE_36, "", englishAnalyzer);
        ArrayList<Map.Entry<String, Integer>> stemmedList = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : normalizedList) {
            if (entry.getKey().isEmpty()) continue;
            try {
                String stemmedWord = englishParser.parse(entry.getKey()).toString();
                AbstractMap.SimpleEntry<String, Integer> stemmed = new AbstractMap.SimpleEntry<String, Integer>(stemmedWord, entry.getValue());
                stemmedList.add(stemmed);
            }
            catch (ParseException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stemmedList;
    }

    private void loadStopWords() {
        InputStream fstream = Analyzer.class.getResourceAsStream("/resources/files/stopWords.txt");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(fstream));){
            String strLine;
            while ((strLine = br.readLine()) != null) {
                stopWordsList.add(strLine);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Analyzer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setFrequencies(ArrayList<Map.Entry<String, Integer>> frequencies) {
        this.frequencies = frequencies;
    }

    public List<Map.Entry<String, Integer>> getFrequencies() {
        return this.frequencies;
    }

    public List<Map.Entry<String, Integer>> getTopKMostFrequent(int topK) {
        return this.frequencies.subList(0, topK);
    }

    public List<Map.Entry<String, Integer>> getWithFrequency(int minFrequency) {
        ArrayList<Map.Entry<String, Integer>> withFrequency = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : this.frequencies) {
            if (entry.getValue() > minFrequency) {
                withFrequency.add(entry);
                continue;
            }
            return withFrequency;
        }
        return withFrequency;
    }
}

