/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.Locator;
import com.hp.hpl.jena.util.TypedStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorClassLoader
implements Locator {
    static Logger log = LoggerFactory.getLogger(LocatorClassLoader.class);
    private final ClassLoader classLoader;

    public LocatorClassLoader(ClassLoader _classLoader) {
        this.classLoader = _classLoader;
    }

    public boolean equals(Object other) {
        return other instanceof LocatorClassLoader && this.classLoader == ((LocatorClassLoader)other).classLoader;
    }

    public int hashCode() {
        return this.classLoader.hashCode();
    }

    @Override
    public TypedStream open(String filenameOrURI) {
        if (this.classLoader == null) {
            return null;
        }
        String fn = filenameOrURI;
        InputStream in = this.classLoader.getResourceAsStream(fn);
        if (in == null) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("Failed to open: " + filenameOrURI);
            }
            return null;
        }
        if (FileManager.logAllLookups && log.isTraceEnabled()) {
            log.trace("Found: " + filenameOrURI);
        }
        return new TypedStream(in);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String getName() {
        return "ClassLoaderLocator";
    }
}

