/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;

public class AiryProjection
extends Projection {
    private double p_halfpi;
    private double sinph0;
    private double cosph0;
    private double Cb;
    private int mode;
    private boolean no_cut = true;
    private static final double EPS = 1.0E-10;
    private static final int N_POLE = 0;
    private static final int S_POLE = 1;
    private static final int EQUIT = 2;
    private static final int OBLIQ = 3;

    public AiryProjection() {
        this.minLatitude = Math.toRadians(-60.0);
        this.maxLatitude = Math.toRadians(60.0);
        this.minLongitude = Math.toRadians(-90.0);
        this.maxLongitude = Math.toRadians(90.0);
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double sinlam = Math.sin(lplam);
        double coslam = Math.cos(lplam);
        switch (this.mode) {
            case 2: 
            case 3: {
                double Krho;
                double sinphi = Math.sin(lpphi);
                double cosphi = Math.cos(lpphi);
                double cosz = cosphi * coslam;
                if (this.mode == 3) {
                    cosz = this.sinph0 * sinphi + this.cosph0 * cosz;
                }
                if (!this.no_cut && cosz < -1.0E-10) {
                    throw new ProjectionException("F");
                }
                double s = 1.0 - cosz;
                if (Math.abs(s) > 1.0E-10) {
                    double t = 0.5 * (1.0 + cosz);
                    Krho = -Math.log(t) / s - this.Cb / t;
                } else {
                    Krho = 0.5 - this.Cb;
                }
                out.x = Krho * cosphi * sinlam;
                if (this.mode == 3) {
                    out.y = Krho * (this.cosph0 * sinphi - this.sinph0 * cosphi * coslam);
                    break;
                }
                out.y = Krho * sinphi;
                break;
            }
            case 0: 
            case 1: {
                double d;
                out.y = Math.abs(this.p_halfpi - lpphi);
                if (!this.no_cut && lpphi - 1.0E-10 > 1.5707963267948966) {
                    throw new ProjectionException("F");
                }
                out.y *= 0.5;
                if (d > 1.0E-10) {
                    double t = Math.tan(lpphi);
                    double Krho = -2.0 * (Math.log(Math.cos(lpphi)) / t + t * this.Cb);
                    out.x = Krho * sinlam;
                    out.y = Krho * coslam;
                    if (this.mode != 0) break;
                    out.y = -out.y;
                    break;
                }
                out.y = 0.0;
                out.x = 0.0;
            }
        }
        return out;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.no_cut = false;
        double beta = 0.7853981633974483;
        if (Math.abs(beta) < 1.0E-10) {
            this.Cb = -0.5;
        } else {
            this.Cb = 1.0 / Math.tan(beta);
            this.Cb *= this.Cb * Math.log(Math.cos(beta));
        }
        if (Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) < 1.0E-10) {
            if (this.projectionLatitude < 0.0) {
                this.p_halfpi = -1.5707963267948966;
                this.mode = 1;
            } else {
                this.p_halfpi = 1.5707963267948966;
                this.mode = 0;
            }
        } else if (Math.abs(this.projectionLatitude) < 1.0E-10) {
            this.mode = 2;
        } else {
            this.mode = 3;
            this.sinph0 = Math.sin(this.projectionLatitude);
            this.cosph0 = Math.cos(this.projectionLatitude);
        }
    }

    @Override
    public String toString() {
        return "Airy";
    }
}

