/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.commands;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.commands.MapillaryCommand;
import org.openstreetmap.josm.tools.I18n;

public class CommandMoveImage
extends MapillaryCommand {
    private double x;
    private double y;

    public CommandMoveImage(List<MapillaryAbstractImage> images, double x, double y) {
        this.images = new ArrayList<MapillaryAbstractImage>(images);
        this.x = x;
        this.y = y;
    }

    @Override
    public void undo() {
        for (MapillaryAbstractImage image : this.images) {
            image.move(-this.x, -this.y);
            image.stopMoving();
        }
        this.checkModified();
        Main.map.repaint();
    }

    @Override
    public void redo() {
        for (MapillaryAbstractImage image : this.images) {
            image.move(this.x, this.y);
            image.stopMoving();
        }
        this.checkModified();
        Main.map.repaint();
    }

    public String toString() {
        return I18n.trn((String)"Moved {0} image", (String)"Moved {0} images", (long)this.images.size(), (Object[])new Object[]{this.images.size()});
    }

    @Override
    public void sum(MapillaryCommand command) {
        if (command instanceof CommandMoveImage) {
            this.x += ((CommandMoveImage)command).x;
            this.y += ((CommandMoveImage)command).y;
        }
    }
}

