/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillaryExportManager;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryExportDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryExportAction
extends JosmAction {
    MapillaryExportDialog dialog;

    public MapillaryExportAction() {
        super(I18n.tr((String)"Export pictures", (Object[])new Object[0]), new ImageProvider("icon24.png"), I18n.tr((String)"Export pictures", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Export Mapillary", (String)I18n.tr((String)"Export Mapillary pictures", (Object[])new Object[0]), (int)65535, (int)5000), false, "mapillaryExport", false);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        this.dialog = new MapillaryExportDialog();
        JOptionPane pane = new JOptionPane(this.dialog, -1, 2);
        JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Export images", (Object[])new Object[0]));
        dlg.setMinimumSize(new Dimension(400, 150));
        dlg.setVisible(true);
        if (pane.getValue() != null && (Integer)pane.getValue() == 0 && this.dialog.chooser != null) {
            if (this.dialog.group.isSelected(this.dialog.all.getModel())) {
                this.export(MapillaryData.getInstance().getImages());
            } else if (this.dialog.group.isSelected(this.dialog.sequence.getModel())) {
                ArrayList<MapillaryAbstractImage> images = new ArrayList<MapillaryAbstractImage>();
                for (MapillaryAbstractImage image : MapillaryData.getInstance().getMultiSelectedImages()) {
                    if (image instanceof MapillaryImage) {
                        if (images.contains(image)) continue;
                        images.addAll(((MapillaryImage)image).getSequence().getImages());
                        continue;
                    }
                    images.add(image);
                }
                this.export(images);
            } else if (this.dialog.group.isSelected(this.dialog.selected.getModel())) {
                this.export(MapillaryData.getInstance().getMultiSelectedImages());
            }
        } else if (this.dialog.group.isSelected(this.dialog.rewrite.getModel())) {
            ArrayList<MapillaryImportedImage> images = new ArrayList<MapillaryImportedImage>();
            for (MapillaryAbstractImage image : MapillaryData.getInstance().getImages()) {
                if (!(image instanceof MapillaryImportedImage)) continue;
                images.add((MapillaryImportedImage)image);
            }
            try {
                Main.worker.submit(new Thread((Runnable)((Object)new MapillaryExportManager(images))));
            }
            catch (IOException e1) {
                Main.error((Throwable)e1);
            }
        }
        dlg.dispose();
    }

    public void export(List<MapillaryAbstractImage> images) {
        Main.worker.submit(new Thread((Runnable)((Object)new MapillaryExportManager(images, this.dialog.chooser.getSelectedFile().toString()))));
    }
}

