/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JLabel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class HyperlinkLabel
extends JLabel
implements ActionListener {
    private String text;
    private URL url;

    public HyperlinkLabel() {
        super(I18n.tr((String)"View in website", (Object[])new Object[0]), 4);
        this.addActionListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.enableEvents(16L);
    }

    @Override
    public void setText(String text) {
        super.setText("<html><font color=\"#0000CF\" size=\"2\">" + text + "</font></html>");
        this.text = text;
    }

    public void setURL(String key) {
        if (key == null) {
            this.url = null;
            return;
        }
        try {
            this.url = new URL("http://www.mapillary.com/map/im/" + key);
        }
        catch (MalformedURLException e) {
            Main.error((Throwable)e);
        }
    }

    public String getNormalText() {
        return this.text;
    }

    @Override
    protected void processMouseEvent(MouseEvent evt) {
        super.processMouseEvent(evt);
        if (evt.getID() == 500) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getNormalText()));
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    protected void fireActionPerformed(ActionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ActionListener.class) continue;
            ActionListener listener = (ActionListener)listeners[i + 1];
            listener.actionPerformed(evt);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.url == null) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(this.url.toURI());
        }
        catch (IOException | URISyntaxException ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedOperationException ex) {
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec("xdg-open " + this.url);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
    }
}

