/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryPreferenceSetting
implements SubPreferenceSetting {
    private JCheckBox reverseButtons = new JCheckBox(I18n.tr((String)"Reverse buttons position when displaying images.", (Object[])new Object[0]));
    private JCheckBox downloadMode = new JCheckBox(I18n.tr((String)"Download images manually", (Object[])new Object[0]));
    private JCheckBox displayHour = new JCheckBox(I18n.tr((String)"Display hour when the picture was taken", (Object[])new Object[0]));
    private JCheckBox format24 = new JCheckBox(I18n.tr((String)"Use 24 hour format", (Object[])new Object[0]));
    private JCheckBox moveTo = new JCheckBox(I18n.tr((String)"Move to picture's location with next/previous buttons", (Object[])new Object[0]));

    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getDisplayPreference();
    }

    public void addGui(PreferenceTabbedPane gui) {
        JPanel panel = new JPanel();
        this.reverseButtons.setSelected(Main.pref.getBoolean("mapillary.reverse-buttons"));
        this.downloadMode.setSelected(Main.pref.getBoolean("mapillary.download-manually"));
        this.displayHour.setSelected(Main.pref.getBoolean("mapillary.display-hour", true));
        this.format24.setSelected(Main.pref.getBoolean("mapillary.format-24"));
        this.moveTo.setSelected(Main.pref.getBoolean("mapillary.move-to-picture", true));
        panel.setLayout(new FlowLayout(0));
        panel.add(this.reverseButtons);
        panel.add(this.downloadMode);
        panel.add(this.displayHour);
        panel.add(this.format24);
        panel.add(this.moveTo);
        gui.getDisplayPreference().addSubTab((SubPreferenceSetting)this, "Mapillary", (Component)panel);
    }

    public boolean ok() {
        boolean mod = false;
        Main.pref.put("mapillary.reverse-buttons", this.reverseButtons.isSelected());
        Main.pref.put("mapillary.download-manually", this.downloadMode.isSelected());
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.DOWNLOAD_VIEW_MENU, this.downloadMode.isSelected());
        Main.pref.put("mapillary.display-hour", this.displayHour.isSelected());
        Main.pref.put("mapillary.format-24", this.format24.isSelected());
        Main.pref.put("mapillary.move-to-picture", this.moveTo.isSelected());
        return mod;
    }

    public boolean isExpert() {
        return false;
    }
}

