/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillarySquareDownloadManagerThread;

public class MapillarySequenceDownloadThread
implements Runnable {
    private final String url;
    private final ExecutorService ex;
    private final List<Bounds> bounds;
    private final MapillaryLayer layer;
    private final MapillarySquareDownloadManagerThread manager;

    public MapillarySequenceDownloadThread(ExecutorService ex, String url, MapillaryLayer layer, MapillarySquareDownloadManagerThread manager) {
        this.url = url;
        this.ex = ex;
        this.bounds = layer.bounds;
        this.layer = layer;
        this.manager = manager;
    }

    @Override
    public void run() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new URL(this.url).openStream()));
            JsonObject jsonall = Json.createReader((Reader)br).readObject();
            if (!jsonall.getBoolean("more") && !this.ex.isShutdown()) {
                this.ex.shutdown();
            }
            JsonArray jsonseq = jsonall.getJsonArray("ss");
            boolean isSequenceWrong = false;
            for (int i = 0; i < jsonseq.size(); ++i) {
                JsonObject jsonobj = jsonseq.getJsonObject(i);
                JsonArray cas = jsonobj.getJsonArray("cas");
                JsonArray coords = jsonobj.getJsonArray("coords");
                JsonArray keys = jsonobj.getJsonArray("keys");
                ArrayList<MapillaryImage> images = new ArrayList<MapillaryImage>();
                for (int j = 0; j < cas.size(); ++j) {
                    try {
                        images.add(new MapillaryImage(keys.getString(j), coords.getJsonArray(j).getJsonNumber(1).doubleValue(), coords.getJsonArray(j).getJsonNumber(0).doubleValue(), cas.getJsonNumber(j).doubleValue()));
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        Main.warn((String)("Mapillary bug at " + this.url));
                        isSequenceWrong = true;
                    }
                }
                if (!isSequenceWrong) {
                    MapillarySequence sequence = new MapillarySequence(jsonobj.getString("key"), jsonobj.getJsonNumber("captured_at").longValue());
                    ArrayList<MapillaryImage> finalImages = new ArrayList<MapillaryImage>(images);
                    for (MapillaryAbstractImage mapillaryAbstractImage : images) {
                        if (this.isInside(mapillaryAbstractImage)) continue;
                        finalImages.remove(mapillaryAbstractImage);
                    }
                    boolean imagesAdded = false;
                    for (MapillaryImage img : finalImages) {
                        if (this.layer.data.getImages().contains(img)) {
                            ((MapillaryImage)this.layer.data.getImages().get(this.layer.data.getImages().indexOf(img))).setSequence(sequence);
                            finalImages.set(finalImages.indexOf(img), (MapillaryImage)this.layer.data.getImages().get(this.layer.data.getImages().indexOf(img)));
                            continue;
                        }
                        img.setSequence(sequence);
                        imagesAdded = true;
                    }
                    this.manager.imagesAdded = imagesAdded;
                    this.layer.data.addWithoutUpdate(new ArrayList<MapillaryAbstractImage>(finalImages));
                    sequence.add(finalImages);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Main.error((String)("Error reading the url " + this.url + " might be a Mapillary problem."));
        }
    }

    private boolean isInside(MapillaryAbstractImage image) {
        for (int i = 0; i < this.bounds.size(); ++i) {
            if (!this.bounds.get(i).contains(image.getLatLon())) continue;
            return true;
        }
        return false;
    }
}

