/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryMouseAdapter;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryDownloadViewAction;
import org.openstreetmap.josm.plugins.mapillary.cache.MapillaryCache;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillaryDownloader;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryFilterDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryToggleDialog;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryLayer
extends AbstractModifiableLayer
implements DataSetListener,
MapView.EditLayerChangeListener,
MapView.LayerChangeListener {
    public static final int SEQUENCE_MAX_JUMP_DISTANCE = Main.pref.getInteger("mapillary.sequence-max-jump-distance", 100);
    public static MapillaryLayer INSTANCE;
    public static CacheAccess<String, BufferedImageCacheEntry> CACHE;
    public static MapillaryImage BLUE;
    public static MapillaryImage RED;
    private final MapillaryData data = MapillaryData.getInstance();
    public ArrayList<Bounds> bounds;
    private MouseAdapter mouseAdapter;
    private int highlightPointRadius = Main.pref.getInteger("mappaint.highlight.radius", 7);
    private int highlightStep = Main.pref.getInteger("mappaint.highlight.step", 4);
    private volatile TexturePaint hatched;

    public MapillaryLayer() {
        super(I18n.tr((String)"Mapillary Images", (Object[])new Object[0]));
        this.bounds = new ArrayList();
        this.init();
    }

    private void init() {
        INSTANCE = this;
        this.startMouseAdapter();
        try {
            CACHE = JCSCacheManager.getCache((String)"Mapillary");
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
        if (Main.map != null && Main.map.mapView != null) {
            Main.map.mapView.addMouseListener((MouseListener)this.mouseAdapter);
            Main.map.mapView.addMouseMotionListener((MouseMotionListener)this.mouseAdapter);
            Main.map.mapView.addLayer((Layer)this);
            MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)this, (boolean)false);
            MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
            Main.map.mapView.getEditLayer().data.addDataSetListener((DataSetListener)this);
        }
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.EXPORT_MENU, true);
        if (!MapillaryToggleDialog.getInstance().isShowing()) {
            MapillaryToggleDialog.getInstance().getButton().doClick();
        }
        this.createHatchTexture();
        this.data.dataUpdated();
    }

    private void startMouseAdapter() {
        this.mouseAdapter = new MapillaryMouseAdapter();
    }

    public static synchronized MapillaryLayer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MapillaryLayer();
        }
        return INSTANCE;
    }

    public void download() {
        this.checkBigAreas();
        if (Main.pref.getBoolean("mapillary.download-manually")) {
            return;
        }
        for (Bounds bounds : Main.map.mapView.getEditLayer().data.getDataSourceBounds()) {
            if (this.bounds.contains(bounds)) continue;
            this.bounds.add(bounds);
            new MapillaryDownloader().getImages(bounds.getMin(), bounds.getMax());
        }
    }

    private void checkBigAreas() {
        double area = 0.0;
        for (Bounds bounds : Main.map.mapView.getEditLayer().data.getDataSourceBounds()) {
            area += bounds.getArea();
        }
        if (area > MapillaryDownloadViewAction.MAX_AREA) {
            Main.pref.put("mapillary.download-manually", true);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The downloaded OSM area is too big. Download mode has been change to manual. You can change this back to automatic in preferences settings.", (Object[])new Object[0]));
        }
    }

    public MapillaryData getMapillaryData() {
        return this.data;
    }

    public void destroy() {
        MapillaryToggleDialog.getInstance().mapillaryImageDisplay.setImage(null);
        MapillaryToggleDialog.getInstance().updateImage();
        this.data.getImages().clear();
        INSTANCE = null;
        MapillaryData.INSTANCE = null;
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.EXPORT_MENU, false);
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.ZOOM_MENU, false);
        Main.map.mapView.removeMouseListener((MouseListener)this.mouseAdapter);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this.mouseAdapter);
        MapView.removeEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        if (Main.map.mapView.getEditLayer() != null) {
            Main.map.mapView.getEditLayer().data.removeDataSetListener((DataSetListener)this);
        }
        super.destroy();
    }

    public boolean isModified() {
        for (MapillaryAbstractImage image : this.data.getImages()) {
            if (!image.isModified()) continue;
            return true;
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        for (MapillaryAbstractImage img : this.data.getImages()) {
            img.setVisible(visible);
        }
        MapillaryFilterDialog.getInstance().refresh();
    }

    private Color getBackgroundColor() {
        return Main.pref.getColor(I18n.marktr((String)"background"), Color.BLACK);
    }

    private Color getOutsideColor() {
        return Main.pref.getColor(I18n.marktr((String)"outside downloaded area"), Color.YELLOW);
    }

    private void createHatchTexture() {
        BufferedImage bi = new BufferedImage(15, 15, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(this.getBackgroundColor());
        AlphaComposite comp = AlphaComposite.getInstance(3, 0.3f);
        big.setComposite(comp);
        big.fillRect(0, 0, 15, 15);
        big.setColor(this.getOutsideColor());
        big.drawLine(0, 15, 15, 0);
        Rectangle r = new Rectangle(0, 0, 15, 15);
        this.hatched = new TexturePaint(bi, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        MapillaryLayer mapillaryLayer = this;
        synchronized (mapillaryLayer) {
            if (Main.map.mapView.getActiveLayer() == this) {
                Rectangle b = mv.getBounds();
                b.grow(100, 100);
                Area a = new Area(b);
                for (Bounds bounds : this.bounds) {
                    Point p1 = mv.getPoint(bounds.getMin());
                    Point p2 = mv.getPoint(bounds.getMax());
                    Rectangle r = new Rectangle(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y));
                    a.subtract(new Area(r));
                }
                g.setPaint(this.hatched);
                g.fill(a);
            }
            BLUE = null;
            RED = null;
            MapillaryToggleDialog.getInstance().blueButton.setEnabled(false);
            MapillaryToggleDialog.getInstance().redButton.setEnabled(false);
            if (this.data.getSelectedImage() != null) {
                MapillaryImage[] closestImages = this.getClosestImagesFromDifferentSequences();
                Point selected = mv.getPoint(this.data.getSelectedImage().getLatLon());
                if (closestImages[0] != null) {
                    BLUE = closestImages[0];
                    g.setColor(Color.BLUE);
                    g.drawLine(mv.getPoint((LatLon)closestImages[0].getLatLon()).x, mv.getPoint((LatLon)closestImages[0].getLatLon()).y, selected.x, selected.y);
                    MapillaryToggleDialog.getInstance().blueButton.setEnabled(true);
                }
                if (closestImages[1] != null) {
                    RED = closestImages[1];
                    g.setColor(Color.RED);
                    g.drawLine(mv.getPoint((LatLon)closestImages[1].getLatLon()).x, mv.getPoint((LatLon)closestImages[1].getLatLon()).y, selected.x, selected.y);
                    MapillaryToggleDialog.getInstance().redButton.setEnabled(true);
                }
            }
            g.setColor(Color.WHITE);
            for (MapillaryAbstractImage imageAbs : this.data.getImages()) {
                MapillaryAbstractImage image;
                if (!imageAbs.isVisible()) continue;
                Point p = mv.getPoint(imageAbs.getLatLon());
                if (imageAbs instanceof MapillaryImage) {
                    image = (MapillaryImage)imageAbs;
                    Point nextp = null;
                    if (((MapillaryImage)image).getSequence() != null) {
                        MapillaryAbstractImage tempImage = image;
                        while (((MapillaryImage)tempImage).next() != null) {
                            if (!(tempImage = ((MapillaryImage)tempImage).next()).isVisible()) continue;
                            nextp = mv.getPoint(tempImage.getLatLon());
                            break;
                        }
                        if (nextp != null) {
                            g.drawLine(p.x, p.y, nextp.x, nextp.y);
                        }
                    }
                    ImageIcon icon = !this.data.getMultiSelectedImages().contains(image) ? MapillaryPlugin.MAP_ICON : MapillaryPlugin.MAP_ICON_SELECTED;
                    this.draw(g, image, icon, p);
                    if (((MapillaryImage)image).getSigns().isEmpty()) continue;
                    g.drawImage(MapillaryPlugin.MAP_SIGN.getImage(), p.x + icon.getIconWidth() / 2, p.y - icon.getIconHeight() / 2, (ImageObserver)Main.map.mapView);
                    continue;
                }
                if (!(imageAbs instanceof MapillaryImportedImage)) continue;
                image = (MapillaryImportedImage)imageAbs;
                ImageIcon icon = !this.data.getMultiSelectedImages().contains(image) ? MapillaryPlugin.MAP_ICON_IMPORTED : MapillaryPlugin.MAP_ICON_SELECTED;
                this.draw(g, image, icon, p);
            }
        }
    }

    private void drawPointHighlight(Graphics2D g, Point p, int size) {
        Color oldColor = g.getColor();
        Color highlightColor = PaintColors.HIGHLIGHT.get();
        Color highlightColorTransparent = new Color(highlightColor.getRed(), highlightColor.getGreen(), highlightColor.getBlue(), 100);
        g.setColor(highlightColorTransparent);
        for (int s = size + this.highlightPointRadius; s >= size; s -= this.highlightStep) {
            int r = (int)Math.floor((double)s / 2.0);
            g.fillRoundRect(p.x - r, p.y - r, s, s, r, r);
        }
        g.setColor(oldColor);
    }

    private void draw(Graphics2D g, MapillaryAbstractImage image, ImageIcon icon, Point p) {
        Image imagetemp = icon.getImage();
        BufferedImage bi = (BufferedImage)imagetemp;
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        double rotationRequired = Math.toRadians(image.getCa());
        double locationX = width / 2;
        double locationY = height / 2;
        AffineTransform tx = AffineTransform.getRotateInstance(rotationRequired, locationX, locationY);
        AffineTransformOp op = new AffineTransformOp(tx, 2);
        g.drawImage((Image)op.filter(bi, null), p.x - width / 2, p.y - height / 2, (ImageObserver)Main.map.mapView);
        if (this.data.getHoveredImage() == image) {
            this.drawPointHighlight(g, p, 16);
        }
    }

    public Icon getIcon() {
        return MapillaryPlugin.ICON16;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
        throw new UnsupportedOperationException("This layer does not support merging yet");
    }

    public Action[] getMenuEntries() {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(LayerListDialog.getInstance().createShowHideLayerAction());
        actions.add(LayerListDialog.getInstance().createDeleteLayerAction());
        actions.add(new LayerListPopup.InfoAction((Layer)this));
        return actions.toArray(new Action[actions.size()]);
    }

    private MapillaryImage[] getClosestImagesFromDifferentSequences() {
        if (!(this.data.getSelectedImage() instanceof MapillaryImage)) {
            return new MapillaryImage[2];
        }
        MapillaryImage selected = (MapillaryImage)this.data.getSelectedImage();
        MapillaryImage[] ret = new MapillaryImage[2];
        double[] distances = new double[]{SEQUENCE_MAX_JUMP_DISTANCE, SEQUENCE_MAX_JUMP_DISTANCE};
        LatLon selectedCoords = this.data.getSelectedImage().getLatLon();
        for (MapillaryAbstractImage imagePrev : this.data.getImages()) {
            MapillaryImage image;
            if (!(imagePrev instanceof MapillaryImage) || !imagePrev.isVisible() || !((image = (MapillaryImage)imagePrev).getLatLon().greatCircleDistance(selectedCoords) < (double)SEQUENCE_MAX_JUMP_DISTANCE) || selected.getSequence() == image.getSequence()) continue;
            if (ret[0] == null && ret[1] == null || image.getLatLon().greatCircleDistance(selectedCoords) < distances[0] && (ret[1] == null || image.getSequence() != ret[1].getSequence())) {
                ret[0] = image;
                distances[0] = image.getLatLon().greatCircleDistance(selectedCoords);
                continue;
            }
            if (ret[1] != null && !(image.getLatLon().greatCircleDistance(selectedCoords) < distances[1]) || image.getSequence() == ret[0].getSequence()) continue;
            ret[1] = image;
            distances[1] = image.getLatLon().greatCircleDistance(selectedCoords);
        }
        if (ret[0] != null) {
            new MapillaryCache(ret[0].getKey(), MapillaryCache.Type.THUMBNAIL).submit(this.data, false);
        }
        if (ret[1] != null) {
            new MapillaryCache(ret[1].getKey(), MapillaryCache.Type.THUMBNAIL).submit(this.data, false);
        }
        return ret;
    }

    public Object getInfoComponent() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.tr((String)"Mapillary layer", (Object[])new Object[0]));
        sb.append("\n");
        sb.append(I18n.tr((String)"Total images:", (Object[])new Object[0]));
        sb.append(" ");
        sb.append(this.data.size());
        sb.append("\n");
        return sb.toString();
    }

    public String getToolTipText() {
        return this.data.size() + " " + I18n.tr((String)"images", (Object[])new Object[0]);
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
    }

    public void dataChanged(DataChangedEvent event) {
        Main.worker.submit(new delayedDownload());
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
    }

    public void tagsChanged(TagsChangedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer == this) {
            if (this.data.size() > 0) {
                Main.map.statusLine.setHelpText(I18n.tr((String)"Total images: {0}", (Object[])new Object[]{this.data.size()}));
            } else {
                Main.map.statusLine.setHelpText(I18n.tr((String)"No images found", (Object[])new Object[0]));
            }
        }
    }

    public void layerAdded(Layer newLayer) {
    }

    public void layerRemoved(Layer oldLayer) {
    }

    private class delayedDownload
    extends Thread {
        private delayedDownload() {
        }

        @Override
        public void run() {
            try {
                delayedDownload.sleep(1000L);
            }
            catch (InterruptedException e) {
                Main.error((Throwable)e);
            }
            MapillaryLayer.getInstance().download();
        }
    }
}

