/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;

public class MapillarySequenceDownloadThread
implements Runnable {
    private String url;
    private ExecutorService ex;
    private List<Bounds> bounds;

    public MapillarySequenceDownloadThread(ExecutorService ex, String url) {
        this.url = url;
        this.ex = ex;
        this.bounds = MapillaryLayer.getInstance().bounds;
    }

    @Override
    public void run() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new URL(this.url).openStream()));
            JsonObject jsonall = Json.createReader((Reader)br).readObject();
            if (!jsonall.getBoolean("more") && !this.ex.isShutdown()) {
                this.ex.shutdown();
            }
            JsonArray jsonseq = jsonall.getJsonArray("ss");
            boolean isSequenceWrong = false;
            for (int i = 0; i < jsonseq.size(); ++i) {
                JsonObject jsonobj = jsonseq.getJsonObject(i);
                JsonArray cas = jsonobj.getJsonArray("cas");
                JsonArray coords = jsonobj.getJsonArray("coords");
                JsonArray keys = jsonobj.getJsonArray("keys");
                ArrayList<MapillaryImage> images = new ArrayList<MapillaryImage>();
                for (int j = 0; j < cas.size(); ++j) {
                    try {
                        images.add(new MapillaryImage(keys.getString(j), coords.getJsonArray(j).getJsonNumber(1).doubleValue(), coords.getJsonArray(j).getJsonNumber(0).doubleValue(), cas.getJsonNumber(j).doubleValue()));
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        Main.warn((String)("Mapillary bug at " + this.url));
                        isSequenceWrong = true;
                    }
                }
                if (!isSequenceWrong) {
                    MapillarySequence sequence = new MapillarySequence(jsonobj.getString("key"), jsonobj.getJsonNumber("captured_at").longValue());
                    ArrayList<MapillaryImage> finalImages = new ArrayList<MapillaryImage>(images);
                    for (MapillaryAbstractImage mapillaryAbstractImage : images) {
                        if (this.isInside(mapillaryAbstractImage)) continue;
                        finalImages.remove(mapillaryAbstractImage);
                    }
                    for (MapillaryImage mapillaryImage : finalImages) {
                        MapillaryData.getInstance().getImages().remove(mapillaryImage);
                        mapillaryImage.setSequence(sequence);
                    }
                    MapillaryData.getInstance().addWithoutUpdate(new ArrayList<MapillaryAbstractImage>(finalImages));
                    sequence.add(finalImages);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Main.error((String)("Error reading the url " + this.url + " might be a Mapillary problem."));
        }
    }

    private boolean isInside(MapillaryAbstractImage image) {
        for (int i = 0; i < this.bounds.size(); ++i) {
            if (!this.bounds.get(i).contains(image.getLatLon())) continue;
            return true;
        }
        return false;
    }
}

