/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;

public class MapillaryImageInfoDownloaderThread
implements Runnable {
    private final String url;
    private final ExecutorService ex;

    public MapillaryImageInfoDownloaderThread(ExecutorService ex, String url) {
        this.ex = ex;
        this.url = url;
    }

    @Override
    public void run() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new URL(this.url).openStream()));
            JsonObject jsonobj = Json.createReader((Reader)br).readObject();
            if (!jsonobj.getBoolean("more")) {
                this.ex.shutdown();
            }
            JsonArray jsonarr = jsonobj.getJsonArray("ims");
            for (int i = 0; i < jsonarr.size(); ++i) {
                JsonObject data = jsonarr.getJsonObject(i);
                String key = data.getString("key");
                for (MapillaryAbstractImage image : MapillaryData.getInstance().getImages()) {
                    if (!(image instanceof MapillaryImage) || !((MapillaryImage)image).getKey().equals(key)) continue;
                    ((MapillaryImage)image).setUser(data.getString("user"));
                    ((MapillaryImage)image).setCapturedAt(data.getJsonNumber("captured_at").longValue());
                }
            }
        }
        catch (MalformedURLException e) {
            Main.error((Throwable)e);
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
    }
}

