/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagerycache;

import java.io.File;
import java.util.Map;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.josm.data.imagery.CachedTileLoaderFactory;
import org.openstreetmap.josm.data.imagery.TileLoaderFactory;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.imagerycache.OsmDBTilesLoader;

public class ImageryCachePlugin
extends Plugin {
    TileLoaderFactory factory = new TileLoaderFactory(){

        public OsmTileLoader makeTileLoader(TileLoaderListener listener) {
            String cachePath = CachedTileLoaderFactory.PROP_TILECACHE_DIR.get();
            try {
                new File(cachePath).mkdirs();
            }
            catch (Exception e) {
                cachePath = ".";
            }
            if (cachePath != null && !cachePath.isEmpty()) {
                return new OsmDBTilesLoader(listener, new File(cachePath));
            }
            return null;
        }

        public TileLoader makeTileLoader(TileLoaderListener listener, Map<String, String> headers) {
            return this.makeTileLoader(listener);
        }
    };

    public ImageryCachePlugin(PluginInformation info) {
        super(info);
        TMSLayer.setTileLoaderFactory((TileLoaderFactory)this.factory);
    }

    public static void main(String[] args) {
        System.out.println("Debugging code for ImageryAdjust plugin");
    }
}

