/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDataListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.cache.MapillaryCache;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryImageDisplay;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryToggleDialog
extends ToggleDialog
implements ICachedLoaderListener,
MapillaryDataListener {
    public static final int NORMAL_MODE = 0;
    public static final int SIGN_MODE = 1;
    public static final String BASE_TITLE = "Mapillary picture";
    public static MapillaryToggleDialog INSTANCE;
    public volatile MapillaryAbstractImage image;
    public final SideButton nextButton = new SideButton((Action)new nextPictureAction());
    public final SideButton previousButton = new SideButton((Action)new previousPictureAction());
    public final SideButton redButton = new SideButton((Action)new redAction());
    public final SideButton blueButton = new SideButton((Action)new blueAction());
    private List<SideButton> normalMode;
    public final SideButton nextSignButton = new SideButton((Action)new NextSignAction());
    public final SideButton previousSignButton = new SideButton((Action)new PreviousSignAction());
    private List<SideButton> signMode;
    private int mode;
    private JPanel buttonsPanel;
    public MapillaryImageDisplay mapillaryImageDisplay;
    private MapillaryCache imageCache;
    private MapillaryCache thumbnailCache;

    public MapillaryToggleDialog() {
        super(I18n.tr((String)BASE_TITLE, (Object[])new Object[0]), "mapillary.png", I18n.tr((String)"Open Mapillary window", (Object[])new Object[0]), Shortcut.registerShortcut((String)I18n.tr((String)"Mapillary dialog", (Object[])new Object[0]), (String)I18n.tr((String)"Open Mapillary main dialog", (Object[])new Object[0]), (int)77, (int)5000), 200);
        MapillaryData.getInstance().addListener(this);
        this.mapillaryImageDisplay = new MapillaryImageDisplay();
        this.blueButton.setForeground(Color.BLUE);
        this.redButton.setForeground(Color.RED);
        this.normalMode = Arrays.asList(this.blueButton, this.previousButton, this.nextButton, this.redButton);
        this.signMode = Arrays.asList(this.previousSignButton, this.nextSignButton);
        this.mode = 0;
        this.createLayout(this.mapillaryImageDisplay, this.normalMode, Main.pref.getBoolean("mapillary.reverse-buttons"));
        this.disableAllButtons();
    }

    public static MapillaryToggleDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MapillaryToggleDialog();
        }
        return INSTANCE;
    }

    public static void destroyInstance() {
        INSTANCE = null;
    }

    public void switchMode() {
        this.removeAll();
        List<SideButton> list = null;
        if (this.mode == 0) {
            list = this.signMode;
            this.mode = 1;
        } else if (this.mode == 1) {
            list = this.normalMode;
            this.mode = 0;
        }
        this.createLayout(this.mapillaryImageDisplay, list, Main.pref.getBoolean("mapillary.reverse-buttons"));
        this.disableAllButtons();
        this.updateImage();
    }

    public synchronized void updateImage() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapillaryToggleDialog.this.updateImage();
                }
            });
        } else {
            if (MapillaryLayer.INSTANCE == null) {
                return;
            }
            if (this.image == null) {
                this.mapillaryImageDisplay.setImage(null);
                this.setTitle(I18n.tr((String)BASE_TITLE, (Object[])new Object[0]));
                this.disableAllButtons();
                return;
            }
            if (this.image instanceof MapillaryImage) {
                this.mapillaryImageDisplay.hyperlink.setVisible(true);
                MapillaryImage mapillaryImage = (MapillaryImage)this.image;
                String title = I18n.tr((String)BASE_TITLE, (Object[])new Object[0]);
                if (mapillaryImage.getUser() != null) {
                    title = title + " -- " + mapillaryImage.getUser();
                }
                if (mapillaryImage.getCapturedAt() != 0L) {
                    title = title + " -- " + mapillaryImage.getDate();
                }
                this.setTitle(title);
                if (this.mode == 0) {
                    this.nextButton.setEnabled(true);
                    this.previousButton.setEnabled(true);
                    if (mapillaryImage.next() == null) {
                        this.nextButton.setEnabled(false);
                    }
                    if (mapillaryImage.previous() == null) {
                        this.previousButton.setEnabled(false);
                    }
                } else if (this.mode == 1) {
                    this.previousSignButton.setEnabled(true);
                    this.nextSignButton.setEnabled(true);
                    int i = MapillaryData.getInstance().getImages().indexOf(MapillaryData.getInstance().getSelectedImage());
                    int first = -1;
                    int last = -1;
                    int c = 0;
                    for (MapillaryAbstractImage img : MapillaryData.getInstance().getImages()) {
                        if (img instanceof MapillaryImage && !((MapillaryImage)img).getSigns().isEmpty()) {
                            if (first == -1) {
                                first = c;
                            }
                            last = c;
                        }
                        ++c;
                    }
                    if (first >= i) {
                        this.previousSignButton.setEnabled(false);
                    }
                    if (last <= i) {
                        this.nextSignButton.setEnabled(false);
                    }
                }
                this.mapillaryImageDisplay.hyperlink.setURL(mapillaryImage.getKey());
                this.mapillaryImageDisplay.setImage(null);
                if (this.thumbnailCache != null) {
                    this.thumbnailCache.cancelOutstandingTasks();
                }
                this.thumbnailCache = new MapillaryCache(mapillaryImage.getKey(), MapillaryCache.Type.THUMBNAIL);
                this.thumbnailCache.submit(this, false);
                if (this.imageCache != null) {
                    this.imageCache.cancelOutstandingTasks();
                }
                this.imageCache = new MapillaryCache(mapillaryImage.getKey(), MapillaryCache.Type.FULL_IMAGE);
                this.imageCache.submit(this, false);
            } else if (this.image instanceof MapillaryImportedImage) {
                this.mapillaryImageDisplay.hyperlink.setVisible(false);
                this.nextButton.setEnabled(false);
                this.previousButton.setEnabled(false);
                MapillaryImportedImage mapillaryImage = (MapillaryImportedImage)this.image;
                try {
                    this.mapillaryImageDisplay.setImage(mapillaryImage.getImage());
                }
                catch (IOException e) {
                    Main.error((Throwable)e);
                }
                this.mapillaryImageDisplay.hyperlink.setURL(null);
            }
        }
    }

    private void disableAllButtons() {
        this.nextButton.setEnabled(false);
        this.previousButton.setEnabled(false);
        this.blueButton.setEnabled(false);
        this.redButton.setEnabled(false);
        this.nextSignButton.setEnabled(false);
        this.previousSignButton.setEnabled(false);
        this.mapillaryImageDisplay.hyperlink.setVisible(false);
    }

    public synchronized void setImage(MapillaryAbstractImage image) {
        this.image = image;
    }

    public synchronized MapillaryAbstractImage getImage() {
        return this.image;
    }

    public void loadingFinished(CacheEntry data, CacheEntryAttributes attributes, ICachedLoaderListener.LoadResult result) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapillaryToggleDialog.this.updateImage();
                }
            });
        } else if (data != null && result == ICachedLoaderListener.LoadResult.SUCCESS) {
            try {
                BufferedImage img = ImageIO.read(new ByteArrayInputStream(data.getContent()));
                if (this.mapillaryImageDisplay.getImage() == null) {
                    this.mapillaryImageDisplay.setImage(img);
                } else if (img.getHeight() > this.mapillaryImageDisplay.getImage().getHeight()) {
                    this.mapillaryImageDisplay.setImage(img);
                }
            }
            catch (IOException e) {
                Main.error((Throwable)e);
            }
        }
    }

    public void createLayout(Component data, List<SideButton> buttons, boolean reverse) {
        this.removeAll();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(data, "Center");
        if (reverse) {
            this.buttonsPanel = new JPanel(new GridLayout(1, 1));
            if (!buttons.isEmpty() && buttons.get(0) != null) {
                JPanel buttonRowPanel = new JPanel(Main.pref.getBoolean("dialog.align.left", false) ? new FlowLayout(0) : new GridLayout(1, buttons.size()));
                this.buttonsPanel.add(buttonRowPanel);
                for (SideButton button : buttons) {
                    buttonRowPanel.add((Component)button);
                }
            }
            panel.add((Component)this.buttonsPanel, "North");
            this.createLayout(panel, true, null);
        } else {
            this.createLayout(panel, true, buttons);
        }
        this.add((Component)this.titleBar, "North");
    }

    @Override
    public void selectedImageChanged(MapillaryAbstractImage oldImage, MapillaryAbstractImage newImage) {
        this.setImage(MapillaryData.getInstance().getSelectedImage());
        this.updateImage();
    }

    class PreviousSignAction
    extends AbstractAction {
        public PreviousSignAction() {
            this.putValue("Name", I18n.tr((String)"Previous Sign", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Jumps to the previous picture that contains a sign", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapillaryToggleDialog.getInstance().getImage() != null) {
                int i = MapillaryData.getInstance().getImages().indexOf(MapillaryData.getInstance().getSelectedImage());
                for (int j = i - 1; j >= 0; --j) {
                    MapillaryAbstractImage img = MapillaryData.getInstance().getImages().get(j);
                    if (!(img instanceof MapillaryImage) || ((MapillaryImage)img).getSigns().isEmpty()) continue;
                    MapillaryData.getInstance().setSelectedImage(img, true);
                    return;
                }
            }
        }
    }

    class NextSignAction
    extends AbstractAction {
        public NextSignAction() {
            this.putValue("Name", I18n.tr((String)"Next Sign", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Jumps to the next picture that contains a sign", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapillaryToggleDialog.getInstance().getImage() != null) {
                int i = MapillaryData.getInstance().getImages().indexOf(MapillaryData.getInstance().getSelectedImage());
                for (int j = i + 1; j < MapillaryData.getInstance().getImages().size(); ++j) {
                    MapillaryAbstractImage img = MapillaryData.getInstance().getImages().get(j);
                    if (!(img instanceof MapillaryImage) || ((MapillaryImage)img).getSigns().isEmpty()) continue;
                    MapillaryData.getInstance().setSelectedImage(img, true);
                    return;
                }
            }
        }
    }

    class blueAction
    extends AbstractAction {
        public blueAction() {
            this.putValue("Name", I18n.tr((String)"Jump to blue", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Jumps to the picture at the other side of the blue line", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapillaryToggleDialog.getInstance().getImage() != null) {
                MapillaryData.getInstance().setSelectedImage(MapillaryLayer.BLUE, true);
            }
        }
    }

    class redAction
    extends AbstractAction {
        public redAction() {
            this.putValue("Name", I18n.tr((String)"Jump to red", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Jumps to the picture at the other side of the red line", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapillaryToggleDialog.getInstance().getImage() != null) {
                MapillaryData.getInstance().setSelectedImage(MapillaryLayer.RED, true);
            }
        }
    }

    class previousPictureAction
    extends AbstractAction {
        public previousPictureAction() {
            this.putValue("Name", I18n.tr((String)"Previous picture", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Shows the previous picture in the sequence", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapillaryToggleDialog.getInstance().getImage() != null) {
                MapillaryData.getInstance().selectPrevious();
            }
        }
    }

    class nextPictureAction
    extends AbstractAction {
        public nextPictureAction() {
            this.putValue("Name", I18n.tr((String)"Next picture", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Shows the next picture in the sequence", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapillaryToggleDialog.getInstance().getImage() != null) {
                MapillaryData.getInstance().selectNext();
            }
        }
    }
}

